/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.unittest.IJUnitTestPlugIn;
import kd.bos.form.unittest.IKDUnitTestScriptPlugIn;
import kd.bos.script.ScriptExecutor;
import kd.bos.unittest.KDUnitTestScriptPlugIn;
import kd.bos.unittest.KDUnitTestScriptPlugInHelper;

public class ScriptPluginBuildHelper {
    private static final String env_script = "/FormPluginImport.js";
    public static final String UNIT_TEST_SCRIPT_MODULE_CONF = "/UnitTestScriptModule.conf";
    private static String envScript;
    private ScriptExecutor scriptExecutor;

    public static String getContent(InputStream in) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        String line = null;
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append('\n');
        }
        in.close();
        return sb.toString();
    }

    private void getjs() {
        try (InputStream in = FormConfig.class.getResourceAsStream(env_script);){
            envScript = ScriptPluginBuildHelper.getContent(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public IJUnitTestPlugIn createScriptPlugin(String formId, String scriptName) {
        String script = FormMetadataCache.getFormPluginScripts((String)formId, (String)scriptName);
        this.getjs();
        if (this.scriptExecutor == null) {
            this.scriptExecutor = ScriptExecutor.create();
            this.scriptExecutor.init(ctx -> ctx.require(new String[]{UNIT_TEST_SCRIPT_MODULE_CONF}));
            this.scriptExecutor.begin();
        }
        this.scriptExecutor.exec(new String[]{envScript, script});
        IJUnitTestPlugIn kdijp = (IJUnitTestPlugIn)this.scriptExecutor.getContext().get("plugin");
        IJUnitTestPlugIn ijp = (IJUnitTestPlugIn)this.scriptExecutor.getContext().get("context");
        return kdijp;
    }

    public IJUnitTestPlugIn createScriptPluginByScriptContext(String contextScript) {
        this.getjs();
        if (this.scriptExecutor == null) {
            this.scriptExecutor = ScriptExecutor.create();
            this.scriptExecutor.init(ctx -> ctx.require(new String[]{UNIT_TEST_SCRIPT_MODULE_CONF}));
            this.scriptExecutor.begin();
        }
        this.scriptExecutor.exec(new String[]{envScript, contextScript});
        return (IJUnitTestPlugIn)this.scriptExecutor.getContext().get("plugin");
    }

    public IJUnitTestPlugIn createScriptPluginByScriptContext1(String contextScript) {
        this.getjs();
        if (this.scriptExecutor == null) {
            this.scriptExecutor = ScriptExecutor.create();
            this.scriptExecutor.init(ctx -> ctx.require(new String[]{UNIT_TEST_SCRIPT_MODULE_CONF}));
            this.scriptExecutor.begin();
        }
        this.scriptExecutor.exec(new String[]{envScript, contextScript});
        IJUnitTestPlugIn plugin = (IJUnitTestPlugIn)this.scriptExecutor.getContext().get("$this");
        KDUnitTestScriptPlugInHelper context = (KDUnitTestScriptPlugInHelper)this.scriptExecutor.getContext().get("plugin");
        ((KDUnitTestScriptPlugIn)plugin).initPlugin((IKDUnitTestScriptPlugIn)context.getPlugin());
        ((KDUnitTestScriptPlugIn)plugin).initScriptExecutor(this.scriptExecutor);
        return plugin;
    }

    public void destory() {
        if (this.scriptExecutor != null) {
            this.scriptExecutor.end();
        }
    }

    public Object invoke(String name, Object ... args) {
        return this.scriptExecutor.call(name, args);
    }
}

