/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BOSRuntime;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.metadata.entity.BaseEntity;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.CityField;
import kd.bos.metadata.entity.businessfield.CreaterField;
import kd.bos.metadata.entity.businessfield.ModifierField;
import kd.bos.metadata.entity.businessfield.OrgField;
import kd.bos.metadata.entity.businessfield.UserField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.bill.BillView;
import kd.bos.report.IReportView;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import org.junit.Test;

public class UnitTestCommonPlugIn
extends AbstractJUnitTestPlugIn {
    public static final String BOS_UNITTEST_PLUGIN = "bos-unittest-plugin";
    public static final String LINE_SEPARATOR = "line.separator";
    public static final String DESCRIPTION = "\u5b57\u6bb5<{%s(%s)}>\u7f3a\u7701\u503c\u672a\u80fd\u6b63\u786e\u8bbe\u7f6e";

    @TestMethod(value=0)
    @DisplayName(value="\u6d4b\u8bd5\u5b57\u6bb5\u7f3a\u7701\u503c\u529f\u80fd")
    @Test
    public void testDefaultValue() throws Exception {
        IFormView view = this.getView();
        UnitTestCommonPlugIn.assertNotNull(ResManager.loadKDString((String)"\u5f02\u5e38\u6765\u81ea\u6d4b\u8bd5\u6846\u67b6\u57fa\u7840\u7528\u4f8b(testDefaultValue)\uff1a\u83b7\u53d6\u5f53\u524d\u6d4b\u8bd5\u8868\u5355\u7684VIEW\u4e3aNULL", (String)"UnitTestCommonPlugIn_0", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]), view);
        if (view instanceof IReportView) {
            return;
        }
        IDataModel model = this.getView().getModel();
        List lstItems = this.getEntityMetadata().getItems();
        for (EntityItem entityItem : lstItems) {
            int count;
            if (entityItem instanceof BaseEntity || entityItem instanceof BillEntity) continue;
            if ((entityItem instanceof EntryEntity || entityItem instanceof SubEntryEntity) && 0 == (count = model.getEntryRowCount(entityItem.getKey()))) {
                model.createNewEntryRow(entityItem.getKey());
            }
            if (entityItem instanceof CheckBoxField) {
                Boolean defValue = ((CheckBoxField)entityItem).getDefValue();
                UnitTestCommonPlugIn.assertNotNull(ResManager.loadKDString((String)"\u5f02\u5e38\u6765\u81ea\u6d4b\u8bd5\u6846\u67b6\u57fa\u7840\u7528\u4f8b(testDefaultValue)\uff1aCheckBoxField\u7c7b\u578b\u5b9e\u4f53\u5c5e\u6027\u4e3aNULL\uff0c\u5b9e\u4f53KEY\uff1a", (String)"UnitTestCommonPlugIn_1", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]) + entityItem.getKey(), defValue);
                if (!defValue.booleanValue()) continue;
                Object value = model.getValue(entityItem.getKey(), 0);
                this.isNotNull(value, String.format(ResManager.loadKDString((String)DESCRIPTION, (String)"UnitTestCommonPlugIn_2", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]), entityItem.getName(), entityItem.getKey()));
                continue;
            }
            DynamicProperty dyp = model.getDataEntityType().getProperty(entityItem.getKey());
            if (dyp == null) continue;
            if (dyp instanceof EntryProp) {
                DataEntityPropertyCollection dypItem = ((EntryProp)dyp).getDynamicCollectionItemPropertyType().getProperties();
                for (IDataEntityProperty iDataEntityProperty : dypItem) {
                    Object defvalue = ((DynamicProperty)iDataEntityProperty).getDefaultValue();
                    if (defvalue == null) continue;
                    Object value = model.getValue(entityItem.getKey(), 0);
                    this.isNotNull(value, String.format(ResManager.loadKDString((String)DESCRIPTION, (String)"UnitTestCommonPlugIn_2", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]), entityItem.getName(), entityItem.getKey()));
                }
                continue;
            }
            Object defvalue = dyp.getDefaultValue();
            if (defvalue == null) continue;
            Object value = model.getValue(entityItem.getKey(), 0);
            this.isNotNull(value, String.format(ResManager.loadKDString((String)DESCRIPTION, (String)"UnitTestCommonPlugIn_2", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]), entityItem.getName(), entityItem.getKey()));
        }
    }

    @TestMethod(value=1)
    @DisplayName(value="\u6d4b\u8bd5F7\u529f\u80fd")
    @Test
    public void testF7ButtonClick() throws Exception {
        IFormView view = this.getView();
        UnitTestCommonPlugIn.assertNotNull(ResManager.loadKDString((String)"\u5f02\u5e38\u6765\u81ea\u6d4b\u8bd5\u6846\u67b6\u57fa\u7840\u7528\u4f8b(testF7ButtonClick)\uff1a\u83b7\u53d6\u5f53\u524d\u6d4b\u8bd5\u8868\u5355\u7684VIEW\u4e3aNULL", (String)"UnitTestCommonPlugIn_3", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]), view);
        if (view instanceof IReportView) {
            return;
        }
        FormRoot fRoot = FormMetadataCache.getRootControl((String)this.getView().getFormShowParameter().getFormId());
        Set<String> setCtlKeys = this.getFormListControl(fRoot);
        List lstItems2 = this.getEntityMetadata().getItems();
        for (EntityItem entityItem : lstItems2) {
            boolean bCancel;
            if (!(entityItem instanceof BasedataField) || !setCtlKeys.contains(entityItem.getKey()) || entityItem instanceof CreaterField || entityItem instanceof ModifierField || entityItem instanceof UserField || entityItem instanceof CityField || (bCancel = this.beforeTestF7ButtonClick(this.getEntityMetadata(), (BasedataField)entityItem))) continue;
            String ret = this.getFormService().invokeAction(this.getView().getPageId(), entityItem.getKey(), "click", new Object[0], new ArrayList());
            List list = (List)SerializationUtils.fromJsonString((String)ret, List.class);
            String msg = ResManager.loadKDString((String)"\u63a7\u4ef6KEY:", (String)"UnitTestCommonPlugIn_4", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]) + entityItem.getKey() + ResManager.loadKDString((String)", \u540d\u79f0:", (String)"UnitTestCommonPlugIn_5", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]) + entityItem.getName();
            if (list == null) {
                UnitTestCommonPlugIn.fail(msg + ResManager.loadKDString((String)" F7\u6253\u5f00\u57fa\u7840\u8d44\u6599\u5931\u8d25~", (String)"UnitTestCommonPlugIn_6", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]));
            } else {
                try {
                    for (Map ob : list) {
                        List lstRet;
                        Map mapPageInfo;
                        String f7PageId;
                        String opType = (String)ob.get("a");
                        if (!"showForm".equals(opType) || !StringUtils.isNotBlank((CharSequence)(f7PageId = (String)(mapPageInfo = (Map)(lstRet = (List)ob.get("p")).get(0)).get("pageId")))) continue;
                        IFormView formView = SessionManager.getCurrent().getViewNoPlugin(f7PageId);
                        formView.close();
                        break;
                    }
                }
                catch (Exception e) {
                    UnitTestCommonPlugIn.fail(msg + ResManager.loadKDString((String)" \u89e3\u6790F7\u6253\u5f00\u57fa\u7840\u8d44\u6599\u7684\u8fd4\u56de\u503c\u5931\u8d25~,\u8fd4\u56de\u5185\u5bb9\uff1a\n", (String)"UnitTestCommonPlugIn_7", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]) + ret + "\n" + this.getErrorInfoFromException(e));
                }
            }
            UnitTestCommonPlugIn.assertInvokeActionWithMsg(ret, msg);
        }
    }

    private Set<String> getFormListControl(FormRoot fRoot) {
        HashSet<String> lstControls = new HashSet<String>();
        List lstRootItems = fRoot.getItems();
        this.getBasedataEditControlFromControl(lstRootItems, lstControls);
        return lstControls;
    }

    private void getBasedataEditControlFromControl(List<Control> lstCtls, Set<String> setCtlKeys) {
        if (lstCtls == null || lstCtls.size() == 0) {
            return;
        }
        for (Control ctr : lstCtls) {
            if (ctr instanceof BasedataEdit) {
                setCtlKeys.add(ctr.getKey());
                continue;
            }
            if (!(ctr instanceof Container)) continue;
            List lst = ((Container)ctr).getItems();
            this.getBasedataEditControlFromControl(lst, setCtlKeys);
        }
    }

    private String getRuntimeVersion() {
        return BOSRuntime.getVersion() + System.currentTimeMillis();
    }

    @TestMethod(value=2)
    @DisplayName(value="\u6d4b\u8bd5\u5143\u6570\u636e\u5b8c\u6574\u6027")
    @Test
    public void testMetadataIntegrity() {
        FormMetadata fmd = this.getFormMetadata();
        UnitTestCommonPlugIn.assertNotNull(ResManager.loadKDString((String)"\u5f02\u5e38\u6765\u81ea\u6d4b\u8bd5\u6846\u67b6\u57fa\u7840\u7528\u4f8b(testMetadataIntegrity)\uff1a\u83b7\u53d6\u5f53\u524d\u6d4b\u8bd5\u8868\u5355\u7684\u8bbe\u8ba1\u65f6\u5143\u6570\u636e\u4e3aNULL", (String)"UnitTestCommonPlugIn_8", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]), fmd);
        fmd.buildRuntimeMetadata(this.getRuntimeVersion());
        List lstError = this.getFormMetadata().getBuildErrors();
        if (lstError.size() > 0) {
            ArrayList<String> lstErrMessage = new ArrayList<String>(10);
            lstErrMessage.add(String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e\u52a0\u8f7d\u4e0d\u5b8c\u6574", (String)"UnitTestCommonPlugIn_9", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]), new Object[0]));
            for (ErrorInfo error : lstError) {
                lstErrMessage.add(String.format("ErrorInfo: Type{%s}, Msg{%s}", error.getType(), error.getError()));
            }
            if (lstErrMessage.size() > 0) {
                String lineSeparator = System.getProperty(LINE_SEPARATOR, "\n");
                throw new RuntimeException(String.join((CharSequence)lineSeparator, lstErrMessage));
            }
        }
    }

    private boolean beforeTestF7ButtonClick(EntityMetadata entityMetadata, BasedataField bf) {
        int iEntryRowCount;
        int iEntryRowCount2;
        boolean cancel = false;
        String parentId = bf.getParentId();
        EntityItem entityItem = entityMetadata.getItemById(parentId);
        if (entityItem instanceof EntryEntity && (iEntryRowCount2 = this.getView().getModel().getEntryRowCount(entityItem.getKey())) <= 0) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)bf.getOrgFieldId())) {
            return cancel;
        }
        OrgField orgField = (OrgField)entityMetadata.getItemById(bf.getOrgFieldId());
        if (orgField == null) {
            return cancel;
        }
        parentId = orgField.getParentId();
        entityItem = entityMetadata.getItemById(parentId);
        if (entityItem instanceof EntryEntity && (iEntryRowCount = this.getView().getModel().getEntryRowCount(entityItem.getKey())) <= 0) {
            return true;
        }
        return cancel;
    }

    private void isNotNull(Object result, String message) {
        if (result == null) {
            if (StringUtils.isBlank((CharSequence)message)) {
                message = ResManager.loadKDString((String)"\u6d4b\u8bd5\u7ed3\u679c\u4e3aNull", (String)"UnitTestCommonPlugIn_10", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]);
            }
            throw new RuntimeException(message);
        }
    }

    @TestMethod(value=3)
    @DisplayName(value="\u6d4b\u8bd5\u64cd\u4f5c\u7684\u6743\u9650\u9879\u662f\u5426\u914d\u7f6e")
    @Test
    public void testPermissionItemForOperate() {
        ArrayList<String> lstErrMessage = new ArrayList<String>();
        List<String> lstAuthOperates = this.getOperatesForPermissionAuth();
        UnitTestCommonPlugIn.assertNotNull(ResManager.loadKDString((String)"\u5f02\u5e38\u6765\u81ea\u6d4b\u8bd5\u6846\u67b6\u57fa\u7840\u7528\u4f8b(testPermissionItemForOperate)\uff1a\u83b7\u53d6\u64cd\u4f5c\u6743\u9650\u9879\u4e3aNULL", (String)"UnitTestCommonPlugIn_11", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]), lstAuthOperates);
        List lstOperator = this.getEntityMetadata().getRootEntity().getOperations();
        for (Operation operation : lstOperator) {
            String pmItemId;
            String opType = operation.getOperationType();
            UnitTestCommonPlugIn.assertNotNull(ResManager.loadKDString((String)"\u5f02\u5e38\u6765\u81ea\u6d4b\u8bd5\u6846\u67b6\u57fa\u7840\u7528\u4f8b(testPermissionItemForOperate)\uff1a\u83b7\u53d6\u64cd\u4f5c\u7c7b\u578b\u4e3aNULL", (String)"UnitTestCommonPlugIn_12", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]), opType);
            if (!lstAuthOperates.contains(opType) || (pmItemId = operation.getPermissionItemId()) != null && !StringUtils.isBlank((CharSequence)pmItemId)) continue;
            lstErrMessage.add(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c(NAME:%s,KEY:%s)\u7684\u6743\u9650\u9879\u6ca1\u6709\u8bbe\u7f6e", (String)"UnitTestCommonPlugIn_13", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]), operation.getName(), operation.getKey()));
        }
        if (lstErrMessage.size() > 0) {
            String lineSeparator = System.getProperty(LINE_SEPARATOR, "\n");
            UnitTestCommonPlugIn.fail(String.join((CharSequence)lineSeparator, lstErrMessage));
        }
    }

    private List<String> getOperatesForPermissionAuth() {
        String strOperates = "";
        List<String> lstOperates = Arrays.asList(strOperates.split(","));
        return lstOperates;
    }

    @TestMethod(value=4)
    @DisplayName(value="\u6d4b\u8bd5\u63a7\u4ef6\u7684\u5e03\u5c40\u662f\u5426\u5408\u9002")
    @Test
    public void testLayoutIsProperOrNot() {
        FormMetadata fmd = this.getFormMetadata();
        UnitTestCommonPlugIn.assertNotNull(ResManager.loadKDString((String)"\u5f02\u5e38\u6765\u81ea\u6d4b\u8bd5\u6846\u67b6\u57fa\u7840\u7528\u4f8b(testLayoutIsProperOrNot)\uff1a\u83b7\u53d6\u5f53\u524d\u6d4b\u8bd5\u8868\u5355\u7684\u8bbe\u8ba1\u65f6\u5143\u6570\u636e\u4e3aNULL", (String)"UnitTestCommonPlugIn_14", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]), fmd);
        ArrayList<String> lstMessages = new ArrayList<String>();
        HashMap<String, ControlAp> mapTabPages = new HashMap<String, ControlAp>();
        List lstItems = fmd.getItems();
        for (ControlAp entityItem : lstItems) {
            if (!(entityItem instanceof TabPageAp)) continue;
            mapTabPages.put(entityItem.getId(), entityItem);
        }
        for (ControlAp entityItem : lstItems) {
            ControlAp parentItem;
            String parentId;
            if (!(entityItem instanceof EntryAp) || !StringUtils.isNotBlank((CharSequence)(parentId = entityItem.getParentId())) || !((parentItem = (ControlAp)mapTabPages.get(parentId)) instanceof TabPageAp) || !((TabPageAp)parentItem).isBKFull()) continue;
            lstMessages.add(String.format(ResManager.loadKDString((String)"{%s}_{%s}\u4e2d\u653e\u7f6e\u4e86\u5145\u6ee1\u7684\u63a7\u4ef6{%s}_{%s},\u6a2a\u5411\u548c\u7eb5\u5411\u6eda\u5c5e\u6027\u5fc5\u987b\u8bbe\u7f6e\u4e3a\u7981\u7528\u3002", (String)"UnitTestCommonPlugIn_15", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]), parentItem.getName(), parentItem.getKey(), entityItem.getName(), entityItem.getKey()));
        }
        if (lstMessages.size() > 0) {
            String lineSeparator = System.getProperty(LINE_SEPARATOR, "\n");
            throw new RuntimeException(String.join((CharSequence)lineSeparator, lstMessages));
        }
    }

    @TestMethod(value=5)
    @DisplayName(value="\u6d4b\u8bd5\u5b57\u6bb5\u7684\u63a7\u5236\u5b57\u6bb5\u662f\u5426\u6b63\u786e\u914d\u7f6e")
    @Test
    public void testFieldControlKeyConfiguredCorrectly() {
        EntityMetadata fmd = this.getEntityMetadata();
        UnitTestCommonPlugIn.assertNotNull(ResManager.loadKDString((String)"\u5f02\u5e38\u6765\u81ea\u6d4b\u8bd5\u6846\u67b6\u57fa\u7840\u7528\u4f8b(testFieldControlKeyConfiguredCorrectly)\uff1a\u83b7\u53d6\u5f53\u524d\u6d4b\u8bd5\u8868\u5355\u7684\u8bbe\u8ba1\u65f6\u5b9e\u4f53\u5143\u6570\u636e\u4e3aNULL", (String)"UnitTestCommonPlugIn_16", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]), fmd);
    }

    @TestMethod(value=6)
    @DisplayName(value="\u68c0\u6d4b\u5143\u6570\u636e\u5f15\u7528\u5173\u7cfb\u7684\u6b63\u786e\u6027")
    @Test
    public void testMetaReferenceRelationCorrectly() {
        IFormView view = this.getView();
        UnitTestCommonPlugIn.assertNotNull(ResManager.loadKDString((String)"\u5f02\u5e38\u6765\u81ea\u6d4b\u8bd5\u6846\u67b6\u57fa\u7840\u7528\u4f8b(testF7ButtonClick)\uff1a\u83b7\u53d6\u5f53\u524d\u6d4b\u8bd5\u8868\u5355\u7684VIEW\u4e3aNULL", (String)"UnitTestCommonPlugIn_3", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]), view);
        if (!(view instanceof BillView)) {
            return;
        }
        ArrayList<String> lstMessages = new ArrayList<String>();
        HashSet<String> setFieldIds = new HashSet<String>();
        HashSet<String> setEntryIds = new HashSet<String>();
        List lstItems = this.getFormMetadata().getItems();
        for (Object ctlItem : lstItems) {
            EntityItem entryItem;
            if (ctlItem instanceof FieldAp) {
                String sFieldId = ((FieldAp)ctlItem).getFieldId();
                setFieldIds.add(sFieldId);
                entryItem = this.getEntityMetadata().getItemById(sFieldId);
                if (entryItem != null) continue;
                lstMessages.add(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u63a7\u4ef6(KEY:%s,NAME:%s,FIELDID:%s),\u4e0d\u5b58\u5728\u88ab\u5f15\u7528\u7684\u5b9e\u4f53\u5b57\u6bb5~\n", (String)"UnitTestCommonPlugIn_17", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]), ctlItem.getKey(), ctlItem.getName(), sFieldId));
                continue;
            }
            if (!(ctlItem instanceof EntryAp)) continue;
            String entryId = ((EntryAp)ctlItem).getEntryId();
            setEntryIds.add(entryId);
            entryItem = this.getEntityMetadata().getItemById(entryId);
            if (entryItem != null) continue;
            lstMessages.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u63a7\u4ef6(KEY:%s,NAME:%s,FIELDID:%s),\u4e0d\u5b58\u5728\u88ab\u5f15\u7528\u7684\u5355\u636e\u4f53\u5b9e\u4f53~\n", (String)"UnitTestCommonPlugIn_18", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]), ctlItem.getKey(), ctlItem.getName(), entryId));
        }
        List lstEntityItems = this.getEntityMetadata().getItems();
        for (EntityItem entityItem : lstEntityItems) {
            String entityId;
            if (entityItem instanceof Field) {
                entityId = entityItem.getId();
                if (setFieldIds.contains(entityId)) continue;
                lstMessages.add(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5(KEY:%s,NAME:%s,ID:%s)\u5bf9\u5e94\u7684\u539f\u59cb\u8868\u5355\u63a7\u4ef6\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u6e05\u9664\u6389\u5b57\u6bb5~\n", (String)"UnitTestCommonPlugIn_19", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]), entityItem.getKey(), entityItem.getName(), entityId));
                continue;
            }
            if (!(entityItem instanceof EntryEntity) || setEntryIds.contains(entityId = entityItem.getId())) continue;
            lstMessages.add(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53(KEY:%s,NAME:%s,ID:%s)\u5bf9\u5e94\u7684\u539f\u59cb\u8868\u5355\u63a7\u4ef6\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u6e05\u9664\u6389\u5355\u636e\u4f53\u5b9e\u4f53~\n", (String)"UnitTestCommonPlugIn_20", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]), entityItem.getKey(), entityItem.getName(), entityId));
        }
        if (lstMessages.size() > 0) {
            String lineSeparator = System.getProperty(LINE_SEPARATOR, "\n");
            throw new RuntimeException(String.join((CharSequence)lineSeparator, lstMessages));
        }
    }
}

