/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.filter;

import java.util.HashSet;
import java.util.Set;
import kd.bos.unittest.runner.DescriptionMatcher;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;

public class KDSubForestFilter
extends Filter {
    private Set<Description> fIncluded = null;
    private final DescriptionMatcher fMatcher;

    public KDSubForestFilter(DescriptionMatcher matcher) {
        this.fMatcher = matcher;
    }

    public void apply(Object child) throws NoTestsRemainException {
        if (child instanceof Runner && this.fIncluded == null) {
            this.fIncluded = new HashSet<Description>();
            this.collectIncludedDescriptions(((Runner)child).getDescription());
            if (this.fIncluded.isEmpty()) {
                throw new NoTestsRemainException();
            }
        }
        super.apply(child);
    }

    private boolean collectIncludedDescriptions(Description description) {
        if (this.fMatcher.matches(description)) {
            this.includeWithChildren(description);
            return true;
        }
        boolean hasIncludedChild = false;
        for (Description child : description.getChildren()) {
            hasIncludedChild |= this.collectIncludedDescriptions(child);
        }
        if (hasIncludedChild) {
            this.fIncluded.add(description);
        }
        return hasIncludedChild;
    }

    public String describe() {
        return this.fMatcher.toString();
    }

    public Set<Description> getIncludedDescriptions() {
        return this.fIncluded;
    }

    private void includeWithChildren(Description description) {
        this.fIncluded.add(description);
        for (Description child : description.getChildren()) {
            this.includeWithChildren(child);
        }
    }

    public boolean shouldRun(Description description) {
        return this.fIncluded.contains(description);
    }
}

