/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.framework;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.unittest.UnitTestHttpActionPlugin;
import kd.bos.unittest.runners.model.KDBaseFrameworkMethod;

public class KDAssert
extends Assert {
    public static final String SEPARATIVESIGN = "\n====================================\n";
    public static final String ERR_MSG = "showErrMsg";
    public static final String BOS_UNITTEST_PLUGIN = "bos-unittest-plugin";

    private static void doBeforeInMethod() {
        KDBaseFrameworkMethod.setAsserttype(Boolean.TRUE);
    }

    public static void assertInvokeOperation(OperationResult opRet) {
        KDAssert.doBeforeInMethod();
        if (opRet != null) {
            List errOpList;
            boolean bHasError = false;
            StringBuilder sb = new StringBuilder();
            if (!opRet.isSuccess()) {
                sb.append(opRet.getMessage());
                bHasError = true;
            }
            if ((errOpList = opRet.getAllErrorOrValidateInfo()).size() > 0) {
                for (IOperateInfo errOpResult : errOpList) {
                    sb.append(errOpResult.getMessage());
                }
                bHasError = true;
            }
            if (bHasError) {
                KDAssert.fail(String.format("%s\uff1a%s", opRet.getMessage(), sb.toString()));
            }
        }
    }

    public static void assertInvokeAction(String actionResult) {
        KDAssert.doBeforeInMethod();
        List lstActRet = (List)SerializationUtils.fromJsonString((String)actionResult, List.class);
        if (lstActRet != null) {
            List para = new ArrayList();
            for (Object object : lstActRet) {
                Map itemMap = (Map)object;
                para = (List)itemMap.get("p");
                if (((String)itemMap.get("a")).equalsIgnoreCase(ERR_MSG)) {
                    KDAssert.fail(String.format("%s,%s", (String)((Map)para.get(0)).get("errorTitle"), (String)((Map)para.get(0)).get("errorInfo")));
                    continue;
                }
                if (!((String)itemMap.get("a")).equalsIgnoreCase("ShowNotificationMsg") || 0 == (Integer)((Map)para.get(0)).get("type")) continue;
                KDAssert.fail(String.format("%s,%s", ((Map)para.get(0)).get("type"), (String)((Map)para.get(0)).get("content")));
            }
        }
    }

    public static boolean assertInvokeActionIngnoreMessage(String actionResult, String pageId, UnitTestHttpActionPlugin actionplugin, String param) {
        KDAssert.doBeforeInMethod();
        List lstActRet = (List)SerializationUtils.fromJsonString((String)actionResult, List.class);
        if (lstActRet != null) {
            List para = new ArrayList();
            for (Object object : lstActRet) {
                Map itemMap = (Map)object;
                para = (List)itemMap.get("p");
                if (!((String)itemMap.get("a")).equalsIgnoreCase(ERR_MSG)) continue;
                actionplugin.setEnd(true);
                KDAssert.fail(ResManager.loadKDString((String)"\u5f53\u524dpageId\u4e3a", (String)"KDAssert_0", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]) + pageId + "\n" + ResManager.loadKDString((String)"\u5f53\u524d\u6267\u884c\u53c2\u6570\u4e3a:", (String)"KDAssert_1", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]) + param + "\n" + String.format("%s,%s", (String)((Map)para.get(0)).get("errorTitle"), (String)((Map)para.get(0)).get("errorInfo")));
                return false;
            }
        }
        return true;
    }

    public static boolean assertInvokeActionWithMessage(String actionResult, String pageId, UnitTestHttpActionPlugin actionplugin, String param) {
        KDAssert.doBeforeInMethod();
        List lstActRet = (List)SerializationUtils.fromJsonString((String)actionResult, List.class);
        if (lstActRet != null) {
            List para = new ArrayList();
            for (Object object : lstActRet) {
                Map itemMap = (Map)object;
                para = (List)itemMap.get("p");
                if (((String)itemMap.get("a")).equalsIgnoreCase(ERR_MSG)) {
                    actionplugin.setEnd(true);
                    KDAssert.fail(ResManager.loadKDString((String)"\u5f53\u524dpageId\u4e3a", (String)"KDAssert_0", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]) + pageId + "\n" + ResManager.loadKDString((String)"\u5f53\u524d\u6267\u884c\u53c2\u6570\u4e3a:", (String)"KDAssert_1", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]) + param + "\n" + String.format("%s,%s", (String)((Map)para.get(0)).get("errorTitle"), (String)((Map)para.get(0)).get("errorInfo")));
                    return false;
                }
                if (((String)itemMap.get("a")).equalsIgnoreCase("ShowNotificationMsg")) {
                    if (para != null && para.toString().contains(ResManager.loadKDString((String)"\u6210\u529f", (String)"KDAssert_2", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]))) {
                        return true;
                    }
                    actionplugin.setEnd(true);
                    if (para != null) {
                        KDAssert.fail(ResManager.loadKDString((String)"\u5f53\u524d\u6267\u884c\u53c2\u6570\u4e3a:", (String)"KDAssert_1", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]) + param + "\n----------------------\n" + ResManager.loadKDString((String)"\u9875\u9762\u63d0\u793a\u5185\u5bb9\u4e3a:", (String)"KDAssert_3", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]) + SEPARATIVESIGN + String.format("%s,%s", ((Map)para.get(0)).get("type"), ((Map)para.get(0)).get("content")) + SEPARATIVESIGN + ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c :", (String)"KDAssert_4", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]) + actionResult + SEPARATIVESIGN);
                    } else {
                        KDAssert.fail(ResManager.loadKDString((String)"\u5f53\u524d\u6267\u884c\u53c2\u6570\u4e3a:", (String)"KDAssert_1", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]) + param + "\n----------------------\n" + ResManager.loadKDString((String)"\u9875\u9762\u63d0\u793a\u5185\u5bb9\u4e3a:", (String)"KDAssert_3", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]) + SEPARATIVESIGN + ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c :", (String)"KDAssert_4", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]) + actionResult + SEPARATIVESIGN);
                    }
                    return false;
                }
                if (!"showMessage".equalsIgnoreCase((String)itemMap.get("a"))) continue;
                if (((Map)para.get(0)).get("msg") != null && ((Map)para.get(0)).get("msg").toString().contains(ResManager.loadKDString((String)"\u6210\u529f", (String)"KDAssert_2", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]))) {
                    return true;
                }
                actionplugin.setEnd(true);
                KDAssert.fail(ResManager.loadKDString((String)"\u5f53\u524d\u6267\u884c\u53c2\u6570\u4e3a:", (String)"KDAssert_1", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]) + param + "\n----------------------\n" + ResManager.loadKDString((String)"\u9875\u9762\u63d0\u793a\u5185\u5bb9\u4e3a:", (String)"KDAssert_3", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]) + SEPARATIVESIGN + String.format("%s", (String)((Map)para.get(0)).get("msg")) + SEPARATIVESIGN + ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c :", (String)"KDAssert_4", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]) + actionResult + SEPARATIVESIGN);
                return false;
            }
        }
        return true;
    }

    public static void successAssert(String result, String param) {
        KDAssert.doBeforeInMethod();
        KDAssert.fail(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\n", (String)"KDAssert_5", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]) + ResManager.loadKDString((String)"\u5f53\u524d\u6267\u884c\u53c2\u6570\u4e3a:", (String)"KDAssert_1", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]) + param + "\n" + ResManager.loadKDString((String)"\n\u8fd4\u56de\u7ed3\u679c\u4e3a:", (String)"KDAssert_6", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]) + result);
    }

    public static void assertInvokeActionWithMsg(String actionResult, String Msg) {
        KDAssert.doBeforeInMethod();
        List lstActRet = (List)SerializationUtils.fromJsonString((String)actionResult, List.class);
        if (lstActRet != null) {
            List para = new ArrayList();
            for (Object object : lstActRet) {
                Map itemMap = (Map)object;
                para = (List)itemMap.get("p");
                if (!((String)itemMap.get("a")).equalsIgnoreCase(ERR_MSG)) continue;
                KDAssert.fail(String.format("%s,%s,%s", (String)((Map)para.get(0)).get("errorTitle"), Msg, (String)((Map)para.get(0)).get("errorInfo")));
            }
        }
    }

    public static void assertTrue(String message, boolean condition) {
        KDAssert.doBeforeInMethod();
        Assert.assertTrue((String)message, (boolean)condition);
    }

    public static void assertTrue(boolean condition) {
        KDAssert.doBeforeInMethod();
        Assert.assertTrue((boolean)condition);
    }

    public static void assertFalse(String message, boolean condition) {
        KDAssert.doBeforeInMethod();
        Assert.assertFalse((String)message, (boolean)condition);
    }

    public static void assertFalse(boolean condition) {
        KDAssert.doBeforeInMethod();
        Assert.assertFalse((boolean)condition);
    }

    public static void fail(String message) {
        KDAssert.doBeforeInMethod();
        Assert.fail((String)message);
    }

    public static void fail() {
        KDAssert.doBeforeInMethod();
        Assert.fail();
    }

    public static void assertEquals(String message, Object expected, Object actual) {
        KDAssert.doBeforeInMethod();
        Assert.assertEquals((String)message, (Object)expected, (Object)actual);
    }

    public static void assertEquals(Object expected, Object actual) {
        KDAssert.doBeforeInMethod();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public static void assertEquals(String message, String expected, String actual) {
        KDAssert.doBeforeInMethod();
        Assert.assertEquals((String)message, (String)expected, (String)actual);
    }

    public static void assertEquals(String expected, String actual) {
        KDAssert.doBeforeInMethod();
        Assert.assertEquals((String)expected, (String)actual);
    }

    public static void assertEquals(String message, double expected, double actual, double delta) {
        KDAssert.doBeforeInMethod();
        Assert.assertEquals((String)message, (double)expected, (double)actual, (double)delta);
    }

    public static void assertEquals(double expected, double actual, double delta) {
        KDAssert.doBeforeInMethod();
        Assert.assertEquals((double)expected, (double)actual, (double)delta);
    }

    public static void assertEquals(String message, float expected, float actual, float delta) {
        KDAssert.doBeforeInMethod();
        Assert.assertEquals((String)message, (float)expected, (float)actual, (float)delta);
    }

    public static void assertEquals(float expected, float actual, float delta) {
        KDAssert.doBeforeInMethod();
        Assert.assertEquals((float)expected, (float)actual, (float)delta);
    }

    public static void assertEquals(String message, long expected, long actual) {
        KDAssert.doBeforeInMethod();
        Assert.assertEquals((String)message, (long)expected, (long)actual);
    }

    public static void assertEquals(long expected, long actual) {
        KDAssert.doBeforeInMethod();
        Assert.assertEquals((long)expected, (long)actual);
    }

    public static void assertEquals(String message, boolean expected, boolean actual) {
        KDAssert.doBeforeInMethod();
        Assert.assertEquals((String)message, (boolean)expected, (boolean)actual);
    }

    public static void assertEquals(boolean expected, boolean actual) {
        KDAssert.doBeforeInMethod();
        Assert.assertEquals((boolean)expected, (boolean)actual);
    }

    public static void assertEquals(String message, byte expected, byte actual) {
        KDAssert.doBeforeInMethod();
        Assert.assertEquals((String)message, (byte)expected, (byte)actual);
    }

    public static void assertEquals(byte expected, byte actual) {
        KDAssert.doBeforeInMethod();
        Assert.assertEquals((byte)expected, (byte)actual);
    }

    public static void assertEquals(String message, char expected, char actual) {
        KDAssert.doBeforeInMethod();
        Assert.assertEquals((String)message, (char)expected, (char)actual);
    }

    public static void assertEquals(char expected, char actual) {
        KDAssert.doBeforeInMethod();
        Assert.assertEquals((char)expected, (char)actual);
    }

    public static void assertEquals(String message, short expected, short actual) {
        KDAssert.doBeforeInMethod();
        Assert.assertEquals((String)message, (short)expected, (short)actual);
    }

    public static void assertEquals(short expected, short actual) {
        KDAssert.doBeforeInMethod();
        Assert.assertEquals((short)expected, (short)actual);
    }

    public static void assertEquals(String message, int expected, int actual) {
        KDAssert.doBeforeInMethod();
        Assert.assertEquals((String)message, (int)expected, (int)actual);
    }

    public static void assertEquals(int expected, int actual) {
        KDAssert.doBeforeInMethod();
        Assert.assertEquals((int)expected, (int)actual);
    }

    public static void assertNotNull(Object object) {
        KDAssert.doBeforeInMethod();
        Assert.assertNotNull((Object)object);
    }

    public static void assertNotNull(String message, Object object) {
        KDAssert.doBeforeInMethod();
        Assert.assertNotNull((String)message, (Object)object);
    }

    public static void assertNull(Object object) {
        KDAssert.doBeforeInMethod();
        Assert.assertNull((Object)object);
    }

    public static void assertNull(String message, Object object) {
        KDAssert.doBeforeInMethod();
        Assert.assertNull((String)message, (Object)object);
    }

    public static void assertSame(String message, Object expected, Object actual) {
        KDAssert.doBeforeInMethod();
        Assert.assertSame((String)message, (Object)expected, (Object)actual);
    }

    public static void assertSame(Object expected, Object actual) {
        KDAssert.doBeforeInMethod();
        Assert.assertSame((Object)expected, (Object)actual);
    }

    public static void assertNotSame(String message, Object expected, Object actual) {
        KDAssert.doBeforeInMethod();
        Assert.assertNotSame((String)message, (Object)expected, (Object)actual);
    }

    public static void assertNotSame(Object expected, Object actual) {
        KDAssert.doBeforeInMethod();
        Assert.assertNotSame((Object)expected, (Object)actual);
    }

    public static void failSame(String message) {
        KDAssert.doBeforeInMethod();
        Assert.failSame((String)message);
    }

    public static void failNotSame(String message, Object expected, Object actual) {
        KDAssert.doBeforeInMethod();
        Assert.failNotSame((String)message, (Object)expected, (Object)actual);
    }

    public static void failNotEquals(String message, Object expected, Object actual) {
        KDAssert.doBeforeInMethod();
        Assert.failNotEquals((String)message, (Object)expected, (Object)actual);
    }

    public static String format(String message, Object expected, Object actual) {
        KDAssert.doBeforeInMethod();
        return Assert.format((String)message, (Object)expected, (Object)actual);
    }
}

