/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.rules;

import kd.bos.context.RequestContext;
import kd.bos.mvc.SessionManager;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.unittest.runners.model.KDBaseFrameworkMethod;
import org.junit.runners.model.Statement;

public class KDFailOnTimeout
extends Statement {
    private final Statement fOriginalStatement;
    private final long fTimeout;
    private static ThreadLocal<Boolean> asserttype = new ThreadLocal();

    public static boolean getAsserttype() {
        if (asserttype.get() == null) {
            return false;
        }
        return asserttype.get();
    }

    public static void setAsserttype(Boolean asttype) {
        asserttype.set(asttype);
    }

    public KDFailOnTimeout(Statement originalStatement, long timeout) {
        this.fOriginalStatement = originalStatement;
        this.fTimeout = timeout;
        KDFailOnTimeout.setAsserttype(Boolean.FALSE);
    }

    public void evaluate() throws Throwable {
        StatementThread thread = this.evaluateStatement();
        KDFailOnTimeout.setAsserttype(thread.asserttype);
        if (!thread.fFinished) {
            this.throwExceptionForUnfinishedThread(thread);
        }
    }

    private StatementThread evaluateStatement() throws InterruptedException {
        StatementThread thread = new StatementThread(this.fOriginalStatement);
        thread.start();
        thread.join(this.fTimeout);
        thread.interrupt();
        return thread;
    }

    private void throwExceptionForUnfinishedThread(StatementThread thread) throws Throwable {
        if (thread.fExceptionThrownByOriginalStatement != null) {
            throw thread.fExceptionThrownByOriginalStatement;
        }
        this.throwTimeoutException(thread);
    }

    private void throwTimeoutException(StatementThread thread) throws Exception {
        Exception exception = new Exception(String.format("test timed out after %d milliseconds", this.fTimeout));
        exception.setStackTrace(thread.getStackTrace());
        throw exception;
    }

    private static class StatementThread
    extends Thread {
        private final Statement fStatement;
        private boolean fFinished = false;
        private Throwable fExceptionThrownByOriginalStatement = null;
        private boolean asserttype = false;

        public StatementThread(Statement statement) {
            this.fStatement = statement;
        }

        @Override
        public void run() {
            try {
                ThreadLifeCycleManager.start();
                this.fStatement.evaluate();
                this.fFinished = true;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable e) {
                this.fExceptionThrownByOriginalStatement = e;
            }
            finally {
                if (RequestContext.get() != null) {
                    SessionManager.getCurrent().commitCache();
                }
                this.asserttype = KDBaseFrameworkMethod.getAsserttype();
                ThreadLifeCycleManager.end();
            }
        }
    }
}

