/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.runner;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.runner.Description;

public abstract class DescriptionMatcher {
    private static final Pattern METHOD_AND_CLASS_NAME_PATTERN = Pattern.compile("(.*)\\((.*)\\)");

    public static DescriptionMatcher create(Class<?> clazz, String matchString) {
        ArrayList<DescriptionMatcher> matchers = new ArrayList<DescriptionMatcher>();
        matchers.add(new ExactMatcher(matchString));
        Matcher parsed = METHOD_AND_CLASS_NAME_PATTERN.matcher(matchString);
        if (parsed.matches()) {
            String className = parsed.group(2);
            String testName = parsed.group(1);
            if (testName.equals(DescriptionMatcher.extractLeadingIdentifier(testName))) {
                matchers.add(new LeadingIdentifierMatcher(className, testName));
            }
        } else {
            String className = clazz.getName();
            if (!className.equals(matchString)) {
                matchers.add(new ExactMatcher(className, matchString));
                if (matchString.equals(DescriptionMatcher.extractLeadingIdentifier(matchString))) {
                    matchers.add(new LeadingIdentifierMatcher(className, matchString));
                }
            }
        }
        return new CompositeMatcher(matchers);
    }

    private static String extractLeadingIdentifier(String string) {
        if (string.length() == 0) {
            return null;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return null;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return string.substring(0, i);
        }
        return string;
    }

    public abstract boolean matches(Description var1);

    private static class LeadingIdentifierMatcher
    extends DescriptionMatcher {
        private final String fClassName;
        private final String fLeadingIdentifier;

        public LeadingIdentifierMatcher(String className, String leadingIdentifier) {
            this.fClassName = className;
            this.fLeadingIdentifier = leadingIdentifier;
        }

        @Override
        public boolean matches(Description description) {
            String methodName;
            String className = description.getClassName();
            if (this.fClassName.equals(className) && (methodName = description.getMethodName()) != null) {
                return this.fLeadingIdentifier.equals(DescriptionMatcher.extractLeadingIdentifier(methodName));
            }
            return false;
        }

        public String toString() {
            return String.format("{fClassName=%s,fLeadingIdentifier=%s]", this.fClassName, this.fLeadingIdentifier);
        }
    }

    private static class ExactMatcher
    extends DescriptionMatcher {
        private final String fDisplayName;

        public ExactMatcher(String className) {
            this.fDisplayName = className;
        }

        public ExactMatcher(String className, String testName) {
            this.fDisplayName = String.format("%s(%s)", testName, className);
        }

        @Override
        public boolean matches(Description description) {
            return this.fDisplayName.equals(description.getDisplayName());
        }

        public String toString() {
            return String.format("{%s:fDisplayName=%s]", this.getClass().getSimpleName(), this.fDisplayName);
        }
    }

    private static class CompositeMatcher
    extends DescriptionMatcher {
        private final List<DescriptionMatcher> fMatchers;

        public CompositeMatcher(List<DescriptionMatcher> matchers) {
            this.fMatchers = matchers;
        }

        @Override
        public boolean matches(Description description) {
            for (DescriptionMatcher matcher : this.fMatchers) {
                if (!matcher.matches(description)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return this.fMatchers.toString();
        }
    }
}

