/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.runner;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.IKDListensToTestExecutions;
import kd.bos.form.unittest.IKDTestIdentifier;
import kd.bos.form.unittest.KDCaseMethodResult;
import kd.bos.form.unittest.KDTestReferenceFailure;
import kd.bos.unittest.KDUnitTestScriptPlugIn;
import kd.bos.unittest.UnitTestHttpActionPlugin;
import kd.bos.unittest.rules.KDFailOnTimeout;
import kd.bos.unittest.runner.KDTestIdentifier;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class KDUnitTestListener
extends RunListener {
    public static final String BOS_UNITTEST_PLUGIN = "bos-unittest-plugin";
    public static final String KD_UNIT_TEST_LISTENER_2 = "KDUnitTestListener_2";
    private KDCaseMethodResult methodResult;
    private List<KDCaseMethodResult> lstCaseResult = new ArrayList<KDCaseMethodResult>();
    private final IKDListensToTestExecutions fNotified;

    public void testRunStarted(Description description) throws Exception {
        super.testRunStarted(description);
    }

    public KDUnitTestListener(IKDListensToTestExecutions notified) {
        this.fNotified = notified;
    }

    public void testRunFinished(Result result) throws Exception {
        super.testRunFinished(result);
        this.fNotified.notifyRunFinished(this.lstCaseResult);
    }

    private void initialMethodResult(Description plan) {
        this.methodResult = new KDCaseMethodResult();
        this.methodResult.setCompleted(true);
        this.methodResult.setMessage(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f", (String)"KDUnitTestListener_0", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]));
        String strDisName = "";
        String strMethodName = plan.getMethodName();
        if (plan.getTestClass().isAssignableFrom(KDUnitTestScriptPlugIn.class)) {
            String[] arrayInfo = strMethodName.split(",");
            strMethodName = arrayInfo[0];
            strDisName = arrayInfo[1];
        } else if (plan.getTestClass().isAssignableFrom(UnitTestHttpActionPlugin.class)) {
            String[] arrayInfo = strMethodName.split(",");
            strMethodName = arrayInfo[0];
            strDisName = arrayInfo[1];
        } else {
            DisplayName disName = (DisplayName)plan.getAnnotation(DisplayName.class);
            strDisName = disName != null ? disName.value() : plan.getClassName();
        }
        this.methodResult.setMethodName(strMethodName);
        this.methodResult.setName(strDisName);
        this.methodResult.setStartTime(new Date());
    }

    public void testStarted(Description plan) throws Exception {
        this.initialMethodResult(plan);
        this.fNotified.notifyTestStarted(this.getIdentifier(plan, false, false));
    }

    public void testFailure(Failure failure) throws Exception {
        this.testFailure(failure, false);
    }

    public void testAssumptionFailure(Failure failure) {
        this.testFailure(failure, true);
    }

    private void testFailure(Failure failure, boolean assumptionFailed) {
        KDTestReferenceFailure testReferenceFailure;
        IKDTestIdentifier identifier = this.getIdentifier(failure.getDescription(), false, assumptionFailed);
        try {
            Throwable exception = failure.getException();
            String status = assumptionFailed || exception instanceof AssertionError ? "%FAILED " : "%ERROR  ";
            testReferenceFailure = new KDTestReferenceFailure(identifier, status, failure.getTrace());
        }
        catch (RuntimeException e) {
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            testReferenceFailure = new KDTestReferenceFailure(identifier, "%FAILED ", stringWriter.getBuffer().toString());
        }
        this.fNotified.notifyTestFailed(testReferenceFailure);
        if (this.methodResult == null) {
            this.initialMethodResult(failure.getDescription());
            this.methodResult.setCompleted(false);
            this.methodResult.setMessage(failure.getTrace());
            this.methodResult.setEndTime(new Date());
            this.lstCaseResult.add(this.methodResult);
            this.methodResult = null;
        } else if (failure.getMessage() != null) {
            if (failure.getMessage().contains(ResManager.loadKDString((String)"\u65ad\u8a00\u5339\u914d\u6a21\u5f0f", (String)"KDUnitTestListener_1", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]))) {
                this.methodResult.setCompleted(false);
                this.methodResult.setMessage(failure.getMessage());
            } else if (failure.getMessage().contains(ResManager.loadKDString((String)"\u524d\u9762\u6267\u884c\u5931\u8d25", (String)KD_UNIT_TEST_LISTENER_2, (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]))) {
                this.methodResult.setMessage(ResManager.loadKDString((String)"\u524d\u9762\u6267\u884c\u5931\u8d25", (String)KD_UNIT_TEST_LISTENER_2, (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]));
            } else if (failure.getMessage().contains(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f", (String)"KDUnitTestListener_0", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]))) {
                this.methodResult.setCompleted(true);
                this.methodResult.setMessage(failure.getMessage());
            } else {
                this.methodResult.setCompleted(false);
                this.methodResult.setMessage(failure.getTrace());
            }
        } else {
            this.methodResult.setCompleted(false);
            this.methodResult.setMessage(failure.getTrace());
        }
    }

    public void testIgnored(Description plan) throws Exception {
        IKDTestIdentifier identifier = this.getIdentifier(plan, true, false);
        this.fNotified.notifyTestStarted(identifier);
        this.fNotified.notifyTestEnded(identifier);
    }

    public void testFinished(Description plan) throws Exception {
        if (!this.methodResult.getMessage().equals(ResManager.loadKDString((String)"\u524d\u9762\u6267\u884c\u5931\u8d25", (String)KD_UNIT_TEST_LISTENER_2, (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]))) {
            this.fNotified.notifyTestEnded(this.getIdentifier(plan, false, false));
            this.methodResult.setEndTime(new Date());
            this.methodResult.getConsumeTime();
            boolean asserttype = KDFailOnTimeout.getAsserttype();
            this.methodResult.setHasassert(asserttype);
            this.lstCaseResult.add(this.methodResult);
            this.methodResult = null;
        }
    }

    private IKDTestIdentifier getIdentifier(Description plan, boolean ignored, boolean assumptionFailed) {
        if (ignored) {
            return new IgnoredTestIdentifier(plan);
        }
        if (assumptionFailed) {
            return new AssumptionFailedTestIdentifier(plan);
        }
        return new KDTestIdentifier(plan);
    }

    private static class IgnoredTestIdentifier
    extends KDTestIdentifier {
        public IgnoredTestIdentifier(Description description) {
            super(description);
        }

        @Override
        public String getName() {
            String name = super.getName();
            if (name != null) {
                return "@Ignore: " + name;
            }
            return null;
        }
    }

    private static class AssumptionFailedTestIdentifier
    extends KDTestIdentifier {
        public AssumptionFailedTestIdentifier(Description description) {
            super(description);
        }

        @Override
        public String getName() {
            String name = super.getName();
            if (name != null) {
                return "@AssumptionFailure: " + name;
            }
            return null;
        }
    }
}

