/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.runner;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kd.bos.form.unittest.IKDTestLoader;
import kd.bos.form.unittest.IKDTestReference;
import kd.bos.form.unittest.KDCase;
import kd.bos.form.unittest.KDUnitTestRunner;
import kd.bos.unittest.action.IKDUnitTestObjectAction;
import kd.bos.unittest.action.KDUnitTestObjectActionFactory;
import kd.bos.unittest.framework.KDRequest;
import kd.bos.unittest.runner.KDUnitTestReference;
import kd.bos.unittest.runners.KDUnitTestClassRunner;
import kd.bos.unittest.sort.KDFailuresFirstSorter;
import kd.bos.unittest.sort.KDSorter;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Sorter;

public class KDUnitTestLoader
implements IKDTestLoader {
    private KDUnitTestRunner kdRunner;

    public IKDTestReference[] loadTests(List<Map<String, Object>> lstPluginInfos, KDUnitTestRunner kdRunner) {
        this.kdRunner = kdRunner;
        IKDTestReference[] refs = new IKDTestReference[lstPluginInfos.size()];
        int i = 0;
        for (Map<String, Object> pluginInfo : lstPluginInfos) {
            IKDTestReference ref;
            Class clazz = (Class)pluginInfo.get("clazz");
            KDCase.CasePluginType pType = (KDCase.CasePluginType)pluginInfo.get("type");
            refs[i] = ref = this.createTest(clazz, pType, pluginInfo);
            ++i;
        }
        return refs;
    }

    private List<Map<String, Object>> loadClassesWithPlugin(List<Map<String, Object>> lstPluginInfos) throws ClassNotFoundException {
        for (Map<String, Object> pluginInfo : lstPluginInfos) {
            String name = (String)pluginInfo.get("class");
            Class<?> clazz = this.loadClass(name, this.kdRunner);
            if (clazz == null) continue;
            pluginInfo.put("clazz", clazz);
        }
        return lstPluginInfos;
    }

    private Class<?> loadClass(String className, KDUnitTestRunner listener) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = this.getTestClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            listener.runFailed("RemoteTestRunner.error.classnotfound " + className, (Exception)e);
            throw e;
        }
        return clazz;
    }

    private ClassLoader getTestClassLoader() {
        return this.getClass().getClassLoader();
    }

    private IKDTestReference createTest(Class<?> clazz, KDCase.CasePluginType pType, Map<String, Object> runPluginParams) {
        if (clazz == null) {
            return null;
        }
        return this.createUnfilteredTest(clazz, pType, runPluginParams);
    }

    private Runner getKDRunner(Request request, Class<?> clazz, KDCase.CasePluginType pType, Map<String, Object> runPluginParams) {
        Runner runner = request.getRunner();
        if (runner instanceof KDUnitTestClassRunner) {
            IKDUnitTestObjectAction utObj = KDUnitTestObjectActionFactory.createKDUnitTestObjectAction(pType, this.kdRunner.getRunnerParams(), runPluginParams);
            ((KDUnitTestClassRunner)runner).setUtObj(utObj);
            ((KDUnitTestClassRunner)runner).setRequestContext(this.kdRunner.getRequestContext());
        }
        new Sorter((Comparator)new KDSorter()).apply((Object)runner);
        return runner;
    }

    private IKDTestReference createUnfilteredTest(Class<?> clazz, KDCase.CasePluginType pType, Map<String, Object> runPluginParams) {
        Request request = this.sortByFailures(KDRequest.aClass(clazz), null);
        Runner runner = this.getKDRunner(request, clazz, pType, runPluginParams);
        Description description = runner.getDescription();
        return new KDUnitTestReference(runner, description);
    }

    private Request sortByFailures(Request request, String[] failureNames) {
        if (failureNames != null) {
            return request.sortWith((Comparator)new KDFailuresFirstSorter(failureNames));
        }
        return request.sortWith((Comparator)new KDSorter());
    }
}

