/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.runner;

import kd.bos.form.unittest.IKDTestIdentifier;
import kd.bos.form.unittest.IKDTestReference;
import kd.bos.form.unittest.IKDUnitTestClientView;
import kd.bos.form.unittest.KDUnitTestPluginRunner;
import kd.bos.unittest.runner.KDTestIdentifier;
import kd.bos.unittest.runner.KDUnitTestListener;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

public class KDUnitTestReference
implements IKDTestReference {
    protected final Runner fRunner;
    protected final Description fRoot;

    public KDUnitTestReference(Runner runner, Description root) {
        this.fRunner = runner;
        this.fRoot = root;
    }

    public int countTestCases() {
        return this.countTestCases(this.fRoot);
    }

    private int countTestCases(Description description) {
        if (description.isTest()) {
            return 1;
        }
        int result = 0;
        for (Description child : description.getChildren()) {
            result += this.countTestCases(child);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KDUnitTestReference)) {
            return false;
        }
        KDUnitTestReference ref = (KDUnitTestReference)obj;
        return ref.fRoot.equals((Object)this.fRoot);
    }

    public IKDTestIdentifier getIdentifier() {
        return new KDTestIdentifier(this.fRoot);
    }

    public int hashCode() {
        return this.fRoot.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(KDUnitTestPluginRunner execution) {
        RunNotifier notifier = new RunNotifier();
        notifier.addListener((RunListener)new KDUnitTestListener(execution.getListener()));
        Result result = new Result();
        RunListener listener = result.createListener();
        notifier.addListener(listener);
        try {
            notifier.fireTestRunStarted(this.fRunner.getDescription());
            this.fRunner.run(notifier);
            notifier.fireTestRunFinished(result);
        }
        finally {
            notifier.removeListener(listener);
        }
    }

    public void sendTree(IKDUnitTestClientView notified) {
        this.sendTree(notified, this.fRoot);
    }

    private void sendTree(IKDUnitTestClientView notified, Description description) {
        if (description.isTest()) {
            notified.visitTreeEntry((IKDTestIdentifier)new KDTestIdentifier(description), false, 1);
        } else {
            notified.visitTreeEntry((IKDTestIdentifier)new KDTestIdentifier(description), true, description.getChildren().size());
            for (Description child : description.getChildren()) {
                this.sendTree(notified, child);
            }
        }
    }

    public String toString() {
        return this.fRoot.toString();
    }
}

