/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.runners;

import java.lang.annotation.Annotation;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.unittest.action.IKDUnitTestObjectAction;
import kd.bos.unittest.action.KDUnitTestJavaAction;
import kd.bos.unittest.runners.model.KDJsFrameworkMethod;
import kd.bos.unittest.runners.statements.InvokeKdJavaMethod;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class KDUnitTestClassRunner
extends BlockJUnit4ClassRunner {
    private Object caseInstance;
    private IKDUnitTestObjectAction utObj;
    private RequestContext rc;

    public KDUnitTestClassRunner(Class<?> klass) throws InitializationError {
        super(TypesContainer.getOrRegister((String)klass.getName()));
    }

    public void setUtObj(IKDUnitTestObjectAction utObj) {
        this.utObj = utObj;
    }

    public void setRequestContext(RequestContext rc) {
        this.rc = rc;
    }

    protected Object createTest() throws Exception {
        TestClass tc = this.getTestClass();
        if (this.caseInstance == null) {
            this.caseInstance = this.utObj.buildTest(tc);
        }
        return this.caseInstance;
    }

    public List<FrameworkMethod> getChildren() {
        List<Object> lstFrameWorkMethod = null;
        lstFrameWorkMethod = this.utObj != null ? (this.utObj instanceof KDUnitTestJavaAction ? this.computeTestMethods() : this.utObj.buildMethods()) : this.computeTestMethods();
        return lstFrameWorkMethod;
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        if (this.utObj != null) {
            if (this.utObj instanceof KDUnitTestJavaAction) {
                return new InvokeKdJavaMethod(this.rc, method, test);
            }
            return this.utObj.buildMethodInvoke(this.rc, method, test);
        }
        return null;
    }

    protected void validateInstanceMethods(List<Throwable> errors) {
        this.validatePublicVoidNoArgMethods(After.class, false, errors);
        this.validatePublicVoidNoArgMethods(Before.class, false, errors);
        this.validateTestMethods(errors);
        if (this.utObj != null) {
            if (!(this.utObj instanceof KDUnitTestJavaAction)) {
                return;
            }
            if (this.computeTestMethods().size() == 0) {
                errors.add(new Exception("No runnable methods"));
            }
        }
    }

    protected String testName(FrameworkMethod method) {
        if (method instanceof KDJsFrameworkMethod) {
            return ((KDJsFrameworkMethod)method).getName() + "," + ((KDJsFrameworkMethod)method).getDisplayName();
        }
        return method.getName();
    }

    protected Description describeChild(FrameworkMethod method) {
        if (method instanceof KDJsFrameworkMethod) {
            return Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)this.testName(method));
        }
        return super.describeChild(method);
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describeChild(method);
        if (method instanceof KDJsFrameworkMethod) {
            this.runLeaf(this.methodBlock(method), description, notifier);
        } else {
            super.runChild(method, notifier);
        }
    }

    protected Statement possiblyExpectingExceptions(FrameworkMethod method, Object test, Statement next) {
        if (method instanceof KDJsFrameworkMethod) {
            return next;
        }
        return super.possiblyExpectingExceptions(method, test, next);
    }

    protected Statement withPotentialTimeout(FrameworkMethod method, Object test, Statement next) {
        if (method instanceof KDJsFrameworkMethod) {
            return next;
        }
        return super.withPotentialTimeout(method, test, next);
    }

    public Description getDescription() {
        Class clazz = this.getTestClass().getJavaClass();
        Description description = clazz == null || !clazz.getName().equals(this.getName()) ? Description.createSuiteDescription((String)this.getName(), (Annotation[])this.getRunnerAnnotations()) : Description.createSuiteDescription((Class)clazz, (Annotation[])this.getRunnerAnnotations());
        for (FrameworkMethod child : this.getChildren()) {
            description.addChild(this.describeChild(child));
        }
        return description;
    }
}

