/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.runners.statements;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.unittest.AnalysisResponseBody;
import kd.bos.form.unittest.AssertController;
import kd.bos.form.unittest.ConstantTimer;
import kd.bos.form.unittest.ExcelDataObject;
import kd.bos.form.unittest.RegularController;
import kd.bos.form.unittest.UnitTestCase;
import kd.bos.form.unittest.UnitTestHttpProxy;
import kd.bos.mservice.form.FormService;
import kd.bos.mservice.form.FormServiceImpl;
import kd.bos.unittest.UnitTestHttpActionPlugin;
import kd.bos.unittest.framework.KDAssert;
import kd.bos.unittest.runners.model.KDHttpFrameworkMethod;
import kd.bos.unittest.utils.RequestUtil;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class InvokeKdHttpActionMethod
extends Statement {
    public static final String BOS_UNITTEST_PLUGIN = "bos-unittest-plugin";
    private FrameworkMethod fTestMethod;
    private Object httpActionPlugin;
    private FormService formService = new FormServiceImpl();
    private RequestContext frc;
    private Pattern paraPattern = Pattern.compile("(?<=\\$\\{)(.*?)(?=\\})");
    private int dataSize = 1;
    private int indexNumber = 0;

    public InvokeKdHttpActionMethod() {
    }

    public InvokeKdHttpActionMethod(RequestContext frc, FrameworkMethod fTestMethod, Object httpActionPlugin) {
        this.frc = frc;
        this.fTestMethod = fTestMethod;
        this.httpActionPlugin = httpActionPlugin;
    }

    public InvokeKdHttpActionMethod(RequestContext frc, FrameworkMethod fTestMethod, Object httpActionPlugin, int indexNumber) {
        this.frc = frc;
        this.fTestMethod = fTestMethod;
        this.httpActionPlugin = httpActionPlugin;
        this.indexNumber = indexNumber;
    }

    public FormService getFormService() {
        return this.formService;
    }

    public void setFormService(FormService formService) {
        this.formService = formService;
    }

    public void evaluate() throws Throwable {
        RequestContext.set((RequestContext)this.frc);
        String groupName = ((KDHttpFrameworkMethod)this.fTestMethod).getGroupName();
        String methodName = ((KDHttpFrameworkMethod)this.fTestMethod).getMethodName();
        String caseName = ((KDHttpFrameworkMethod)this.fTestMethod).getCaseName();
        UnitTestHttpActionPlugin actionPlugin = (UnitTestHttpActionPlugin)((Object)this.httpActionPlugin);
        String pageId = null;
        boolean isSuccess = true;
        if (this.httpActionPlugin instanceof UnitTestHttpActionPlugin && !actionPlugin.isEnd()) {
            UnitTestHttpActionPlugin actionWrapper = (UnitTestHttpActionPlugin)((Object)this.httpActionPlugin);
            List caseList = actionWrapper.getGroupMap().get(groupName).getUnitTestCases();
            for (UnitTestCase unitTestCase : caseList) {
                if (!unitTestCase.getName().equals(caseName)) continue;
                Map<String, Map<String, List<String>>> map1 = this.getStateMentByStatement(unitTestCase, actionWrapper);
                for (UnitTestHttpProxy unitTestHttpProxy : unitTestCase.getUnitTestHttpProxys()) {
                    List timers;
                    if (!unitTestHttpProxy.getName().equals(methodName)) continue;
                    String path = unitTestHttpProxy.getInvokeMethod().getPath();
                    String action = path.substring(path.lastIndexOf(47) + 1);
                    if (action.indexOf(63) != -1) {
                        action = action.substring(0, action.indexOf(63));
                    }
                    if ((timers = unitTestHttpProxy.getConstantTimerList()) != null) {
                        long totalTime = 0L;
                        for (ConstantTimer constantTimer : timers) {
                            long delayTime = Long.parseLong(constantTimer.getDelaytime());
                            totalTime += delayTime;
                        }
                        Thread.sleep(totalTime);
                    }
                    if (!this.isHandleActions(action)) continue;
                    Map param = unitTestHttpProxy.getParams();
                    HashMap<String, String> paramCopy = new HashMap<String, String>(param.size());
                    for (Map.Entry entry : param.entrySet()) {
                        String value = entry.getValue().toString();
                        String paraKey = (String)entry.getKey();
                        Matcher matcher = this.paraPattern.matcher(value);
                        paramCopy.put(paraKey, value);
                        while (matcher.find()) {
                            String findKey = matcher.group();
                            if (actionWrapper.getAppEnv().containsKey(findKey)) {
                                paramCopy.put(paraKey, ((String)paramCopy.get(paraKey)).replace("${" + findKey + "}", actionWrapper.getAppEnv().get(findKey).toString()));
                                continue;
                            }
                            if (actionWrapper.getCaseContext().containsKey(findKey)) {
                                paramCopy.put(paraKey, ((String)paramCopy.get(paraKey)).replace("${" + findKey + "}", actionWrapper.getCaseContext().get(findKey).toString()));
                                continue;
                            }
                            if (map1.containsKey(unitTestHttpProxy.getName())) {
                                if (!map1.get(unitTestHttpProxy.getName()).containsKey(paraKey)) continue;
                                paramCopy.put(paraKey, map1.get(unitTestHttpProxy.getName()).get(paraKey).get(this.indexNumber));
                                continue;
                            }
                            KDAssert.fail(ResManager.loadKDString((String)"\u811a\u672c\u6709\u8bef:\u8bf7\u68c0\u67e5\u53d8\u91cf\n\u539f\u56e0:\u672a\u627e\u5230\u53d8\u91cf ", (String)"InvokeKdHttpActionMethod_0", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]) + findKey + ResManager.loadKDString((String)" \u7684\u5b9a\u4e49\uff01\uff01\uff01", (String)"InvokeKdHttpActionMethod_1", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]));
                            return;
                        }
                    }
                    String result = "";
                    switch (action) {
                        case "batchInvokeAction.do": {
                            pageId = (String)paramCopy.get("pageId");
                            if (pageId == null) {
                                KDAssert.fail(ResManager.loadKDString((String)"\u811a\u672c\u6709\u8bef:\u8bf7\u68c0\u67e5\u53c2\u6570\u662f\u5426\u6b63\u786e\n\u539f\u56e0:", (String)"InvokeKdHttpActionMethod_2", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]) + groupName + "|" + caseName + "|" + methodName + ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230pageId", (String)"InvokeKdHttpActionMethod_3", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]));
                                actionPlugin.setEnd(true);
                                isSuccess = false;
                            }
                            String appId = "bos";
                            if (paramCopy.get("appId") != null) {
                                appId = (String)paramCopy.get("appId");
                            }
                            result = RequestUtil.batchInvokeAction(appId, pageId, (String)paramCopy.get("params"));
                            break;
                        }
                        case "getConfig.do": {
                            result = RequestUtil.getConfig((String)paramCopy.get("params"));
                            break;
                        }
                        case "upload.do": {
                            if (paramCopy.get("url") == null) {
                                KDAssert.fail(ResManager.loadKDString((String)"url\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (String)"InvokeKdHttpActionMethod_4", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]));
                                actionPlugin.setEnd(true);
                                isSuccess = false;
                            }
                            result = RequestUtil.upload((String)paramCopy.get("url"));
                            break;
                        }
                        case "uploadFile.do": {
                            if (paramCopy.get("url") == null) {
                                KDAssert.fail(ResManager.loadKDString((String)"url\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (String)"InvokeKdHttpActionMethod_4", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]));
                                actionPlugin.setEnd(true);
                                isSuccess = false;
                            }
                            result = RequestUtil.uploadFile((String)paramCopy.get("url"));
                            break;
                        }
                        case "export.do": {
                            result = RequestUtil.export(paramCopy);
                            break;
                        }
                        case "download.do": {
                            result = RequestUtil.download(paramCopy);
                            break;
                        }
                    }
                    if (unitTestHttpProxy.getRegularController() != null) {
                        this.regularCatch(result, actionWrapper, unitTestHttpProxy, actionPlugin);
                    }
                    if ("batchInvokeAction.do".equals(action)) {
                        if (unitTestHttpProxy.getAssertController() != null) {
                            for (AssertController asserController : unitTestHttpProxy.getAssertController()) {
                                if (!isSuccess) continue;
                                isSuccess = this.assertCatch(result, asserController, pageId, actionPlugin, (String)paramCopy.get("params"));
                            }
                            if (isSuccess) {
                                isSuccess = KDAssert.assertInvokeActionIngnoreMessage(result, pageId, actionPlugin, (String)paramCopy.get("params"));
                            }
                        } else {
                            isSuccess = KDAssert.assertInvokeActionWithMessage(result, pageId, actionPlugin, (String)paramCopy.get("params"));
                        }
                        if (!isSuccess) continue;
                        KDAssert.successAssert(result, (String)paramCopy.get("params"));
                        continue;
                    }
                    if (!action.equals("upload.do") && !action.equals("uploadFile.do")) continue;
                    if (unitTestHttpProxy.getAssertController() != null) {
                        for (AssertController assertController : unitTestHttpProxy.getAssertController()) {
                            if (!isSuccess) continue;
                            isSuccess = this.assertCatch(result, assertController, actionPlugin);
                        }
                    }
                    if (!isSuccess) continue;
                    KDAssert.successAssert(result, (String)paramCopy.get("url"));
                }
            }
        }
    }

    private boolean isHandleActions(String action) {
        switch (action) {
            case "batchInvokeAction.do": 
            case "getConfig.do": 
            case "upload.do": 
            case "uploadFile.do": 
            case "export.do": 
            case "download.do": {
                return true;
            }
        }
        return false;
    }

    private Map<String, Map<String, List<String>>> getStateMentByStatement(UnitTestCase unitTestCase, UnitTestHttpActionPlugin actionWrapper) {
        HashMap<String, Map<String, List<String>>> returnMap = new HashMap<String, Map<String, List<String>>>();
        for (UnitTestHttpProxy unitTestHttpProxy : unitTestCase.getUnitTestHttpProxys()) {
            String path = unitTestHttpProxy.getInvokeMethod().getPath();
            if (!path.substring(path.lastIndexOf(47) + 1).equals("batchInvokeAction.do")) continue;
            Map param = unitTestHttpProxy.getParams();
            Iterator it = param.entrySet().iterator();
            HashMap dataSourceTemp = new HashMap();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String value = entry.getValue().toString();
                value = value.replace("\\", "");
                String paraKey = (String)entry.getKey();
                Matcher matcher = this.paraPattern.matcher(value);
                ArrayList<String> tempList = new ArrayList<String>();
                while (matcher.find()) {
                    String findKey = matcher.group();
                    if (actionWrapper.getAppEnv().containsKey(findKey)) {
                        value = value.replace("${" + findKey + "}", actionWrapper.getAppEnv().get(findKey).toString());
                        continue;
                    }
                    if (actionWrapper.getCaseContext().containsKey(findKey)) {
                        value = value.replace("${" + findKey + "}", actionWrapper.getCaseContext().get(findKey).toString());
                        continue;
                    }
                    if (unitTestCase.getDataList().isEmpty()) continue;
                    Iterator dataSourceIt = unitTestCase.getDataList().entrySet().iterator();
                    boolean isFirst = tempList.isEmpty();
                    while (dataSourceIt.hasNext()) {
                        Map.Entry dataSourceEntry = dataSourceIt.next();
                        ExcelDataObject dataSourceValue = (ExcelDataObject)dataSourceEntry.getValue();
                        for (int i = 0; i < dataSourceValue.getDataList().size(); ++i) {
                            if (!((HashMap)dataSourceValue.getDataList().get(i)).containsKey(findKey)) continue;
                            if (isFirst) {
                                try {
                                    tempList.add(value.replace("${" + findKey + "}", (CharSequence)((HashMap)dataSourceValue.getDataList().get(i)).get(findKey)));
                                }
                                catch (Exception exception) {}
                                continue;
                            }
                            tempList.set(i, ((String)tempList.get(i)).replace("${" + findKey + "}", (CharSequence)((HashMap)dataSourceValue.getDataList().get(i)).get(findKey)));
                        }
                        if (tempList.isEmpty()) continue;
                        dataSourceTemp.put(paraKey, tempList);
                        if (tempList.size() <= this.dataSize) continue;
                        this.dataSize = tempList.size();
                    }
                }
            }
            if (dataSourceTemp.isEmpty()) continue;
            returnMap.put(unitTestHttpProxy.getName(), dataSourceTemp);
        }
        return returnMap;
    }

    private void regularCatch(String result, UnitTestHttpActionPlugin actionWrapper, UnitTestHttpProxy proxy, UnitTestHttpActionPlugin actionPlugin) {
        AnalysisResponseBody analyser = new AnalysisResponseBody();
        for (RegularController controller : proxy.getRegularController()) {
            String regex = controller.getRegexExtractor_regex();
            if (regex != null && (regex = regex.replaceAll(" ", "")).contains("\\\\")) {
                regex = regex.replace("\\\\", "\\");
            }
            controller.setRegexExtractor_regex(regex);
            try {
                Map resultMap = analyser.analysisRegexExtractor(result, controller);
                actionWrapper.getCaseContext().put(controller.getRegexExtractor_refname(), resultMap.get("refName"));
            }
            catch (Exception e) {
                KDAssert.fail(ResManager.loadKDString((String)"\u5f88\u5947\u602a\u7684\u5076\u53d1\u95ee\u9898\uff0c\u628a\u9519\u8bef\u4fe1\u606f\u5148\u6253\u5370\u51fa\u6765\u770b:", (String)"InvokeKdHttpActionMethod_5", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]) + "\n  result:\n" + result + "\n   controllerInfo:\n\ncontrollerName:" + controller.getName() + "\n RegexExtractor_default:" + controller.getRegexExtractor_default() + "\n RegexExtractor_match_number:" + controller.getRegexExtractor_match_number() + "\n RegexExtractor_refname:" + controller.getRegexExtractor_refname() + "\n RegexExtractor_regex:" + controller.getRegexExtractor_regex() + "\n RegexExtractor_template:" + controller.getRegexExtractor_template() + "\n RegexExtractor_useHeaders:" + controller.getRegexExtractor_useHeaders() + "\n cause by" + e.getMessage());
            }
        }
    }

    private boolean assertCatch(String result, AssertController assertController, String pageId, UnitTestHttpActionPlugin actionPlugin, String param) {
        AnalysisResponseBody analyser = new AnalysisResponseBody();
        ArrayList<String> tempList = new ArrayList<String>();
        if (assertController.getAsserion_test_strings() != null) {
            for (String strings : assertController.getAsserion_test_strings()) {
                if (strings.contains("\\\"")) {
                    strings = strings.replace("\\\"", "\"");
                }
                tempList.add(strings);
            }
            assertController.setAsserion_test_strings(tempList);
            Map resultMap = analyser.checkMatchTypeAndAnalysis(assertController, result);
            Object fail = resultMap.get("fail");
            if (fail != null) {
                actionPlugin.setEnd(true);
                KDAssert.fail(ResManager.loadKDString((String)"\u5f53\u524dpageId:", (String)"InvokeKdHttpActionMethod_6", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]) + pageId + "\n" + ResManager.loadKDString((String)"\u5f53\u524d\u6267\u884c\u53c2\u6570\u4e3a:", (String)"InvokeKdHttpActionMethod_7", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]) + param + "\n----------------------------------------------------------------\n" + fail + "\n----------------------------------------------------------------" + ResManager.loadKDString((String)"\n\u5e0c\u671b\u83b7\u5f97:\n", (String)"InvokeKdHttpActionMethod_8", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]) + assertController.getAsserion_test_strings() + "\n----------------------------------------------------------------" + ResManager.loadKDString((String)"\n\u8fd4\u56de\u7ed3\u679c\u4e3a:\n", (String)"InvokeKdHttpActionMethod_9", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]) + result);
                return false;
            }
            return true;
        }
        return true;
    }

    private boolean assertCatch(String result, AssertController assertController, UnitTestHttpActionPlugin actionPlugin) {
        AnalysisResponseBody analyser = new AnalysisResponseBody();
        ArrayList<String> tempList = new ArrayList<String>();
        if (assertController.getAsserion_test_strings() != null) {
            for (String strings : assertController.getAsserion_test_strings()) {
                if (strings.contains("\\\"")) {
                    strings = strings.replace("\\\"", "\"");
                }
                tempList.add(strings);
            }
            assertController.setAsserion_test_strings(tempList);
            Map resultMap = analyser.checkMatchTypeAndAnalysis(assertController, result);
            if (resultMap.containsKey("fail")) {
                actionPlugin.setEnd(true);
                KDAssert.fail(ResManager.loadKDString((String)"\n\u5e0c\u671b\u83b7\u5f97:\n", (String)"InvokeKdHttpActionMethod_8", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]) + assertController.getAsserion_test_strings() + "\n----------------------------------------------------------------" + ResManager.loadKDString((String)"\n\u8fd4\u56de\u7ed3\u679c\u4e3a:\n", (String)"InvokeKdHttpActionMethod_9", (String)BOS_UNITTEST_PLUGIN, (Object[])new Object[0]) + result);
                return false;
            }
            return true;
        }
        return true;
    }
}

