/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unittest.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.fileservice.BatchDownloadRequest;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.mservice.attachment.AttachmentType;
import kd.bos.mservice.attachment.IAttachmentService;
import kd.bos.mservice.form.FormService;
import kd.bos.mservice.form.FormServiceImpl;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.url.UrlService;
import kd.bos.web.DispatchServiceHelper;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.bos.web.actions.export.ExportWriter;
import kd.bos.web.actions.export.ExportWriterFormat;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class RequestUtil {
    public static final String SOURCE_PATH = "import_resources/";
    private static final FormService formService = new FormServiceImpl();
    private static final FileService fileService = FileServiceFactory.getAttachmentFileService();

    public static String batchInvokeAction(String appId, String pageId, String jsonParam) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            appId = "bos";
        }
        String result = "[]";
        result = (String)DispatchServiceHelper.invokeBOSServiceByAppId((String)appId, (String)"FormService", (String)"batchInvokeAction", (Object[])new Object[]{pageId, jsonParam});
        return result;
    }

    public static String getConfig(String jsonParam) {
        Map paras = (Map)SerializationUtils.fromJsonString((String)jsonParam, Map.class);
        String result = formService.getConfig(paras);
        return result;
    }

    public static String download(Map<String, String> params) {
        String path = params.get("path");
        String type = params.get("type");
        String id = params.get("id");
        if (StringUtils.isNotBlank((CharSequence)path)) {
            return RequestUtil.download(path);
        }
        if (StringUtils.isNotBlank((CharSequence)path) && StringUtils.isNotBlank((CharSequence)id)) {
            Map map = (Map)DispatchServiceHelper.invokeBOSService((String)IAttachmentService.class.getSimpleName(), (String)"getAttachmentInfoById", (Object[])new Object[]{AttachmentType.getTypeByValue((String)type), id});
            String url = map.get("path").toString();
            String file = map.get("fileName").toString();
            return RequestUtil.download(url);
        }
        return "";
    }

    public static String download(String url) {
        String fileName = url.substring(url.lastIndexOf(47) + 1);
        File downloadFile = new File(fileName);
        FileOutputStream out = null;
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            out = new FileOutputStream(downloadFile);
        }
        catch (FileNotFoundException e) {
            result.put("status", "error");
            result.put("description", e.getMessage());
            return SerializationUtils.toJsonString(result);
        }
        return RequestUtil.download(url, out, RequestContext.get().getUserAgent());
    }

    public static String download(String url, OutputStream out) {
        return RequestUtil.download(url, out, RequestContext.get().getUserAgent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String download(String url, OutputStream out, String userAgent) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            fileService.download(url, out, userAgent);
            result.put("url", url);
            result.put("status", "success");
        }
        catch (Exception e) {
            result.put("status", "error");
            result.put("description", e.getMessage());
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                result.put("status", "error");
                result.put("description", e.getMessage());
            }
        }
        String jsonResult = SerializationUtils.toJsonString(result);
        return jsonResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String uploadFile(String path) {
        String fileName = path.substring(path.lastIndexOf(47) + 1);
        try (InputStream in = ClassLoader.getSystemResourceAsStream(fileName);){
            String string = RequestUtil.uploadFile(fileName, path, in);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38", e);
        }
    }

    public static String uploadFile(String path, Class<?> cls) throws IOException {
        String fileName = path.substring(path.lastIndexOf(47) + 1);
        try (InputStream in = cls.getClassLoader().getResourceAsStream(fileName);){
            String string = RequestUtil.uploadFile(fileName, path, in);
            return string;
        }
    }

    private static String uploadFile(String fileName, String path, InputStream in) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int timeout = 7200;
        try {
            String path2 = null;
            if (path.indexOf(47) == 0) {
                path2 = path;
            } else {
                String file = RequestUtil.getRandomString(18);
                path2 = "/public/attachment/" + file + "/" + fileName;
            }
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            FileItem fileItem = new FileItem(fileName, path2, in);
            if (RequestUtil.isForbidUpload(fileItem.getFileName())) {
                String[] splits = fileItem.getFileName().trim().split("\\.");
                String fileType = splits[splits.length - 1];
                result.put("status", "error");
                String msg = "\u4e0d\u5141\u8bb8\u4e0a\u4f20\u8be5\u6587\u4ef6\u7c7b\u578b:" + fileType;
                result.put("description", msg);
                return SerializationUtils.toJsonString(result);
            }
            int size = fileItem.getInputStream().available();
            if (!RequestUtil.checkMaxSize(size)) {
                result.put("status", "error");
                String msg = "\u9644\u4ef6\u5927\u5c0f(" + fileItem.getInputStream().available() + ")\u8d85\u8fc7\u6700\u5927\u503c(" + RequestUtil.getMaxSize() + ")\u9650\u5236";
                result.put("description", msg);
                String jsonResult = SerializationUtils.toJsonString(result);
                return jsonResult;
            }
            String tempUrl = cache.saveAsUrl(fileItem.getFileName(), fileItem.getInputStream(), timeout);
            tempUrl = EncreptSessionUtils.encryptSession((String)tempUrl);
            String address = UrlService.getDomainContextUrl();
            if (!address.endsWith("/")) {
                address = address + "/";
            }
            tempUrl = address + tempUrl;
            result.put("url", tempUrl);
            result.put("size", size);
            result.put("status", "success");
        }
        catch (Exception e) {
            result.put("status", "error");
            result.put("description", e.getMessage());
        }
        String jsonResult = SerializationUtils.toJsonString(result);
        return jsonResult;
    }

    private static String getRandomString(int length) {
        StringBuilder val = new StringBuilder();
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < length; ++i) {
            String charOrNum;
            String string = charOrNum = random.nextInt(2) % 2 == 0 ? "char" : "num";
            if ("char".equalsIgnoreCase(charOrNum)) {
                int temp = random.nextInt(2) % 2 == 0 ? 65 : 97;
                val.append((char)(random.nextInt(26) + temp));
                continue;
            }
            if (!"num".equalsIgnoreCase(charOrNum)) continue;
            val.append(random.nextInt(10));
        }
        return val.toString();
    }

    private static boolean isForbidUpload(String fileName) {
        List<String> forbiddenFileTpyeList = new ArrayList();
        try {
            forbiddenFileTpyeList = fileService.getForbiddenExtensions();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object forbidden = DispatchServiceHelper.invokeBOSService((String)"SystemParamService", (String)"loadPublicParameterFromCache", (Object[])new Object[]{"forbidfiletype"});
        if (forbidden != null && StringUtils.isNotEmpty((CharSequence)((String)forbidden))) {
            forbiddenFileTpyeList.addAll(Arrays.asList(forbidden.toString().trim().split(",")));
        }
        String[] splits = fileName.trim().split("\\.");
        String fileType = splits[splits.length - 1];
        long occurCounts = forbiddenFileTpyeList.stream().filter(s -> s.equalsIgnoreCase(fileType)).count();
        return occurCounts != 0L;
    }

    private static int getMaxSize() {
        Object sizeMb = DispatchServiceHelper.invokeBOSService((String)"SystemParamService", (String)"loadPublicParameterFromCache", (Object[])new Object[]{"maxuploadsize"});
        if (sizeMb != null && !"0".equals(sizeMb.toString())) {
            int size = (Integer)sizeMb;
            return size * 1024 * 1024;
        }
        return fileService.getMaxUploadSize();
    }

    private static boolean checkMaxSize(int size) {
        int maxSize = RequestUtil.getMaxSize();
        return size <= maxSize;
    }

    public static String upload(String path, Class<?> cls) throws IOException {
        String fileName = path.substring(path.lastIndexOf(47) + 1);
        try (InputStream in = cls.getClassLoader().getResourceAsStream(fileName);){
            String string = RequestUtil.upload(fileName, path, in);
            return string;
        }
    }

    public static String upload(String path) throws IOException {
        String fileName = path.substring(path.lastIndexOf(47) + 1);
        try (InputStream in = ClassLoader.getSystemResourceAsStream(fileName);){
            String string = RequestUtil.upload(fileName, path, in);
            return string;
        }
    }

    private static String upload(String fileName, String path, InputStream in) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String path2 = null;
            path2 = path.indexOf(47) == 0 ? path : "/public/attachment/ixport/" + fileName;
            FileItem fileItem = new FileItem(fileName, path2, in);
            String ret = fileService.upload(fileItem);
            result.put("path", ret);
            result.put("status", "success");
        }
        catch (Exception e) {
            if (e instanceof KDException && e.getMessage().contains("file is already exist")) {
                result.put("path", path);
                result.put("status", "success");
            }
            result.put("status", "error");
            result.put("description", e.getMessage());
        }
        String jsonResult = SerializationUtils.toJsonString(result);
        return jsonResult;
    }

    private static Map getUrlParams(String url) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (!(url = url.replace('?', ';')).contains(";")) {
            return map;
        }
        if (url.split(";").length > 0) {
            String[] arr;
            for (String s : arr = url.split(";")[1].split("&")) {
                String key = s.split("=")[0];
                String value = s.split("=")[1];
                map.put(key, value);
            }
            return map;
        }
        return map;
    }

    public static String export(String url) throws IOException {
        URL param = new URL(URLDecoder.decode(url));
        Map request = RequestUtil.getUrlParams(url);
        return RequestUtil.export(request);
    }

    public static String export(Map<String, String> request) throws IOException {
        HashMap<String, String> result;
        block21: {
            String type = request.get("type");
            String exportId = request.get("exportid");
            String templateId = request.get("templateid");
            boolean fillParent = Boolean.parseBoolean(request.get("fillparent"));
            String routeAppId = request.get("routeappid");
            String formId = request.get("formid");
            String fileName = request.get("filename");
            String plugin = request.get("plugin");
            String extenddata = request.get("extenddata");
            result = new HashMap<String, String>();
            if (StringUtils.isBlank((CharSequence)formId) || StringUtils.isBlank((CharSequence)fileName)) {
                result.put("status", "error");
                result.put("description", "\u5355\u6807\u8bc6(formid)\u6216\u6587\u4ef6\u540d(filename)\u4e3a\u7a7a");
                String jsonResult = SerializationUtils.toJsonString(result);
                return jsonResult;
            }
            try {
                if (!"attachment".equals(type)) {
                    try (SXSSFWorkbook wb = new SXSSFWorkbook(5000);){
                        wb.setCompressTempFiles(true);
                        SXSSFSheet sheet = wb.createSheet("sheet1");
                        SXSSFSheet tempSheet = null;
                        ExportSheetStyle styles = new ExportSheetStyle(wb);
                        if (StringUtils.isNotBlank((CharSequence)templateId)) {
                            if (fillParent) {
                                tempSheet = wb.createSheet("sheet2");
                            }
                            RequestUtil.prepareExportData(wb, sheet, styles, routeAppId, formId, exportId, templateId, plugin, extenddata, fileName, tempSheet);
                        } else if (StringUtils.isNotBlank((CharSequence)exportId)) {
                            RequestUtil.prepareListData(wb, sheet, styles, routeAppId, formId, exportId);
                        }
                        if (tempSheet != null) {
                            wb.removeSheetAt(wb.getSheetIndex((Sheet)tempSheet));
                        }
                        wb.dispose();
                        break block21;
                    }
                }
                RequestUtil.downloadAttachment(routeAppId, formId, exportId, fileName);
            }
            catch (Exception e) {
                result.put("status", "error");
                result.put("description", e.getMessage());
            }
        }
        return SerializationUtils.toJsonString(result);
    }

    private static void prepareListData(SXSSFWorkbook wb, SXSSFSheet sheet, ExportSheetStyle styles, String routeAppId, String formId, String exportId) {
        int rowCount = 0;
        int pageIndex = 0;
        int pageSize = 2000;
        JSONObject dataAll = null;
        JSONArray dataArr = null;
        JSONArray titles = null;
        boolean hasNextPage = false;
        do {
            String dataJson = (String)DispatchServiceHelper.invokeBOSServiceByAppId((String)routeAppId, (String)"QueryService", (String)"getExportDataByList", (Object[])new Object[]{exportId, formId, titles == null, pageIndex, pageSize});
            dataAll = JSON.parseObject((String)dataJson);
            if (titles == null) {
                titles = JSON.parseArray((String)dataAll.getString("ListFieldCaptions"));
                ExportWriter.writeLine((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (JSONArray)titles, (int)rowCount++);
            }
            if (dataAll.containsKey((Object)"hasNextPage")) {
                hasNextPage = dataAll.getBooleanValue("hasNextPage");
            }
            dataArr = dataAll.getJSONArray("Data");
            for (int i = 0; i < dataArr.size(); ++i) {
                ExportWriter.writeLine((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (JSONArray)titles, (JSONArray)dataArr.getJSONArray(i), (int)rowCount++);
            }
            ++pageIndex;
        } while (dataArr.size() == pageSize || hasNextPage);
        DispatchServiceHelper.invokeBOSServiceByAppId((String)routeAppId, (String)"QueryService", (String)"releaseExportData", (Object[])new Object[]{exportId, formId});
    }

    private static void prepareExportData(SXSSFWorkbook wb, SXSSFSheet sheet, ExportSheetStyle styles, String routeAppId, String formId, String exportId, String templateId, String plugin, String extenddata, String fileName, SXSSFSheet tempSheet) {
        String exportJSon = (String)DispatchServiceHelper.invokeBOSServiceByAppId((String)routeAppId, (String)"MetadataService", (String)"getExportWriter", (Object[])new Object[]{formId, Long.parseLong(templateId), plugin == null ? "" : plugin, extenddata});
        List format = JSON.parseArray((String)exportJSon, ExportWriterFormat.class);
        ExportWriter.writeHeader((SXSSFWorkbook)wb, (SXSSFSheet)(tempSheet != null ? tempSheet : sheet), (ExportSheetStyle)styles, (List)format);
        if (StringUtils.isNotBlank((CharSequence)exportId)) {
            if (tempSheet != null) {
                SXSSFRow fillTitle = sheet.createRow(0);
                int i = 0;
                String cellVal = null;
                String displayCellVal = null;
                for (Cell cell : tempSheet.getRow(2)) {
                    cellVal = cell.getStringCellValue();
                    displayCellVal = cellVal.split(" # ")[0];
                    if (cellVal.endsWith(".name")) {
                        displayCellVal = displayCellVal + ResManager.loadKDString((String)".\u540d\u79f0", (String)"FormAction_0", (String)"bos-webactions", (Object[])new Object[0]);
                    } else if (cellVal.endsWith(".number")) {
                        displayCellVal = displayCellVal + ResManager.loadKDString((String)".\u7f16\u7801", (String)"FormAction_1", (String)"bos-webactions", (Object[])new Object[0]);
                    }
                    Cell tempCell = fillTitle.createCell(i, cell.getCellType());
                    tempCell.setCellStyle(cell.getCellStyle());
                    tempCell.setCellValue(displayCellVal);
                    ++i;
                }
            }
            int pageIndex = 0;
            int pageSize = Integer.parseInt(System.getProperty("Export_Page_Size", "300"));
            int rowIndex = tempSheet != null ? 1 : 3;
            JSONArray billArr = null;
            JSONArray pkArr = null;
            JSONObject dataAll = null;
            boolean hasNextPage = false;
            do {
                String dataJson = (String)DispatchServiceHelper.invokeBOSServiceByAppId((String)routeAppId, (String)"QueryService", (String)"getExportData", (Object[])new Object[]{exportId, formId, String.join((CharSequence)",", ((ExportWriterFormat)format.get(0)).listFields(new ArrayList())), pageIndex, pageSize});
                dataAll = JSON.parseObject((String)dataJson);
                billArr = dataAll.getJSONArray("data");
                pkArr = dataAll.getJSONArray("attachPkIds");
                if (dataAll.containsKey((Object)"hasNextPage")) {
                    hasNextPage = dataAll.getBooleanValue("hasNextPage");
                }
                for (int i = 0; i < billArr.size(); ++i) {
                    int offset = ExportWriter.writeData((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (JSONObject)billArr.getJSONObject(i), (int)rowIndex, (ExportWriterFormat)((ExportWriterFormat)format.get(0)), (pkArr != null && pkArr.size() > i && pkArr.get(i) != null ? 1 : 0) != 0, (String)fileName, (tempSheet != null ? 1 : 0) != 0);
                    if (offset > 1) {
                        rowIndex += offset;
                        continue;
                    }
                    ++rowIndex;
                }
                ++pageIndex;
            } while (billArr.size() == pageSize || hasNextPage);
            DispatchServiceHelper.invokeBOSServiceByAppId((String)routeAppId, (String)"QueryService", (String)"releaseExportData", (Object[])new Object[]{exportId, formId});
        }
        if (StringUtils.isNotBlank((CharSequence)((ExportWriterFormat)format.get(0)).getDescription())) {
            wb.createSheet(ResManager.loadKDString((String)"\u6a21\u677f\u8bf4\u660e", (String)"FormAction_2", (String)"bos-webactions", (Object[])new Object[0])).createRow(0).createCell(0).setCellValue(((ExportWriterFormat)format.get(0)).getDescription());
        }
    }

    public static void downloadAttachment(String routeAppId, String formId, String exportId, String fileName) throws IOException {
        BatchDownloadRequest attachReq = new BatchDownloadRequest("attachments.zip");
        int pageIndex = 0;
        int pageSize = 200;
        JSONArray attachArr = null;
        JSONObject retObj = null;
        ArrayList<BatchDownloadRequest.Dir> dirs = new ArrayList<BatchDownloadRequest.Dir>();
        do {
            String retJson = (String)DispatchServiceHelper.invokeBOSServiceByAppId((String)routeAppId, (String)"QueryService", (String)"getExportAttachment", (Object[])new Object[]{exportId, formId, pageIndex, pageSize});
            retObj = JSON.parseObject((String)retJson);
            attachArr = retObj.getJSONArray("attachs");
            for (int i = 0; i < attachArr.size(); ++i) {
                JSONArray attachs = attachArr.getJSONArray(i);
                if (attachs.isEmpty()) continue;
                BatchDownloadRequest.Dir dir = new BatchDownloadRequest.Dir("pk-" + attachs.getJSONObject(0).getString("pkId"));
                BatchDownloadRequest.File[] files = new BatchDownloadRequest.File[attachs.size()];
                for (int j = 0; j < files.length; ++j) {
                    JSONObject att = attachs.getJSONObject(j);
                    files[j] = new BatchDownloadRequest.File(att.getString("name"), att.getString("url"));
                }
                dir.setFiles(files);
                dirs.add(dir);
            }
            ++pageIndex;
        } while (retObj.getIntValue("billCount") == pageSize);
        if (!dirs.isEmpty()) {
            attachReq.setDirs(dirs.toArray(new BatchDownloadRequest.Dir[0]));
        }
        DispatchServiceHelper.invokeBOSServiceByAppId((String)routeAppId, (String)"QueryService", (String)"releaseExportData", (Object[])new Object[]{exportId, formId});
    }

    public static List<String> readPdfByUrl(String appId, String url) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            appId = "bos";
        }
        List contant = (List)DispatchServiceHelper.invokeBOSServiceByAppId((String)appId, (String)"PrintService", (String)"readPdfByUrl", (Object[])new Object[]{url});
        return contant;
    }

    public static boolean checkPdfContent(List<String> contant, String checkContent) {
        boolean result = false;
        if (contant != null) {
            for (String c : contant) {
                if (!c.contains(checkContent)) continue;
                result = true;
            }
        }
        return result;
    }

    public static boolean checkPdfContent(List<String> contant, String checkContent, int i) {
        boolean result = false;
        if (contant != null && contant.get(--i).contains(checkContent)) {
            result = true;
        }
        return result;
    }
}

