/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.modelasset.domainmodel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.metadata.domainmodel.define.DomainModelTypeFactory;

public class Element {
    public static List<ElementType> getElement(String domainModelId) {
        DomainModelType domainModelType = DomainModelTypeFactory.getDomainModelType((String)domainModelId, (boolean)true);
        return Element.getElement(domainModelType);
    }

    public static List<ElementType> getElement(DomainModelType modelType) {
        if (modelType.getId() == null) {
            return null;
        }
        ArrayList<DomainModelType> elementTypeList = new ArrayList<DomainModelType>(10);
        elementTypeList.add(modelType);
        return Element.getElement(elementTypeList, true);
    }

    public static List<ElementType> getElement(List<DomainModelType> domainModelTypeList, boolean isDeduplication) {
        ArrayList<ElementType> elementTypeList = new ArrayList<ElementType>(10);
        ArrayList<String> element = new ArrayList<String>(10);
        if (domainModelTypeList.isEmpty()) {
            return elementTypeList;
        }
        List<DomainModelType> mergeModelTypeList = Element.mergeExtModelType(domainModelTypeList);
        if (isDeduplication) {
            for (DomainModelType modelType : mergeModelTypeList) {
                for (Map.Entry entry : modelType.getElementTypes().entrySet()) {
                    String elementId;
                    ElementType type = (ElementType)entry.getValue();
                    if (type == null || element.contains(elementId = type.getId())) continue;
                    element.add(elementId);
                    elementTypeList.add(type);
                }
            }
        } else {
            for (DomainModelType modelType : mergeModelTypeList) {
                modelType.getElementTypes().forEach((s, elementType) -> elementTypeList.add((ElementType)elementType));
            }
        }
        return elementTypeList;
    }

    public static List<DomainModelType> mergeExtModelType(List<DomainModelType> domainModelTypes) {
        ArrayList<DomainModelType> mergeModelList = new ArrayList<DomainModelType>(domainModelTypes.size());
        for (DomainModelType modelType : domainModelTypes) {
            String id = modelType.getId();
            if (StringUtils.isBlank((CharSequence)id)) continue;
            mergeModelList.add(DomainModelTypeFactory.getDomainModelType((String)id, (boolean)true));
        }
        return mergeModelList;
    }

    public static synchronized long getElementCount(List<DomainModelType> domainModelTypeList, boolean isDeduplication) {
        List<ElementType> element = Element.getElement(domainModelTypeList, isDeduplication);
        return element.size();
    }

    public static ElementType getElement(DomainModelType domainModelType, String elementId) {
        ElementType elementType = new ElementType();
        if (elementId == null) {
            return elementType;
        }
        List<ElementType> element = Element.getElement(domainModelType);
        if (element == null) {
            return new ElementType();
        }
        for (ElementType type : element) {
            if (!elementId.equals(type.getId())) continue;
            elementType = type;
            break;
        }
        return elementType;
    }
}

