/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.modelasset.domainmodel;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.domainmodel.Property;
import kd.bos.metadata.domainmodel.define.DomainModelTypeDefiner;
import kd.bos.metadata.domainmodel.define.DomainModelTypeDefiners;
import kd.bos.metadata.domainmodel.define.DomainModelTypeFactory;
import kd.bos.metadata.domainmodel.define.Resource;

public class ModelType {
    private static List<DomainModelType> domainModelTypeList = new ArrayList<DomainModelType>(10);
    private static final Log log = LogFactory.getLog(ModelType.class);
    private List<DomainModelType> list = new ArrayList<DomainModelType>(10);
    private static List<String> invalidityModel = new ArrayList<String>(5);
    private static List<String> extendModels = new ArrayList<String>(2);
    private static final String DOMAIN_MODEL_PRODUCT_PATH = "domainmodel/product/";

    @CollectionPropertyAttribute(collectionItemPropertyType=DomainModelType.class)
    public List<DomainModelType> getList() {
        return this.list;
    }

    public static List<DomainModelType> getDomainModelTypes() {
        if (domainModelTypeList.isEmpty()) {
            ArrayList<IDataEntityType> entityTypes = new ArrayList<IDataEntityType>(2);
            entityTypes.add(OrmUtils.getDataEntityType(ModelType.class));
            entityTypes.add(OrmUtils.getDataEntityType(DomainModelType.class));
            DcxmlSerializer ser = new DcxmlSerializer((DcBinder)new ListDcxmlBinder(false, entityTypes));
            URL resource = Property.class.getResource("/DomainModelType.xml");
            try {
                String xml = ModelType.read(resource);
                xml = xml.replace("<DomainModelTypes>", "<ModelType><List>");
                xml = xml.replace("</DomainModelTypes>", "</List></ModelType>");
                ModelType modelType = (ModelType)ser.deserializeFromString(xml, null);
                DomainModelType reportFormModel = DomainModelTypeFactory.getDomainModelType((String)"ReportFormModel", (boolean)true);
                domainModelTypeList.add(reportFormModel);
                DomainModelType mobileFormModel = DomainModelTypeFactory.getDomainModelType((String)"MobileFormModel", (boolean)true);
                domainModelTypeList.add(mobileFormModel);
                for (DomainModelType model : modelType.getList()) {
                    if (invalidityModel.contains(model.getId())) continue;
                    domainModelTypeList.add(model);
                }
                return domainModelTypeList;
            }
            catch (IOException e) {
                log.error("\u8bfb\u53d6DomainModelType.xml\u6587\u4ef6\u5931\u8d25");
                throw new KDBizException("/DomainModelType.xml read error");
            }
        }
        return domainModelTypeList;
    }

    public static synchronized long getModelTypeCount() {
        return ModelType.getDomainModelTypes().size();
    }

    public static List<DomainModelType> getExtDomainModel() {
        List<IDataEntityType> dts = ModelType.getDomainModelDefinerEntityTypes();
        ArrayList<DomainModelType> extModelList = new ArrayList<DomainModelType>(2);
        DcxmlSerializer ser = new DcxmlSerializer((DcBinder)new ListDcxmlBinder(false, dts));
        for (String extModel : extendModels) {
            URL resource = DomainModelTypeDefiners.class.getResource("/domainmodel/product/" + extModel);
            DomainModelTypeDefiner extModelTypeDefiner = (DomainModelTypeDefiner)ser.deserialize(resource, null);
            String extName = extModelTypeDefiner.getTypeName();
            DomainModelType domainModelType = DomainModelTypeFactory.getDomainModelType((String)extName, (boolean)true);
            extModelList.add(domainModelType);
        }
        return extModelList;
    }

    private static List<IDataEntityType> getDomainModelDefinerEntityTypes() {
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(DomainModelTypeDefiners.class));
        dts.add(OrmUtils.getDataEntityType(DomainModelTypeDefiner.class));
        dts.add(OrmUtils.getDataEntityType(Resource.class));
        return dts;
    }

    private static String read(URL url) throws IOException {
        byte[] buffer = new byte[1024];
        int len = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (InputStream stream = url.openStream();){
            while ((len = stream.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
        }
        bos.close();
        byte[] bytes = bos.toByteArray();
        int start = 0;
        if (bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65) {
            start = 3;
        }
        return new String(bos.toByteArray(), start, bytes.length - start, StandardCharsets.UTF_8);
    }

    static {
        invalidityModel.add("QuerySourceModel");
        invalidityModel.add("ParameterFormModel_public");
        invalidityModel.add("ReportModel");
        invalidityModel.add("BaseEntityModel");
        invalidityModel.add("BillEntityModel");
        ArrayList<String> ets = new ArrayList<String>(2);
        ets.add("HR");
        ets.add("SSC");
        for (String model : ets) {
            extendModels.add(model + "Model.model");
        }
    }
}

