/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.modelasset.domainmodel;

import java.util.ArrayList;
import java.util.List;
import kd.bos.entity.operate.bizrule.OpBizRuleType;
import kd.bos.entity.operate.bizrule.OpBizRuleTypeLoader;
import kd.bos.entity.operate.bizrule.OpBizRuleTypes;
import kd.bos.modelasset.dao.util.ModelUtil;

public class OperatorService {
    public static synchronized long getOperatorServiceCount(String bizAppId) {
        return OperatorService.getOpBizRuleTypesByAppNumber(bizAppId).size();
    }

    public static synchronized long getOperatorServiceCount() {
        return OperatorService.getOpBizRuleTypes().size();
    }

    public static List<OpBizRuleType> getOpBizRuleTypes() {
        OpBizRuleTypes opBizRuleTypes = OpBizRuleTypeLoader.load();
        return opBizRuleTypes.getRuleTypes();
    }

    public static List<OpBizRuleType> getOpBizRuleTypesByAppNumber(String bizAppId) {
        List<OpBizRuleType> opBizRuleTypes = OperatorService.getOpBizRuleTypes();
        String appNumber = ModelUtil.getAppNumberById((String)bizAppId);
        ArrayList<OpBizRuleType> opBizRuleTypeList = new ArrayList<OpBizRuleType>(10);
        for (OpBizRuleType opBizRuleType : opBizRuleTypes) {
            int appliedRange = opBizRuleType.getAppliedRange();
            boolean isBelong = true;
            switch (appliedRange) {
                case 1: 
                case 2: {
                    String appliedAppNumbers = opBizRuleType.getAppliedAppNumbers();
                    isBelong = OperatorService.isBelongApp(appNumber, appliedAppNumbers);
                    break;
                }
            }
            if (!isBelong) continue;
            opBizRuleTypeList.add(opBizRuleType);
        }
        return opBizRuleTypeList;
    }

    public static boolean isBelongApp(String appnumber, String appliedAppNumbers) {
        String[] numbers;
        for (String number : numbers = appliedAppNumbers.trim().split(",")) {
            if (!number.equalsIgnoreCase(appnumber)) continue;
            return true;
        }
        return false;
    }
}

