/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.modelasset.domainmodel;

import java.util.ArrayList;
import java.util.List;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.metadata.domainmodel.Property;

public class PropertyType {
    public static List<Property> getProperty(ElementType elementType) {
        if (elementType == null) {
            return null;
        }
        return elementType.getProperties();
    }

    public static List<Property> getProperty(List<ElementType> elementTypeList, boolean isDeduplication) {
        ArrayList<Property> propertyList = new ArrayList<Property>(10);
        ArrayList<String> propertyName = new ArrayList<String>(10);
        if (elementTypeList.isEmpty()) {
            return propertyList;
        }
        if (isDeduplication) {
            for (ElementType elementType : elementTypeList) {
                List properties = elementType.getProperties();
                for (Property property : properties) {
                    String name = property.getPropertyName();
                    if (propertyName.contains(name)) continue;
                    propertyName.add(name);
                    propertyList.add(property);
                }
            }
        } else {
            for (ElementType elementType : elementTypeList) {
                List properties = elementType.getProperties();
                propertyList.addAll(properties);
            }
        }
        return propertyList;
    }

    public static synchronized long getPropertyCount(List<ElementType> elementTypeList, boolean isDeduplication) {
        List<Property> property = PropertyType.getProperty(elementTypeList, isDeduplication);
        return property.size();
    }

    public static Property getProperty(ElementType elementType, String propertyName) {
        if (elementType == null || propertyName == null) {
            return null;
        }
        List properties = elementType.getProperties();
        Property property = new Property();
        for (Property pro : properties) {
            String name = pro.getPropertyName();
            if (!propertyName.equals(name)) continue;
            property = pro;
            break;
        }
        return property;
    }
}

