/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.modelasset.domainmodel;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.metadata.entity.validation.ValidationType;
import kd.bos.metadata.entity.validation.ValidationTypeLoader;
import kd.bos.metadata.entity.validation.ValidationTypes;
import kd.bos.modelasset.dao.util.ModelUtil;

public class Validator {
    public static List<ValidationType> getValidationType(String bizAppId) {
        ValidationTypes validationTypes = ValidationTypeLoader.load();
        String appNumber = ModelUtil.getAppNumberById((String)bizAppId);
        List validationType = validationTypes.getTypes();
        ArrayList<ValidationType> belongAppValTypes = new ArrayList<ValidationType>(10);
        for (ValidationType validation : validationType) {
            boolean belongApp = Validator.isBelongApp(validation, appNumber);
            if (!belongApp) continue;
            belongAppValTypes.add(validation);
        }
        return belongAppValTypes;
    }

    public static synchronized long getValidationCount(String bizAppId) {
        List<ValidationType> validationType = Validator.getValidationType(bizAppId);
        if (validationType == null) {
            return 0L;
        }
        return validationType.size();
    }

    public static synchronized long getValidationCount() {
        List<ValidationType> validationType = Validator.getValidationType();
        if (validationType == null) {
            return 0L;
        }
        return validationType.size();
    }

    public static List<ValidationType> getValidationType() {
        ValidationTypes validationTypes = ValidationTypeLoader.load();
        return validationTypes.getTypes();
    }

    public static boolean isBelongApp(ValidationType validationType, String appNumber) {
        int appliedRange = validationType.getAppliedRange();
        if (appliedRange == 0) {
            return true;
        }
        if (appliedRange == 1 || appliedRange == 2) {
            String[] numbers;
            String appNumbers = validationType.getAppNumbers();
            if (StringUtils.isBlank((CharSequence)appNumbers)) {
                return true;
            }
            for (String number : numbers = appNumbers.trim().split(",")) {
                if (!number.equals(appNumber)) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

