/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.modelasset.service.context;

import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.utils.StringUtils;

public class AssetSyncState {
    private static final int CACHE_TIMEOUT = 3600;
    private static final String TOTAL_COUNT = "model_asset_cache_total_count";
    private static final String ASSET_PROGRESS = "model_asset_cache_asset_progress";
    private static final String ASSET_TASKID = "model_asset_cache_asset_taskid";
    private static final long APP_COST = 3000L;
    private DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
    private int totalCount = 0;

    public void setProgress() {
        this.cache.inc(ASSET_PROGRESS, 3600);
    }

    public int getProgress() {
        int total;
        int proVal;
        int progress = 0;
        String progressStr = (String)this.cache.get(ASSET_PROGRESS);
        if (StringUtils.isNotBlank((CharSequence)progressStr)) {
            progress = Integer.parseInt(progressStr);
        }
        if ((proVal = progress * 100 / (total = this.getTotal() == 0 ? 1 : this.getTotal())) > 100) {
            proVal = 99;
        }
        return proVal;
    }

    public long getRemainderTime() {
        int remainderCount;
        int progress = 0;
        String progressStr = (String)this.cache.get(ASSET_PROGRESS);
        if (StringUtils.isNotBlank((CharSequence)progressStr)) {
            progress = Integer.parseInt(progressStr);
        }
        if ((remainderCount = this.getTotal() - progress) < 0) {
            remainderCount = 0;
        }
        return (long)remainderCount * 3000L;
    }

    public void setTotal(int total) {
        this.totalCount = total;
        this.cache.put(TOTAL_COUNT, (Object)String.valueOf(total), 3600);
    }

    public int getTotal() {
        String total;
        if (this.totalCount == 0 && StringUtils.isNotBlank((CharSequence)(total = (String)this.cache.get(TOTAL_COUNT)))) {
            this.totalCount = Integer.parseInt(total);
        }
        return this.totalCount;
    }

    public void setTaskId(String taskId) {
        this.cache.put(ASSET_TASKID, (Object)taskId, 3600);
    }

    public String getTaskId() {
        return (String)this.cache.get(ASSET_TASKID);
    }

    public void reset() {
        this.cache.remove(new String[]{ASSET_TASKID, TOTAL_COUNT, ASSET_PROGRESS});
    }
}

