/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.modelasset.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.plugin.support.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.modelasset.dao.repository.BizAppDao;
import kd.bos.modelasset.service.AppService;

public class AppServiceImpl
implements AppService {
    private static Log logger = LogFactory.getLog(AppServiceImpl.class);
    BizAppDao bizAppDao = new BizAppDao();

    public List<Map<String, String>> getAppList(boolean includeExt) {
        return this.bizAppDao.getAppByIsv(null, includeExt);
    }

    public List<Map<String, String>> getAppByIsv(String isv, boolean includeExt) {
        return this.bizAppDao.getAppByIsv(isv, includeExt);
    }

    public List<Map<String, String>> getAppByCloudId(String cloudId, boolean includeExt) {
        return this.bizAppDao.getAppByCloudId(cloudId, includeExt);
    }

    public JSONArray getAppListByCloudId(String cloudId) {
        if (StringUtils.isEmpty((Object)cloudId)) {
            return new JSONArray();
        }
        return DevportalUtil.getAppsInCloud((String)cloudId);
    }

    public List<Map<String, String>> getAppByMasterId(String appId) {
        return this.bizAppDao.getAppByMasterId(appId);
    }

    public Set<String> getAppIdByMasterId(String appId) {
        return this.bizAppDao.getAppIdByMasterId(appId);
    }

    public String getDefaultAppId(List<Map<String, String>> appList) {
        Map<String, String> map;
        if (appList != null && !appList.isEmpty() && (map = appList.get(0)) != null) {
            return map.get("id");
        }
        return null;
    }

    public String getDefaultAppId(JSONArray appList) {
        JSONObject object;
        if (appList != null && !appList.isEmpty() && (object = (JSONObject)appList.get(0)) != null) {
            return object.getString("id");
        }
        return null;
    }
}

