/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.modelasset.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.modelasset.dao.entity.Statistics;
import kd.bos.modelasset.dao.enums.AssetGroup;
import kd.bos.modelasset.dao.enums.AssetType;
import kd.bos.modelasset.dao.repository.StatisticsDao;
import kd.bos.modelasset.domainmodel.ModelType;
import kd.bos.modelasset.service.AppService;
import kd.bos.modelasset.service.ModelAssetsSyncService;
import kd.bos.modelasset.service.ModelService;
import kd.bos.modelasset.service.OperationService;
import kd.bos.modelasset.service.PluginAndRuleService;
import kd.bos.modelasset.service.TemplateService;
import kd.bos.modelasset.service.context.AssetSyncContext;
import kd.bos.modelasset.service.context.AssetSyncState;
import kd.bos.modelasset.service.impl.AppServiceImpl;
import kd.bos.modelasset.service.impl.DevportalSyncServiceImpl;
import kd.bos.modelasset.service.impl.ModelServiceImpl;
import kd.bos.modelasset.service.impl.OperationServiceImpl;
import kd.bos.modelasset.service.impl.PluginAndRuleServiceImpl;
import kd.bos.modelasset.service.impl.TemplateServiceImpl;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.threads.ThreadPools;

public class ModelAssetsSyncServiceImpl
extends AbstractTask
implements ModelAssetsSyncService {
    private static Log log = LogFactory.getLog(ModelAssetsSyncServiceImpl.class);
    private static String EXT_TYPE = "2";
    private static ExecutorService es = ThreadPools.newExecutorService((String)"ModelAssetsSyncServiceImpl-Thread", (int)4);
    ConcurrentHashMap<String, Long> statisticsCountData = new ConcurrentHashMap(16);
    ModelAssetsSyncService devportalSync = new DevportalSyncServiceImpl();
    TemplateService templateService = new TemplateServiceImpl();
    OperationService operationService = new OperationServiceImpl();
    PluginAndRuleService pluginAndRuleService = new PluginAndRuleServiceImpl();
    ModelService modelService = new ModelServiceImpl();
    AppService appService = new AppServiceImpl();

    private List<List<Map<String, String>>> spliceArrays(List<Map<String, String>> datas, int splitSize) {
        if (datas == null || splitSize < 1) {
            return new ArrayList<List<Map<String, String>>>();
        }
        int totalSize = datas.size();
        int count = totalSize % splitSize == 0 ? totalSize / splitSize : totalSize / splitSize + 1;
        ArrayList<List<Map<String, String>>> rows = new ArrayList<List<Map<String, String>>>(10);
        for (int i = 0; i < count; ++i) {
            List<Map<String, String>> cols = datas.subList(i * splitSize, i == count - 1 ? totalSize : splitSize * (i + 1));
            rows.add(cols);
        }
        return rows;
    }

    private List<Map<String, String>> getOriginAppList(List<Map<String, String>> appList) {
        return appList.stream().filter(map -> !((String)map.get("type")).equals(EXT_TYPE)).collect(Collectors.toList());
    }

    private Map<String, List<Map<String, String>>> getExtAppMap(List<Map<String, String>> appList, List<Map<String, String>> originAppList) {
        HashMap<String, List<Map<String, String>>> extAppMap = new HashMap<String, List<Map<String, String>>>(16);
        for (Map<String, String> originApp : originAppList) {
            String appId = originApp.get("id");
            ArrayList<Map<String, String>> extAppList = new ArrayList<Map<String, String>>();
            for (Map<String, String> app : appList) {
                String type = app.get("type");
                String masterId = app.get("masterId");
                if (!type.equals(EXT_TYPE) || !masterId.equals(appId)) continue;
                extAppList.add(app);
            }
            extAppMap.put(appId, extAppList);
        }
        return extAppMap;
    }

    public void execute(RequestContext paramRequestContext, Map<String, Object> paramMap) throws KDException {
        try (DLock lock = DLock.create((String)"modelassets_index_sync");){
            if (!lock.tryLock(0L)) {
                log.info(String.format("ModelAssetsSyncServiceImpl - %s:\u6a21\u578b\u8d44\u4ea7\u6570\u636e\u6b63\u5728\u5237\u65b0\u540c\u6b65\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", this.taskId));
                return;
            }
            log.info(String.format("ModelAssetsSyncServiceImpl - %s:\u6a21\u578b\u8d44\u4ea7\u540c\u6b65\u5f00\u59cb\u6267\u884c", this.taskId));
            long start = System.currentTimeMillis();
            String isv = ISVServiceHelper.getISVInfo().getId();
            List appList = this.appService.getAppList(true);
            List<Map<String, String>> originAppList = this.getOriginAppList(appList);
            Map<String, List<Map<String, String>>> extAppMap = this.getExtAppMap(appList, originAppList);
            if (originAppList != null && !originAppList.isEmpty()) {
                AssetSyncState state = new AssetSyncState();
                int appSize = originAppList.size();
                state.setTaskId(this.taskId);
                state.setTotal(appSize + 1);
                ConcurrentHashMap<String, List<Statistics>> statisticsData = new ConcurrentHashMap<String, List<Statistics>>(originAppList.size());
                int batch = originAppList.size() / 4;
                List<List<Map<String, String>>> splitAppList = this.spliceArrays(originAppList, batch);
                if (splitAppList.isEmpty()) {
                    return;
                }
                CountDownLatch countDownLatch = new CountDownLatch(splitAppList.size());
                for (List<Map<String, String>> splitApp : splitAppList) {
                    es.execute(new Worker(RequestContext.get(), countDownLatch, isv, splitApp, extAppMap, statisticsData, state));
                }
                try {
                    boolean success = countDownLatch.await(60L, TimeUnit.MINUTES);
                    if (!success) {
                        log.info(String.format("ModelAssetsSyncServiceImpl - %s:\u6a21\u578b\u8d44\u4ea7\u540c\u6b65\u4efb\u52a1\u8d85\u65f6", this.taskId));
                    }
                }
                catch (InterruptedException e) {
                    log.error(String.format("ModelAssetsSyncServiceImpl - %s:\u6a21\u578b\u8d44\u4ea7\u6267\u884c\u540c\u6b65\u4efb\u52a1\u5f02\u5e38", this.taskId), (Throwable)e);
                }
                for (Map.Entry data : statisticsData.entrySet()) {
                    StatisticsDao.batchSave((String)((String)data.getKey()), (List)((List)data.getValue()));
                }
                state.setProgress();
            }
            long end = System.currentTimeMillis();
            long cost = end - start;
            log.info(String.format("ModelAssetsSyncServiceImpl - %s:\u6a21\u578b\u8d44\u4ea7\u540c\u6b65\u5b8c\u6210\uff0c\u8017\u65f6\uff1a%s", this.taskId, cost));
        }
        catch (Exception e) {
            AssetSyncState state = new AssetSyncState();
            state.reset();
            log.error(String.format("ModelAssetsSyncServiceImpl - %s:\u6a21\u578b\u8d44\u4ea7\u540c\u6b65\u4efb\u52a1\u89e6\u53d1\u5931\u8d25\u3002", this.taskId), (Throwable)e);
        }
    }

    private List<Statistics> getBizEntityTempStatistics(AssetSyncContext context) {
        ArrayList<Statistics> list = new ArrayList<Statistics>(2);
        List bizCommonTempList = this.templateService.getBizEntityTempList(context.getIsv(), context.getCloudId(), context.getAppId());
        Statistics commonStatistics = new Statistics();
        commonStatistics.setIsv(context.getIsv());
        commonStatistics.setBizAppId(context.getAppId());
        commonStatistics.setAssetGroup(AssetGroup.Common.getValue());
        commonStatistics.setAssetType(AssetType.BizModelTemp.getValue());
        commonStatistics.setCount((long)bizCommonTempList.size());
        list.add(commonStatistics);
        long appBizTempCount = bizCommonTempList.stream().filter(x -> x.get("appId").equals(context.getAppId())).count();
        Statistics statistics = new Statistics();
        statistics.setIsv(context.getIsv());
        statistics.setBizAppId(context.getAppId());
        statistics.setAssetGroup(AssetGroup.App.getValue());
        statistics.setAssetType(AssetType.BizModelTemp.getValue());
        statistics.setCount(appBizTempCount);
        list.add(statistics);
        return list;
    }

    private Statistics getSysEntityTempStatistics(AssetSyncContext context) {
        Long sysTempCount = this.statisticsCountData.get("Common-SysModelTemp");
        if (sysTempCount == null) {
            List sysTempList = this.templateService.getSysEntityTempList();
            sysTempCount = sysTempList.size();
            this.statisticsCountData.putIfAbsent("Common-SysModelTemp", sysTempCount);
        }
        Statistics statistics = new Statistics();
        statistics.setIsv(context.getIsv());
        statistics.setBizAppId(context.getAppId());
        statistics.setAssetGroup(AssetGroup.Common.getValue());
        statistics.setAssetType(AssetType.SysModelTemp.getValue());
        statistics.setCount(sysTempCount.longValue());
        return statistics;
    }

    private Statistics getWorkflowTempStatistics(AssetSyncContext context) {
        long count = this.templateService.getWorkflowTempCount(context.getIsv(), context.getCloudId(), context.getAppId());
        Statistics statistics = new Statistics();
        statistics.setIsv(context.getIsv());
        statistics.setBizAppId(context.getAppId());
        statistics.setAssetGroup(AssetGroup.Common.getValue());
        statistics.setAssetType(AssetType.WorkflowTemp.getValue());
        statistics.setCount(count);
        return statistics;
    }

    private Statistics getWorkflowNodeTempStatistics(AssetSyncContext context) {
        Long count = this.statisticsCountData.get("Common-WorkflowNodeTemp");
        if (count == null) {
            count = this.templateService.getWorkflowNodeTempCount(context.getIsv(), context.getCloudId(), context.getAppId());
            this.statisticsCountData.putIfAbsent("Common-WorkflowNodeTemp", count);
        }
        Statistics statistics = new Statistics();
        statistics.setIsv(context.getIsv());
        statistics.setBizAppId(context.getAppId());
        statistics.setAssetGroup(AssetGroup.Common.getValue());
        statistics.setAssetType(AssetType.WorkflowNodeTemp.getValue());
        statistics.setCount(count.longValue());
        return statistics;
    }

    private Statistics getSysPrintTempStatistics(AssetSyncContext context) {
        Long count = this.statisticsCountData.get("Common-PrintTemp");
        if (count == null) {
            count = this.templateService.getSysPrintTempCount();
            this.statisticsCountData.putIfAbsent("Common-PrintTemp", count);
        }
        Statistics statistics = new Statistics();
        statistics.setIsv(context.getIsv());
        statistics.setBizAppId(context.getAppId());
        statistics.setAssetGroup(AssetGroup.Common.getValue());
        statistics.setAssetType(AssetType.PrintTemp.getValue());
        statistics.setCount(count.longValue());
        return statistics;
    }

    private Statistics getBizPrintTempStatistics(AssetSyncContext context) {
        long count = this.templateService.getBizPrintTempCount(context.getAppId());
        Statistics statistics = new Statistics();
        statistics.setIsv(context.getIsv());
        statistics.setBizAppId(context.getAppId());
        statistics.setAssetGroup(AssetGroup.App.getValue());
        statistics.setAssetType(AssetType.PrintTemp.getValue());
        statistics.setCount(count);
        return statistics;
    }

    private List<Statistics> getPluginAndRuleStatistics(AssetSyncContext context) {
        Map map = this.pluginAndRuleService.getCountByAppId(context.getIsv(), context.getCloudId(), context.getAppId());
        ArrayList<Statistics> list = new ArrayList<Statistics>(2);
        Statistics plugin = new Statistics();
        plugin.setIsv(context.getIsv());
        plugin.setBizAppId(context.getAppId());
        plugin.setAssetGroup(AssetGroup.App.getValue());
        plugin.setAssetType(AssetType.Plugin.getValue());
        plugin.setCount((long)((Integer)map.get("plugin")).intValue());
        list.add(plugin);
        Statistics rule = new Statistics();
        rule.setIsv(context.getIsv());
        rule.setBizAppId(context.getAppId());
        rule.setAssetGroup(AssetGroup.App.getValue());
        rule.setAssetType(AssetType.RuleEntity.getValue());
        rule.setCount((long)((Integer)map.get("ruleEntity")).intValue());
        list.add(rule);
        return list;
    }

    private List<Statistics> getOperationStatistics(AssetSyncContext context) {
        ArrayList<Statistics> list = new ArrayList<Statistics>(2);
        long operatorCount = this.modelService.getOperatorCount(context.getAppId());
        Statistics operatorStatistics = new Statistics();
        operatorStatistics.setAssetGroup(AssetGroup.App.getValue());
        operatorStatistics.setAssetType(AssetType.Operator.getValue());
        operatorStatistics.setBizAppId(context.getAppId());
        operatorStatistics.setCount(operatorCount);
        list.add(operatorStatistics);
        long operatorServiceCount = this.modelService.getOperatorServiceCount(context.getAppId());
        Statistics serviceStatistics = new Statistics();
        serviceStatistics.setAssetGroup(AssetGroup.App.getValue());
        serviceStatistics.setAssetType(AssetType.Service.getValue());
        serviceStatistics.setBizAppId(context.getAppId());
        serviceStatistics.setCount(operatorServiceCount);
        list.add(serviceStatistics);
        return list;
    }

    private Statistics getModelStatistics(AssetSyncContext context) {
        Long modelTypeCount = this.statisticsCountData.get("Meta-ModelType");
        if (modelTypeCount == null) {
            modelTypeCount = ModelType.getModelTypeCount();
            this.statisticsCountData.putIfAbsent("Meta-ModelType", modelTypeCount);
        }
        Statistics statistics = new Statistics();
        statistics.setAssetGroup(AssetGroup.Meta.getValue());
        statistics.setAssetType(AssetType.ModelType.getValue());
        statistics.setCount(modelTypeCount.longValue());
        statistics.setBizAppId(context.getAppId());
        return statistics;
    }

    private Statistics getElementStatistics(AssetSyncContext context) {
        Long elementCount = this.statisticsCountData.get("Meta-Element");
        if (elementCount == null) {
            elementCount = this.modelService.getElementCount();
            this.statisticsCountData.putIfAbsent("Meta-Element", elementCount);
        }
        Statistics statistics = new Statistics();
        statistics.setAssetType(AssetGroup.Meta.getValue());
        statistics.setAssetType(AssetType.Element.getValue());
        statistics.setCount(elementCount.longValue());
        statistics.setBizAppId(context.getAppId());
        return statistics;
    }

    private List<Statistics> getAppElementAndRuleStatistics(AssetSyncContext context) {
        ArrayList<Statistics> list = new ArrayList<Statistics>(2);
        Statistics elementStatistics = new Statistics();
        elementStatistics.setAssetGroup(AssetGroup.App.getValue());
        elementStatistics.setAssetType(AssetType.Element.getValue());
        elementStatistics.setCount(0L);
        elementStatistics.setBizAppId(context.getAppId());
        list.add(elementStatistics);
        Statistics ruleStatistics = new Statistics();
        ruleStatistics.setAssetGroup(AssetGroup.App.getValue());
        ruleStatistics.setAssetType(AssetType.Rule.getValue());
        ruleStatistics.setCount(0L);
        ruleStatistics.setBizAppId(context.getAppId());
        list.add(ruleStatistics);
        return list;
    }

    private Statistics getPropertyStatistics(AssetSyncContext context) {
        Long propertyCount = this.statisticsCountData.get("Meta-Property");
        if (propertyCount == null) {
            propertyCount = this.modelService.getPropertyCount();
            this.statisticsCountData.putIfAbsent("Meta-Property", propertyCount);
        }
        Statistics statistics = new Statistics();
        statistics.setAssetGroup(AssetGroup.Meta.getValue());
        statistics.setAssetType(AssetType.Property.getValue());
        statistics.setCount(propertyCount.longValue());
        statistics.setBizAppId(context.getAppId());
        return statistics;
    }

    private Statistics getOperatorStatistics(AssetSyncContext context) {
        Long operateCount = this.statisticsCountData.get("Meta-Operator");
        if (operateCount == null) {
            operateCount = this.modelService.getOperatorCount();
            this.statisticsCountData.putIfAbsent("Meta-Operator", operateCount);
        }
        Statistics statistics = new Statistics();
        statistics.setAssetGroup(AssetGroup.Meta.getValue());
        statistics.setAssetType(AssetType.Operator.getValue());
        statistics.setCount(operateCount.longValue());
        statistics.setBizAppId(context.getAppId());
        return statistics;
    }

    private Statistics getValidatorStatistics(AssetSyncContext context) {
        Long validationCount = this.statisticsCountData.get("Meta-Validator");
        if (validationCount == null) {
            validationCount = this.modelService.getValidatorCount();
            this.statisticsCountData.putIfAbsent("Meta-Validator", validationCount);
        }
        Statistics statistics = new Statistics();
        statistics.setAssetGroup(AssetGroup.Meta.getValue());
        statistics.setAssetType(AssetType.Validator.getValue());
        statistics.setCount(validationCount.longValue());
        statistics.setBizAppId(context.getAppId());
        return statistics;
    }

    private Statistics getOperatorServiceStatistics(AssetSyncContext context) {
        Long operatorServiceCount = this.statisticsCountData.get("Meta-Service");
        if (operatorServiceCount == null) {
            operatorServiceCount = this.modelService.getOperatorServiceCount();
            this.statisticsCountData.putIfAbsent("Meta-Service", operatorServiceCount);
        }
        Statistics statistics = new Statistics();
        statistics.setAssetGroup(AssetGroup.Meta.getValue());
        statistics.setAssetType(AssetType.Service.getValue());
        statistics.setCount(operatorServiceCount.longValue());
        statistics.setBizAppId(context.getAppId());
        return statistics;
    }

    private Statistics getRuleCount(AssetSyncContext context) {
        Long ruleCount = this.statisticsCountData.get("Meta-Rule");
        if (ruleCount == null) {
            ruleCount = this.modelService.getRuleCount();
            this.statisticsCountData.putIfAbsent("Meta-Rule", ruleCount);
        }
        Statistics statistics = new Statistics();
        statistics.setAssetGroup(AssetGroup.Meta.getValue());
        statistics.setAssetType(AssetType.Rule.getValue());
        statistics.setCount(ruleCount.longValue());
        statistics.setBizAppId(context.getAppId());
        return statistics;
    }

    class Worker
    implements Runnable {
        private final RequestContext rc;
        private final CountDownLatch countDown;
        private final String isv;
        private final List<Map<String, String>> appList;
        private final Map<String, List<Map<String, String>>> extAppMap;
        private final ConcurrentHashMap<String, List<Statistics>> statisticsData;
        private final AssetSyncState state;

        Worker(RequestContext rc, CountDownLatch countDown, String isv, List<Map<String, String>> appList, Map<String, List<Map<String, String>>> extAppMap, ConcurrentHashMap<String, List<Statistics>> statisticsData, AssetSyncState state) {
            this.countDown = countDown;
            this.isv = isv;
            this.appList = appList;
            this.extAppMap = extAppMap;
            this.statisticsData = statisticsData;
            this.rc = rc;
            this.state = state;
        }

        private Set<String> getExtIds(String masterId) {
            List<Map<String, String>> list = this.extAppMap.get(masterId);
            if (list != null && !list.isEmpty()) {
                return list.stream().map(x -> (String)x.get("id")).collect(Collectors.toSet());
            }
            return new HashSet<String>();
        }

        @Override
        public void run() {
            try {
                RequestContext.copyAndSet((RequestContext)this.rc);
                for (Map<String, String> app : this.appList) {
                    String appId = app.get("id");
                    String cloudId = app.get("cloudId");
                    Set<String> extAppIds = this.getExtIds(appId);
                    AssetSyncContext context = new AssetSyncContext(this.isv, cloudId, appId, extAppIds);
                    ArrayList<Statistics> statisticsList = new ArrayList<Statistics>();
                    statisticsList.add(ModelAssetsSyncServiceImpl.this.getModelStatistics(context));
                    statisticsList.add(ModelAssetsSyncServiceImpl.this.getElementStatistics(context));
                    statisticsList.addAll(ModelAssetsSyncServiceImpl.this.getAppElementAndRuleStatistics(context));
                    statisticsList.add(ModelAssetsSyncServiceImpl.this.getPropertyStatistics(context));
                    statisticsList.add(ModelAssetsSyncServiceImpl.this.getOperatorStatistics(context));
                    statisticsList.add(ModelAssetsSyncServiceImpl.this.getValidatorStatistics(context));
                    statisticsList.add(ModelAssetsSyncServiceImpl.this.getOperatorServiceStatistics(context));
                    statisticsList.add(ModelAssetsSyncServiceImpl.this.getRuleCount(context));
                    statisticsList.addAll(ModelAssetsSyncServiceImpl.this.devportalSync.exceute(context));
                    statisticsList.addAll(ModelAssetsSyncServiceImpl.this.getBizEntityTempStatistics(context));
                    statisticsList.add(ModelAssetsSyncServiceImpl.this.getSysEntityTempStatistics(context));
                    statisticsList.add(ModelAssetsSyncServiceImpl.this.getWorkflowTempStatistics(context));
                    statisticsList.add(ModelAssetsSyncServiceImpl.this.getWorkflowNodeTempStatistics(context));
                    statisticsList.add(ModelAssetsSyncServiceImpl.this.getSysPrintTempStatistics(context));
                    statisticsList.addAll(ModelAssetsSyncServiceImpl.this.getPluginAndRuleStatistics(context));
                    statisticsList.addAll(ModelAssetsSyncServiceImpl.this.getOperationStatistics(context));
                    this.statisticsData.put(appId, statisticsList);
                    this.state.setProgress();
                    ModelAssetsSyncServiceImpl.this.feedbackProgress(this.state.getProgress());
                }
                this.countDown.countDown();
            }
            catch (Exception ex) {
                log.error(String.format("ModelAssetsSyncServiceImpl - %s:\u6267\u884c\u540c\u6b65\u4efb\u52a1\u5f02\u5e38", this.state.getTaskId()), (Throwable)ex);
            }
        }
    }
}

