/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.modelasset.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.modelasset.dao.repository.EntityDao;
import kd.bos.modelasset.service.OperationService;

public class OperationServiceImpl
implements OperationService {
    private EntityDao entityDao = new EntityDao();
    private static Log logger = LogFactory.getLog(OperationServiceImpl.class);

    public Map<String, Long> getCountByAppId(String isv, String cloudId, String appId) {
        List entitList = null;
        try {
            entitList = this.entityDao.getEntityListByAppId(isv, cloudId, appId);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5e94\u7528\u64cd\u4f5c\u3001\u6821\u9a8c\u3001\u670d\u52a1\u7edf\u8ba1\u5f02\u5e38", (Throwable)e);
        }
        return this.getCountByAppId(entitList);
    }

    public Map<String, Long> getCountByAppId(List<Map<String, Object>> entitList) {
        long operationCount = 0L;
        long validatorCount = 0L;
        long pluginCount = 0L;
        HashMap<String, Long> countMap = new HashMap<String, Long>(3);
        if (entitList != null && !entitList.isEmpty()) {
            for (Map<String, Object> map : entitList) {
                String number = map.get("fnumber").toString();
                try {
                    List operations = EntityMetadataCache.getDataEntityOperate((String)number);
                    if (operations == null) continue;
                    operationCount += (long)operations.size();
                    for (Map op : operations) {
                        ArrayList validators = (ArrayList)op.get("validators");
                        ArrayList plugins = (ArrayList)op.get("plugins");
                        if (validators != null) {
                            validatorCount += (long)validators.size();
                        }
                        if (plugins == null) continue;
                        pluginCount += (long)plugins.size();
                    }
                }
                catch (Exception e) {
                    logger.error(String.format("OperationServiceImpl\uff1a\u83b7\u53d6\u7f16\u7801\u4e3a\uff1a%s\u7684\u8868\u5355\u8fd0\u884c\u65f6\u5143\u6570\u636e \u5931\u8d25", number), (Throwable)e);
                }
            }
        }
        countMap.put("operation", operationCount);
        countMap.put("validator", validatorCount);
        countMap.put("plugin", pluginCount);
        return countMap;
    }
}

