/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.modelasset.dao.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.modelasset.dao.enums.PageType;

public class DevportalModelTypes {
    private static Map<String, List<String>> modelTypes = new HashMap<String, List<String>>(4);
    private static List<String> commonTypes = new ArrayList<String>(2);

    public static List<String> getModelTypesByType(String type) {
        return DevportalModelTypes.getModelTypesByType(type, true);
    }

    public static List<String> getModelTypesByType(String type, boolean includCommon) {
        ArrayList<String> mTypes = new ArrayList<String>(10);
        if (StringUtils.isBlank((CharSequence)type)) {
            return mTypes;
        }
        List<String> types = modelTypes.get(type);
        if (types == null) {
            return mTypes;
        }
        mTypes.addAll(types);
        if (!includCommon && PageType.Page.getValue().equals(type)) {
            List<String> commons = modelTypes.get(PageType.Common.getValue());
            mTypes.removeAll(commons);
        }
        return mTypes;
    }

    public static boolean isPageTypeMatch(String pageType, String modelType, String formId, String entityId) {
        List<String> enableModelTypes = modelTypes.get(pageType);
        return DevportalModelTypes.isPageTypeMatch(pageType, enableModelTypes, modelType, formId, entityId);
    }

    public static boolean isPageTypeMatch(String pageType, List<String> enableModelTypes, String modelType, String formId, String entityId) {
        if (enableModelTypes == null || !enableModelTypes.contains(modelType)) {
            return Boolean.FALSE;
        }
        if (PageType.EntityObject.getValue().equals(pageType) && commonTypes.contains(modelType) && !formId.equals(entityId)) {
            return Boolean.FALSE;
        }
        if (PageType.Page.getValue().equals(pageType) && commonTypes.contains(modelType)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    static {
        ArrayList<String> objectTypes = new ArrayList<String>(6);
        objectTypes.add("BillFormModel");
        objectTypes.add("BaseFormModel");
        objectTypes.add("LogBillFormModel");
        modelTypes.put(PageType.EntityObject.getValue(), objectTypes);
        ArrayList<String> pageTypes = new ArrayList<String>(14);
        pageTypes.add("BillFormModel");
        pageTypes.add("BaseFormModel");
        pageTypes.add("UserGuideFormModel");
        pageTypes.add("CardModel");
        pageTypes.add("DynamicFormModel");
        pageTypes.add("BillListCardViewModel");
        pageTypes.add("CarEntryMenuModel");
        pageTypes.add("EarlyWarnModel");
        pageTypes.add("WarnScheduleModel");
        pageTypes.add("WidgetFormModel");
        pageTypes.add("MobileFormModel");
        pageTypes.add("MobileListModel");
        pageTypes.add("MobUserGuideFormModel");
        modelTypes.put(PageType.Page.getValue(), pageTypes);
        ArrayList<String> reportTypes = new ArrayList<String>(2);
        reportTypes.add("ReportFormModel");
        modelTypes.put(PageType.Report.getValue(), reportTypes);
        ArrayList<String> parameterTypes = new ArrayList<String>(4);
        parameterTypes.add("ParameterFormModel");
        parameterTypes.add("ParameterFormModel_public");
        parameterTypes.add("ParameterFormModel_application");
        parameterTypes.add("ParameterFormModel_bill");
        parameterTypes.add("ParameterFormModel_billtype");
        parameterTypes.add("ParameterFormModel_cloud");
        parameterTypes.add("ParameterFormModel_listoption");
        parameterTypes.add("ParameterFormModel_orgoption");
        parameterTypes.add("ParameterFormModel_option");
        modelTypes.put(PageType.Parameter.getValue(), parameterTypes);
        commonTypes.add("BillFormModel");
        commonTypes.add("BaseFormModel");
        modelTypes.put(PageType.Common.getValue(), commonTypes);
        ArrayList<String> layoutTypes = new ArrayList<String>(3);
        layoutTypes.add("BillFormModel");
        layoutTypes.add("BaseFormModel");
        layoutTypes.add("MobileBillFormModel");
        modelTypes.put(PageType.LayOut.getValue(), layoutTypes);
        ArrayList<String> mobileTypes = new ArrayList<String>();
        mobileTypes.add("MobileFormModel");
        mobileTypes.add("MobileBillFormModel");
        mobileTypes.add("MobUserGuideFormModel");
        mobileTypes.add("MobileListModel");
        modelTypes.put(PageType.Mobile.getValue(), mobileTypes);
    }
}

