/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.modelasset.dao.repository;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.SqlParameter;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.util.StringUtils;

public class BizAppDao {
    public List<Map<String, String>> getAppByIsv(String isv, boolean includeExt) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(" select a.fid,b.fname,a.fnumber,a.fbizcloudid,a.ftype,a.fmasterid from t_meta_bizapp a,t_meta_bizapp_l b ", new Object[0]).append(" where ", new Object[0]).append(" a.fid=b.fid and b.flocaleid='zh_CN' ", new Object[0]);
        if (StringUtils.isNotEmpty((String)isv)) {
            sqlBuilder.append(" and a.fisv =?", new Object[]{new SqlParameter(":fisv ", 1, (Object)isv)});
        }
        if (!includeExt) {
            sqlBuilder.append(" and a.ftype!='2' ", new Object[0]);
        }
        sqlBuilder.append(" order by a.fseq asc", new Object[0]);
        return (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlBuilder, rs -> {
            ArrayList appList = new ArrayList();
            try {
                while (rs.next()) {
                    HashMap<String, String> app = new HashMap<String, String>();
                    app.put("id", rs.getString("fid"));
                    app.put("name", rs.getString("fname"));
                    app.put("number", rs.getString("fnumber"));
                    app.put("cloudId", rs.getString("fbizcloudid"));
                    app.put("type", rs.getString("ftype"));
                    app.put("masterId", rs.getString("fmasterid"));
                    appList.add(app);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("error:%s", e.getMessage())});
            }
            return appList;
        });
    }

    public List<Map<String, String>> getAppByCloudId(String cloudId, boolean includeExt) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname,a.fnumber,a.ftype,a.fbizcloudid,a.fmasterid from t_meta_bizapp a,t_meta_bizapp_l b", new Object[0]).append(" where a.fbizcloudid=?", new Object[]{new SqlParameter(":fbizcloudid", 1, (Object)cloudId)}).append(" and a.fid=b.fid and b.flocaleid='zh_CN' ", new Object[0]);
        if (!includeExt) {
            sqlBuilder.append(" and a.ftype!='2' ", new Object[0]);
        }
        sqlBuilder.append(" order by a.fseq asc", new Object[0]);
        Map<String, String> runtimeMap = this.getRuntimeName();
        return (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlBuilder, rs -> {
            ArrayList appList = new ArrayList();
            try {
                while (rs.next()) {
                    HashMap<String, String> app = new HashMap<String, String>();
                    String number = rs.getString("fnumber");
                    String name = (String)runtimeMap.get(number);
                    name = StringUtils.isNotEmpty((String)name) ? name : rs.getString("fname");
                    app.put("id", rs.getString("fid"));
                    app.put("name", name);
                    app.put("number", number);
                    app.put("cloudId", rs.getString("fbizcloudid"));
                    app.put("type", rs.getString("ftype"));
                    app.put("masterId", rs.getString("fmasterid"));
                    appList.add(app);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("error:%s", e.getMessage())});
            }
            return appList;
        });
    }

    private Map<String, String> getRuntimeName() {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fappid , fname from t_meta_appruntime_l where flocaleid = 'zh_CN'", new Object[0]);
        return (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlBuilder, rs -> {
            HashMap<String, String> map = new HashMap<String, String>(16);
            while (rs.next()) {
                String appId = rs.getString("fappid");
                String name = rs.getString("fname");
                map.put(appId, name);
            }
            return map;
        });
    }

    public List<Map<String, String>> getAppByMasterId(String masterId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fname,a.fnumber,a.ftype,a.fbizcloudid,a.fmasterid from t_meta_bizapp a,t_meta_bizapp_l b", new Object[0]).append(" where (a.fmasterid=? ", new Object[]{new SqlParameter(":fmasterid", 1, (Object)masterId)}).append(" or a.fid=?) ", new Object[]{new SqlParameter(":fid", 1, (Object)masterId)}).append(" and a.fid=b.fid and b.flocaleid='zh_CN' ", new Object[0]).append(" order by a.fseq asc", new Object[0]);
        return (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlBuilder, rs -> {
            ArrayList appList = new ArrayList();
            try {
                while (rs.next()) {
                    HashMap<String, String> app = new HashMap<String, String>();
                    app.put("id", rs.getString("fid"));
                    app.put("name", rs.getString("fname"));
                    app.put("number", rs.getString("fnumber"));
                    app.put("cloudId", rs.getString("fbizcloudid"));
                    app.put("type", rs.getString("ftype"));
                    app.put("masterId", rs.getString("fmasterid"));
                    appList.add(app);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("error:%s", e.getMessage())});
            }
            return appList;
        });
    }

    public Set<String> getAppIdByMasterId(String masterId) {
        List<Map<String, String>> appList = this.getAppByMasterId(masterId);
        return appList.stream().map(x -> (String)x.get("id")).collect(Collectors.toSet());
    }
}

