/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.modelasset.dao.repository;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.modelasset.dao.entity.Statistics;
import kd.bos.modelasset.dao.enums.AssetGroup;
import kd.bos.modelasset.dao.enums.AssetType;
import kd.bos.modelasset.dao.enums.DevportalModelTypes;
import kd.bos.modelasset.dao.enums.PageType;
import kd.bos.modelasset.dao.repository.BizAppDao;
import kd.bos.modelasset.dao.repository.PrintModelDao;
import kd.bos.modelasset.dao.repository.WorkFlowDao;
import kd.bos.modelasset.dao.util.StatisticsUtil;
import kd.bos.orm.query.QFilter;

public class DevportalDao {
    private static final String EntityId_Form = "bos_formmeta";
    PrintModelDao printDao = new PrintModelDao();
    BizAppDao bizAppDao = new BizAppDao();
    WorkFlowDao workflowDao = new WorkFlowDao();

    public List<Statistics> countByBizApp(String bizappId) {
        ArrayList<Statistics> statisticsList = new ArrayList<Statistics>(10);
        Set<String> appIds = this.bizAppDao.getAppIdByMasterId(bizappId);
        QFilter[] qFilters = new QFilter[]{new QFilter("bizappid", "in", (Object)appIds.toArray(new String[appIds.size()])), new QFilter("masterid", "in", (Object)new String[]{"", " "})};
        Map formMap = BusinessDataReader.loadFromCache((String)EntityId_Form, (QFilter[])qFilters);
        if (formMap == null || formMap.isEmpty()) {
            return statisticsList;
        }
        int objectCount = 0;
        int pageCount = 0;
        int reportCount = 0;
        int paramCount = 0;
        int layoutCount = 0;
        int printCount = 0;
        int workflowCount = 0;
        int pcCount = 0;
        int mobileCount = 0;
        for (Map.Entry entry : formMap.entrySet()) {
            String entityId;
            DynamicObject form = (DynamicObject)entry.getValue();
            String modelType = form.getString("modeltype");
            String formId = form.getString("id");
            String string = entityId = form.getDynamicObject("basedatafield") == null ? "" : form.getDynamicObject("basedatafield").getString("id");
            if (DevportalModelTypes.isPageTypeMatch(PageType.EntityObject.getValue(), modelType, formId, entityId)) {
                ++objectCount;
            }
            if (DevportalModelTypes.isPageTypeMatch(PageType.Page.getValue(), modelType, formId, entityId)) {
                ++pageCount;
            }
            if (DevportalModelTypes.isPageTypeMatch(PageType.Report.getValue(), modelType, formId, entityId)) {
                ++reportCount;
            }
            if (DevportalModelTypes.isPageTypeMatch(PageType.LayOut.getValue(), modelType, formId, entityId)) {
                ++layoutCount;
            }
            if (DevportalModelTypes.isPageTypeMatch(PageType.Parameter.getValue(), modelType, formId, entityId)) {
                ++paramCount;
            }
            if (DevportalModelTypes.isPageTypeMatch(PageType.Mobile.getValue(), modelType, formId, entityId)) {
                ++mobileCount;
            } else {
                ++pcCount;
            }
            if (!"PrintModel".equals(modelType)) continue;
            ++printCount;
        }
        statisticsList.add(StatisticsUtil.toEntity(AssetGroup.App.getValue(), AssetType.Entity.getValue(), bizappId, objectCount));
        statisticsList.add(StatisticsUtil.toEntity(AssetGroup.App.getValue(), AssetType.Page.getValue(), bizappId, pageCount));
        statisticsList.add(StatisticsUtil.toEntity(AssetGroup.App.getValue(), AssetType.Layout.getValue(), bizappId, layoutCount));
        statisticsList.add(StatisticsUtil.toEntity(AssetGroup.App.getValue(), AssetType.Report.getValue(), bizappId, reportCount));
        statisticsList.add(StatisticsUtil.toEntity(AssetGroup.App.getValue(), AssetType.Parameter.getValue(), bizappId, paramCount));
        statisticsList.add(StatisticsUtil.toEntity(AssetGroup.App.getValue(), AssetType.Mobile.getValue(), bizappId, mobileCount));
        statisticsList.add(StatisticsUtil.toEntity(AssetGroup.App.getValue(), AssetType.Pc.getValue(), bizappId, pcCount));
        printCount = this.printDao.getNewPrintCount(bizappId);
        statisticsList.add(StatisticsUtil.toEntity(AssetGroup.App.getValue(), AssetType.Print.getValue(), bizappId, printCount));
        workflowCount = this.workflowDao.getWfModelCount(bizappId);
        statisticsList.add(StatisticsUtil.toEntity(AssetGroup.App.getValue(), AssetType.Workflow.getValue(), bizappId, workflowCount));
        return statisticsList;
    }
}

