/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.modelasset.dao.repository;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.modelasset.dao.entity.Statistics;
import kd.bos.modelasset.dao.util.StatisticsUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.ISVServiceHelper;

public class StatisticsDao {
    private static Log log = LogFactory.getLog(StatisticsDao.class);
    private static final String ENTITY_ID = "statistics";

    public List<Statistics> getList(String bizAppId) {
        SqlBuilder entityBuilder = new SqlBuilder();
        entityBuilder.append("select fid,fnumber,fname,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,fassettype,fassetgroup,fisv,fbizappid,fcount,fversion from t_mast_statistics", new Object[0]).append(" where fbizappid=?", new Object[]{new SqlParameter(":fbizappid", 12, (Object)bizAppId)});
        return (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)entityBuilder, rs -> {
            ArrayList<Statistics> list = new ArrayList<Statistics>();
            while (rs.next()) {
                Statistics statistics = StatisticsUtil.toEntity(rs);
                if (statistics == null) continue;
                list.add(statistics);
            }
            return list;
        });
    }

    public static void batchSave(String bizappId, List<Statistics> statisticsList) {
        if (statisticsList == null || statisticsList.isEmpty()) {
            return;
        }
        try {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)ENTITY_ID);
            ArrayList<DynamicObject> objList = new ArrayList<DynamicObject>(statisticsList.size());
            String isv = ISVServiceHelper.getISVInfo().getId();
            long userId = RequestContext.get().getCurrUserId();
            Date date = new Date();
            long[] ids = DB.genGlobalLongIds((int)statisticsList.size());
            int i = 0;
            for (Statistics statistics : statisticsList) {
                DynamicObject obj = new DynamicObject((DynamicObjectType)dt);
                long id = ids[i];
                obj.set("id", (Object)id);
                obj.set("isv", (Object)isv);
                obj.set("bizappid", (Object)bizappId);
                obj.set("number", (Object)String.valueOf(id));
                obj.set("name", (Object)String.valueOf(id));
                obj.set("creator", (Object)userId);
                obj.set("modifier", (Object)userId);
                obj.set("enable", (Object)1);
                obj.set("createtime", (Object)date);
                obj.set("modifytime", (Object)date);
                obj.set("masterid", (Object)id);
                obj.set("status", (Object)Character.valueOf('A'));
                obj.set("count", (Object)statistics.getCount());
                obj.set("assetgroup", (Object)statistics.getAssetGroup());
                obj.set("assettype", (Object)statistics.getAssetType());
                objList.add(obj);
                ++i;
            }
            try (TXHandle h = TX.requiresNew((String)"batchSaveStatistics");){
                StatisticsDao.delete(bizappId);
                BusinessDataWriter.save((IDataEntityType)dt, (Object[])objList.toArray(new Object[objList.size()]));
            }
        }
        catch (Exception e) {
            log.error(String.format("\u6279\u91cf\u4fdd\u5b58\u5e94\u7528\u7edf\u8ba1\u6570\u636e\u9519\u8bef\uff0c\u5e94\u7528\uff1a%s\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s", bizappId, e.getMessage(), e));
        }
    }

    public static void batchSave(DynamicObjectCollection collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)ENTITY_ID);
        ArrayList<DynamicObject> objList = new ArrayList<DynamicObject>(collection.size());
        String isv = ISVServiceHelper.getISVInfo().getId();
        long userId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        for (DynamicObject statistics : collection) {
            String name = statistics.getLocaleString("name") == null ? "" : statistics.getLocaleString("name").getLocaleValue();
            DynamicObject obj = new DynamicObject((DynamicObjectType)dt);
            obj.set("id", (Object)statistics.getString("id"));
            obj.set("isv", (Object)isv);
            obj.set("bizappid", (Object)statistics.getString("bizappid"));
            obj.set("number", (Object)statistics.getString("number"));
            obj.set("name", (Object)name);
            obj.set("creator", (Object)userId);
            obj.set("modifier", (Object)userId);
            obj.set("enable", (Object)1);
            obj.set("createtime", (Object)date);
            obj.set("modifytime", (Object)date);
            obj.set("masterid", (Object)statistics.getString("id"));
            obj.set("count", (Object)statistics.getLong("count"));
            obj.set("assetgroup", (Object)statistics.getLong("assetgroup"));
            obj.set("assettype", (Object)statistics.getLong("assettype"));
            objList.add(obj);
        }
        BusinessDataWriter.save((IDataEntityType)dt, (Object[])objList.toArray(new Object[objList.size()]));
    }

    public static void delete(String bizappId) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)ENTITY_ID);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)ENTITY_ID, (String)"id", (QFilter[])new QFilter[]{new QFilter("bizappid", "=", (Object)bizappId)});
        if (objs == null || objs.length == 0) {
            return;
        }
        HashSet<Object> pks = new HashSet<Object>(10);
        for (DynamicObject obj : objs) {
            pks.add(obj.get("id"));
        }
        BusinessDataWriter.delete((IDataEntityType)dt, (Object[])pks.toArray(new Object[pks.size()]));
    }

    private static String getKey(String bizappId, long assetGroup, long assetType) {
        return String.format("%s_%s_%s", bizappId, assetGroup, assetType);
    }
}

