/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.modelasset.dao.repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.modelasset.dao.repository.BizAppDao;

public class TemplateDao {
    private BizAppDao bizAppDao = new BizAppDao();

    public long getEntityTempCount(String isv, String appId, String modelType) {
        if (StringUtils.isBlank((CharSequence)isv)) {
            return 0L;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(" select count(1) as count from t_meta_entitydesign a,t_meta_entitydesign_l b,t_meta_formdesign c ", new Object[0]).append(" where a.fnumber=b.fnumber and b.flocaleid='zh_CN' and a.fnumber = c.fnumber and a.fisv=? ", new Object[]{isv}).append(" and a.fistemplate='1' ", new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            sqlBuilder.append(" and a.fbizappid=? ", new Object[]{appId});
        }
        if (StringUtils.isNotBlank((CharSequence)modelType)) {
            sqlBuilder.append(" and a.fmodeltype like ? ", new Object[]{new SqlParameter(":fmdoeltype", 12, (Object)(modelType + "%"))});
        }
        return (Long)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws Exception {
                long count = 0L;
                try {
                    while (rs.next()) {
                        count = rs.getLong("count");
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("error:%s", e.getMessage())});
                }
                return count;
            }
        });
    }

    public List<Map<String, Object>> getSysEntityTempList() {
        Set<String> appIdList = this.bizAppDao.getAppIdByMasterId("0a1f79d7000024ac");
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(" select a.fid,a.fnumber,a.fmodeltype,b.fname", new Object[0]).append(" from t_meta_entitydesign a ", new Object[0]).append(" inner join t_meta_entitydesign_l b on a.fnumber=b.fnumber and b.flocaleid='zh_CN' ", new Object[0]).append(" and a.fistemplate='1' ", new Object[0]).append(" and a.ftype!='2' ", new Object[0]).append(" and ", new Object[0]).appendIn("a.fbizappid", appIdList.toArray()).append(" and a.fnumber not in('',' ','bos_flextpl') ", new Object[0]).append(" order by a.fnumber asc", new Object[0]);
        return (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlBuilder, rs -> {
            ArrayList arr = new ArrayList();
            try {
                while (rs.next()) {
                    HashMap<String, String> template = new HashMap<String, String>(4);
                    template.put("fid", rs.getString(1));
                    template.put("fnumber", rs.getString(2));
                    template.put("fmodeltype", rs.getString(3));
                    template.put("fname", rs.getString(4));
                    arr.add(template);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("error:%s", e.getMessage())});
            }
            return arr;
        });
    }

    public List<Map<String, Object>> getBizEntityTempList(String isv, String cloudId, String appId) {
        List<Map<String, String>> appList;
        Set ids;
        HashSet<Object> appIdList = new HashSet<Object>(16);
        if (StringUtils.isNotBlank((CharSequence)cloudId) && !(ids = (appList = this.bizAppDao.getAppByCloudId(cloudId, true)).stream().map(map -> (String)map.get("id")).collect(Collectors.toSet())).isEmpty()) {
            appIdList.addAll(ids);
        }
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            appIdList.add(appId);
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(" select a.fid,a.fnumber,a.fmodeltype,b.fname,a.fbizappid", new Object[0]).append(" from t_meta_entitydesign a,t_meta_entitydesign_l b,t_meta_formdesign c ", new Object[0]).append(" where a.fnumber=b.fnumber and b.flocaleid='zh_CN' and a.fnumber=c.fnumber ", new Object[0]).append(" and a.fistemplate='1' ", new Object[0]).append(" and a.ftype!='2' ", new Object[0]).append(" and c.fisinherit!='0' ", new Object[0]);
        if (!appIdList.isEmpty()) {
            sqlBuilder.append(" and ", new Object[0]).appendIn("a.fbizappid", appIdList.toArray());
        }
        sqlBuilder.append(" order by a.fnumber asc", new Object[0]);
        return (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlBuilder, rs -> {
            ArrayList arr = new ArrayList();
            try {
                while (rs.next()) {
                    HashMap<String, String> template = new HashMap<String, String>(5);
                    template.put("id", rs.getString(1));
                    template.put("number", rs.getString(2));
                    template.put("modelType", rs.getString(3));
                    template.put("name", rs.getString(4));
                    template.put("appId", rs.getString(5));
                    arr.add(template);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("error:%s", e.getMessage())});
            }
            return arr;
        });
    }

    public long getWorkflowNodeTempCount(String cloudId, String appId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select count(1) count from t_wf_nodetemplate", new Object[0]);
        return (Long)DB.query((DBRoute)DBRoute.workflow, (SqlBuilder)sqlBuilder, rs -> {
            long count = 0L;
            try {
                while (rs.next()) {
                    count = rs.getLong(1);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("error:%s", e.getMessage())});
            }
            return count;
        });
    }

    public long getSysPrintTempCount() {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select count(1) count from t_svc_printtpl", new Object[0]);
        return (Long)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder, rs -> {
            long count = 0L;
            try {
                while (rs.next()) {
                    count = rs.getLong(1);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("error:%s", e.getMessage())});
            }
            return count;
        });
    }

    public long getBizPrintTempCount(String appId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select count(1) from t_svc_printmeta where fbizappid=?", new Object[]{new SqlParameter(":fbizappid", 12, (Object)appId)});
        return (Long)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder, rs -> {
            long count = 0L;
            try {
                while (rs.next()) {
                    count = rs.getLong(1);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("error:%s", e.getMessage())});
            }
            return count;
        });
    }
}

