/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.modelasset.dao.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.modelasset.dao.entity.Statistics;
import kd.bos.servicehelper.ISVServiceHelper;

public class StatisticsUtil {
    private static final String ENTITY_ID = "statistics";

    public static Statistics toEntity(ResultSet rs) throws SQLException {
        if (rs == null || rs.isClosed()) {
            return null;
        }
        Statistics statistics = new Statistics();
        statistics.setId(rs.getLong("fid"));
        statistics.setNumber(rs.getString("fnumber"));
        statistics.setName(rs.getString("fname"));
        statistics.setStatus(rs.getString("fstatus"));
        statistics.setCreatorId(rs.getLong("fcreatorid"));
        statistics.setModifierId(rs.getLong("fmodifierid"));
        statistics.setEnable(rs.getString("fenable"));
        statistics.setCreateTime((Date)rs.getTimestamp("fcreatetime"));
        statistics.setModifyTime((Date)rs.getTimestamp("fmodifytime"));
        statistics.setMasterId(rs.getLong("fmasterid"));
        statistics.setAssetType(rs.getLong("fassettype"));
        statistics.setAssetGroup(rs.getLong("fassetgroup"));
        statistics.setIsv(rs.getString("fisv"));
        statistics.setBizAppId(rs.getString("fbizappid"));
        statistics.setCount(rs.getLong("fcount"));
        statistics.setVersion(rs.getString("fversion"));
        return statistics;
    }

    public static Statistics toEntity(long assetGroup, long assetType, String bizappId, long count) {
        Statistics statistics = new Statistics();
        long userId = RequestContext.get().getCurrUserId();
        Date curDate = new Date();
        String isv = ISVServiceHelper.getISVInfo().getId();
        statistics.setAssetType(assetType);
        statistics.setAssetGroup(assetGroup);
        statistics.setIsv(isv);
        statistics.setBizAppId(bizappId);
        statistics.setCount(count);
        statistics.setStatus("A");
        statistics.setCreatorId(userId);
        statistics.setModifierId(userId);
        statistics.setEnable("1");
        statistics.setCreateTime(curDate);
        statistics.setModifyTime(curDate);
        return statistics;
    }

    public static DynamicObject toDynamicObject(long assetGroup, long assetType, String bizappId, long count, String isv) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)ENTITY_ID);
        DynamicObject object = new DynamicObject((DynamicObjectType)dt);
        long id = DB.genGlobalLongId();
        object.set("isv", (Object)isv);
        object.set("count", (Object)count);
        object.set("assetgroup", (Object)assetGroup);
        object.set("assettype", (Object)assetType);
        object.set("id", (Object)id);
        object.set("bizappid", (Object)bizappId);
        object.set("number", (Object)String.valueOf(id));
        object.set("name", (Object)String.valueOf(id));
        return object;
    }
}

