/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.modelasset.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.modelasset.service.AppService;
import kd.bos.modelasset.service.CloudService;
import kd.bos.modelasset.service.StatisticsService;
import kd.bos.modelasset.service.context.AssetSyncState;
import kd.bos.modelasset.service.impl.AppServiceImpl;
import kd.bos.modelasset.service.impl.CloudServiceImpl;
import kd.bos.modelasset.service.impl.StatisticsServiceImpl;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;

public class ModelAssetPortalPlugin
extends AbstractFormPlugin {
    private static final String ModelAssetAp = "bizstatisticsap";
    private static final String KEY_ITEM_LISTCLOUD = "listcloud";
    private static final String KEY_ITEM_LISTAPP = "listapp";
    private static final String KEY_ITEM_LISTSTATISTICS = "liststatistics";
    private static final String KEY_ITEM_REFRESHSTATIS = "refreshstatistics";
    private static final String KEY_ITEM_ONSTATISPROCESS = "getrefreshstatisticsprocess";
    private static final String KEY_PARAM_BIZCLOUDID = "bizcloudid";
    private static final String KEY_PARAM_BIZAPPID = "bizappid";
    private static final String KEY_RESET = "reset";
    private static final String KEY_Method = "method";
    private static final String BOS_MODELASSET_PLUGIN = "bos-modelasset-plugin";
    private static final CloudService cloudService = new CloudServiceImpl();
    private static final AppService appService = new AppServiceImpl();
    private static final StatisticsService statisticsService = new StatisticsServiceImpl();

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_RESET});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getOperationKey();
        Map args = evt.getItemKey() == null ? null : (Map)SerializationUtils.fromJsonString((String)evt.getItemKey(), Map.class);
        switch (key) {
            case "listcloud": {
                this.getCloudList();
                break;
            }
            case "listapp": {
                this.getAppByCloudId(args);
                break;
            }
            case "liststatistics": {
                this.getAppStatistics(args);
                break;
            }
            case "refreshstatistics": {
                this.refreshAppStatistics();
                break;
            }
            case "getrefreshstatisticsprocess": {
                this.getAppStatisticsRefreshProcess(args);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "reset": {
                AssetSyncState state = new AssetSyncState();
                state.reset();
                break;
            }
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String args = e.getEventArgs();
        Map param = StringUtils.isBlank((CharSequence)args) ? null : (Map)SerializationUtils.fromJsonString((String)args, Map.class);
        switch (eventName) {
            case "listcloud": {
                this.getCloudList();
                break;
            }
            case "listapp": {
                this.getAppByCloudId(param);
                break;
            }
            case "liststatistics": {
                this.getAppStatistics(param);
                break;
            }
            case "refreshstatistics": {
                this.refreshAppStatistics();
                break;
            }
            case "getrefreshstatisticsprocess": {
                this.getAppStatisticsRefreshProcess(param);
                break;
            }
        }
    }

    public void getCloudList() {
        JSONObject cloudData = new JSONObject();
        JSONArray bizCloudItemArray = cloudService.getCloudList();
        cloudData.put("clouds", (Object)bizCloudItemArray);
        cloudData.put("defaultcloudid", (Object)cloudService.getDefaultCloudId(bizCloudItemArray));
        cloudData.put(KEY_Method, (Object)KEY_ITEM_LISTCLOUD);
        this.response(cloudData);
    }

    public void getAppByCloudId(Map<String, Object> args) {
        String cloudId = (String)args.get(KEY_PARAM_BIZCLOUDID);
        HashMap<String, Object> appData = new HashMap<String, Object>();
        JSONArray appList = appService.getAppListByCloudId(cloudId);
        appData.put("apps", appList);
        appData.put("defaultappid", appService.getDefaultAppId(appList));
        appData.put(KEY_Method, KEY_ITEM_LISTAPP);
        this.response(appData);
    }

    public void getAppStatistics(Map<String, Object> args) {
        String bizappId = (String)args.get(KEY_PARAM_BIZAPPID);
        Map statistics = statisticsService.getStatisticsList(bizappId);
        statistics.put(KEY_Method, KEY_ITEM_LISTSTATISTICS);
        this.response(statistics);
    }

    public void refreshAppStatistics() {
        TaskInfo taskInfo;
        AssetSyncState state = new AssetSyncState();
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put(KEY_Method, KEY_ITEM_REFRESHSTATIS);
        if (StringUtils.isNotBlank((CharSequence)state.getTaskId()) && (taskInfo = ScheduleServiceHelper.queryTask((String)state.getTaskId())) != null && !taskInfo.isTaskEnd()) {
            map.put("taskId", state.getTaskId());
            this.response(map);
            return;
        }
        JobInfo job = new JobInfo();
        job.setTaskId(String.valueOf(DB.genLongId((String)"T_SCH_JOB")));
        job.setRunByUserId(RequestContext.get().getCurrUserId());
        job.setAppId("bos");
        job.setJobType(JobType.REALTIME);
        job.setName(ResManager.loadKDString((String)"\u6a21\u578b\u8d44\u4ea7\u6570\u636e\u7edf\u8ba1\u4efb\u52a1", (String)"ModelAssetPortalPlugin_0", (String)BOS_MODELASSET_PLUGIN, (Object[])new Object[0]));
        job.setTaskClassname("kd.bos.modelasset.service.impl.ModelAssetsSyncServiceImpl");
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)job);
        map.put("taskId", taskId);
        state.setTaskId(taskId);
        this.response(map);
    }

    public void getAppStatisticsRefreshProcess(Map<String, Object> args) {
        AssetSyncState state = new AssetSyncState();
        int progress = state.getProgress();
        long remainderTime = state.getRemainderTime();
        String taskId = state.getTaskId();
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put(KEY_Method, KEY_ITEM_ONSTATISPROCESS);
        if (StringUtils.isBlank((CharSequence)taskId)) {
            this.response(map);
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (taskInfo != null && taskInfo.isTaskEnd()) {
            progress = 100;
            remainderTime = 0L;
            state.reset();
        }
        map.put("p", progress);
        map.put("t", remainderTime);
        this.response(map);
    }

    private void response(Object data) {
        CustomControl modelAssetAp = (CustomControl)this.getView().getControl(ModelAssetAp);
        modelAssetAp.setData(data);
    }
}

