/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.modelasset.plugin.index.sync;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.modelasset.service.context.AssetSyncState;
import kd.bos.modelasset.service.impl.ModelAssetsSyncServiceImpl;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;

public class ModelAssetsSyncPlugin
extends AbstractListPlugin {
    private static final String BOS_MODELASSET_PLUGIN = "bos-modelasset-plugin";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"bar_item"});
        this.addClickListeners(new String[]{"btn_sync", "progress"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Button)evt.getSource()).getKey()) {
            case "btn_sync": {
                this.refreshAppStatistics();
                break;
            }
            case "progress": {
                this.getAppStatisticsRefreshProcess();
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "bar_sync": {
                this.doSyncData();
                break;
            }
            case "progress": {
                this.getAppStatisticsRefreshProcess();
                break;
            }
            case "clear": {
                this.clear();
                break;
            }
        }
    }

    public void refreshAppStatistics() {
        TaskInfo taskInfo;
        AssetSyncState state = new AssetSyncState();
        if (StringUtils.isNotBlank((CharSequence)state.getTaskId()) && (taskInfo = ScheduleServiceHelper.queryTask((String)state.getTaskId())) != null && !taskInfo.isTaskEnd()) {
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("bizRefreshStatisticsTaskId", (Object)state.getTaskId());
            return;
        }
        JobInfo job = new JobInfo();
        job.setTaskId(String.valueOf(DB.genLongId((String)"T_SCH_JOB")));
        job.setRunByUserId(RequestContext.get().getCurrUserId());
        job.setAppId("bos");
        job.setJobType(JobType.REALTIME);
        job.setName(ResManager.loadKDString((String)"\u6a21\u578b\u8d44\u4ea7\u6570\u636e\u7edf\u8ba1\u4efb\u52a1", (String)"ModelAssetsSyncPlugin_0", (String)BOS_MODELASSET_PLUGIN, (Object[])new Object[0]));
        job.setTaskClassname("kd.bos.modelasset.service.impl.ModelAssetsSyncServiceImpl");
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)job);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("bizRefreshStatisticsTaskId", (Object)taskId);
    }

    public void getAppStatisticsRefreshProcess() {
        AssetSyncState state = new AssetSyncState();
        int progress = state.getProgress();
        String taskId = state.getTaskId();
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (taskInfo != null && taskInfo.isTaskEnd()) {
            progress = 100;
            state.reset();
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>(1);
        map.put("p", progress);
        this.getModel().setValue("progress1", (Object)progress);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("bizRefreshStatisticsProcess", map);
    }

    private void doSyncData() {
        TaskInfo taskInfo;
        AssetSyncState state = new AssetSyncState();
        FormShowParameter show = new FormShowParameter();
        show.setFormId("bos_modelasset_progress");
        OpenStyle style = new OpenStyle();
        style.setShowType(ShowType.Modal);
        show.setOpenStyle(style);
        show.setShowTitle(false);
        CloseCallBack cb = new CloseCallBack((IFormPlugin)this, "synccallback");
        show.setCloseCallBack(cb);
        if (StringUtils.isNotBlank((CharSequence)state.getTaskId()) && (taskInfo = ScheduleServiceHelper.queryTask((String)state.getTaskId())) != null && !taskInfo.isTaskEnd()) {
            this.getView().showForm(show);
            return;
        }
        JobInfo job = new JobInfo();
        job.setAppId("bos");
        job.setJobType(JobType.REALTIME);
        job.setTimeout(7200);
        job.setTaskClassname(ModelAssetsSyncServiceImpl.class.getName());
        HashMap<String, String> map = new HashMap<String, String>(1);
        String taskId = JobClient.dispatch((JobInfo)job);
        state.setTaskId(taskId);
        map.put("taskId", taskId);
        show.setCustomParams(map);
        this.getView().showForm(show);
    }

    public void clear() {
        AssetSyncState state = new AssetSyncState();
        state.reset();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6e05\u7406\u6210\u529f", (String)"ModelAssetsSyncPlugin_1", (String)BOS_MODELASSET_PLUGIN, (Object[])new Object[0]));
    }

    public void closedCallBack(ClosedCallBackEvent arg0) {
        Object data;
        if ("synccallback".equals(arg0.getActionId()) && StringUtils.isNotBlank((Object)(data = arg0.getReturnData()))) {
            Map returnData = (Map)SerializationUtils.fromJsonString((String)data.toString(), Map.class);
            Object msg = returnData.get("msg");
            Object msgType = returnData.get("msgType");
            if (StringUtils.isBlank((Object)data) || StringUtils.isBlank(msgType)) {
                return;
            }
            switch (msgType.toString()) {
                case "error": {
                    this.getView().showErrorNotification(msg.toString());
                    break;
                }
                case "success": {
                    this.getView().showSuccessNotification(msg.toString());
                    break;
                }
            }
        }
    }
}

