/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.modelasset.plugin.index.sync;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.modelasset.service.context.AssetSyncState;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;

public class TaskProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String BOS_MODELASSET_PLUGIN = "bos-modelasset-plugin";

    public void initialize() {
        ProgressBar progress = (ProgressBar)this.getControl("progressbarap");
        progress.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Label showContent = (Label)this.getControl("showcontent");
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        AssetSyncState state = new AssetSyncState();
        int proVal = state.getProgress();
        String taskId = state.getTaskId();
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (StringUtils.isBlank((CharSequence)taskId)) {
            progressBar.stop();
            showContent.setText(ResManager.loadKDString((String)"\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"TaskProgressPlugin_0", (String)BOS_MODELASSET_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (taskInfo != null) {
            progressBar.setPercent(proVal);
            showContent.setText(ResManager.loadKDString((String)"\u8fd0\u884c\u4e2d", (String)"TaskProgressPlugin_1", (String)BOS_MODELASSET_PLUGIN, (Object[])new Object[0]));
        }
        progressBar.start();
    }

    public void onProgress(ProgressEvent arg0) {
        Label showContent = (Label)this.getControl("showcontent");
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        AssetSyncState state = new AssetSyncState();
        int progress = state.getProgress();
        String taskId = state.getTaskId();
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (taskInfo != null && taskInfo.isTaskEnd()) {
            progress = 100;
            progressBar.stop();
            state.reset();
            HashMap<String, Object> returnData = new HashMap<String, Object>();
            if (taskInfo.isFailure()) {
                returnData.put("msgType", "error");
                returnData.put("msg", ResManager.loadKDString((String)"\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"TaskProgressPlugin_2", (String)BOS_MODELASSET_PLUGIN, (Object[])new Object[0]));
            } else {
                returnData.put("msgType", "success");
                returnData.put("msg", ResManager.loadKDString((String)"\u4efb\u52a1\u5b8c\u6210\u3002", (String)"TaskProgressPlugin_3", (String)BOS_MODELASSET_PLUGIN, (Object[])new Object[0]));
            }
            this.setReturnData(returnData);
            this.getView().close();
            return;
        }
        showContent.setText(ResManager.loadKDString((String)"\u8fd0\u884c\u4e2d", (String)"TaskProgressPlugin_1", (String)BOS_MODELASSET_PLUGIN, (Object[])new Object[0]));
        arg0.setProgress(progress);
    }

    private void setReturnData(Map<String, Object> data) {
        if (data == null) {
            this.getPageCache().put("returnvalue", SerializationUtils.toJsonString(new HashMap()));
        } else {
            this.getPageCache().put("returnvalue", SerializationUtils.toJsonString(data));
        }
    }

    private Map<String, Object> getReturnData() {
        String str = this.getPageCache().get("returnvalue");
        if (StringUtils.isBlank((CharSequence)str)) {
            return new HashMap<String, Object>();
        }
        return (Map)SerializationUtils.fromJsonString((String)str, Map.class);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        Map<String, Object> map = this.getReturnData();
        if (map.isEmpty()) {
            map.put("msgType", "error");
            map.put("msg", ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u6302\u8d77\u5728\u540e\u53f0\u6267\u884c\u4e2d\u3002", (String)"TaskProgressPlugin_4", (String)BOS_MODELASSET_PLUGIN, (Object[])new Object[0]));
        }
        this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(map));
    }

    private void init() {
        if (Boolean.parseBoolean(this.getPageCache().get("Initialized"))) {
            return;
        }
        Map cusparams = this.getView().getFormShowParameter().getCustomParams();
        Object taskId = cusparams.get("taskId");
        if (StringUtils.isBlank(taskId)) {
            Object jobInfo = cusparams.get("jobInfo");
            if (StringUtils.isBlank(jobInfo)) {
                this.getPageCache().put("taskStatus", "noexist");
                this.getPageCache().put("Initialized", "true");
                return;
            }
            JobInfo info = (JobInfo)SerializationUtils.fromJsonString((String)jobInfo.toString(), JobInfo.class);
            info.setJobType(JobType.REALTIME);
            info.setId(null);
            taskId = JobClient.dispatch((JobInfo)info);
        }
        this.getPageCache().put("taskId", taskId.toString());
        this.getPageCache().put("taskStatus", "started");
        this.getPageCache().put("Initialized", "true");
    }
}

