/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pluginquery;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.entity.BaseEntity;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class PluginQueryPagePlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final Log LOG = LogFactory.getLog(PluginQueryPagePlugin.class);
    private static final String BTN_REFRESH = "refresh";
    private static final String BTN_CLOSE = "close";
    private static final String FLEX_PANEL_INITIAL_PAGE = "initialpage";
    private static final String FLEX_PANEL_DEFAULT_PAGE = "defaultpage";
    private static final String FLEX_PANEL_RESULT_PAGE = "resultpage";
    private static final String PLUGIN_INFO_PANEL = "plugininfopanel";
    private static final String FIELD_QUERY_TYPE = "querytype";
    private static final String FIELD_QUERY_KEY = "querykey";
    private static final String ENTRY_PAGE = "pageentryentity";
    private static final String ENTRY_OPERATION = "operentryentity";
    private static final String ENTRY_OTHER = "otherentryentity";
    private static final String BOS_MODELASSET_PLUGIN = "bos-modelasset-plugin";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_REFRESH, BTN_CLOSE});
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_PAGE);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid entryGrid1 = (EntryGrid)this.getControl(ENTRY_OPERATION);
        entryGrid1.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid entryGrid2 = (EntryGrid)this.getControl(ENTRY_OTHER);
        entryGrid2.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        HashMap<String, Boolean> comboMap = new HashMap<String, Boolean>();
        comboMap.put("skipShortCutFocus", true);
        this.getView().updateControlMetadata(FIELD_QUERY_TYPE, comboMap);
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_PANEL_RESULT_PAGE, FLEX_PANEL_DEFAULT_PAGE, PLUGIN_INFO_PANEL});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String queryKey;
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (FIELD_QUERY_TYPE.equals(propertyName)) {
            this.getModel().setValue(FIELD_QUERY_KEY, (Object)"");
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_PANEL_INITIAL_PAGE});
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_PANEL_RESULT_PAGE, FLEX_PANEL_DEFAULT_PAGE, PLUGIN_INFO_PANEL});
            this.getModel().deleteEntryData(ENTRY_PAGE);
            this.getModel().deleteEntryData(ENTRY_OPERATION);
            this.getModel().deleteEntryData(ENTRY_OTHER);
        } else if (FIELD_QUERY_KEY.equals(propertyName) && StringUtils.isNotBlank((CharSequence)(queryKey = (String)e.getChangeSet()[0].getNewValue()))) {
            String queryType = (String)this.getModel().getValue(FIELD_QUERY_TYPE);
            this.queryPlugins(queryType, queryKey.trim());
        }
    }

    private void queryPlugins(String queryType, String queryKey) {
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_PANEL_INITIAL_PAGE});
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u67e5\u8be2...", (String)"PluginQueryPagePlugin_0", (String)BOS_MODELASSET_PLUGIN, (Object[])new Object[0])));
        if ("1".equals(queryType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{PLUGIN_INFO_PANEL});
            this.setEntryColumnVisible(true);
            this.renderEntry(this.byFormNumberQuery(queryKey));
        } else if ("2".equals(queryType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{PLUGIN_INFO_PANEL});
            this.setEntryColumnVisible(false);
            this.renderEntry(this.byPluginClassQuery(queryKey));
        }
        this.getView().hideLoading();
    }

    private void setEntryColumnVisible(boolean isShow) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_PAGE);
        entryGrid.setColumnProperty("pluginclass", "vi", (Object)isShow);
        entryGrid.setColumnProperty("isori", "vi", (Object)isShow);
        entryGrid.setColumnProperty("desc", "vi", (Object)isShow);
        EntryGrid entryGrid1 = (EntryGrid)this.getControl(ENTRY_OPERATION);
        entryGrid1.setColumnProperty("pluginclass1", "vi", (Object)isShow);
        entryGrid1.setColumnProperty("isori1", "vi", (Object)isShow);
        entryGrid1.setColumnProperty("desc1", "vi", (Object)isShow);
        EntryGrid entryGrid2 = (EntryGrid)this.getControl(ENTRY_OTHER);
        entryGrid2.setColumnProperty("pluginclass2", "vi", (Object)isShow);
        entryGrid2.setColumnProperty("isori2", "vi", (Object)isShow);
        entryGrid2.setColumnProperty("desc2", "vi", (Object)isShow);
    }

    private void renderEntry(Map<String, List<Map<String, Object>>> plugins) {
        int rowIndex;
        this.getModel().deleteEntryData(ENTRY_PAGE);
        this.getModel().deleteEntryData(ENTRY_OPERATION);
        this.getModel().deleteEntryData(ENTRY_OTHER);
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_PANEL_INITIAL_PAGE});
        List<Map<String, Object>> formPlugins = plugins.get("formPlugins");
        List<Map<String, Object>> opPlugins = plugins.get("opPlugins");
        List<Map<String, Object>> otherPlugins = plugins.get("otherPlugins");
        if (!(formPlugins != null && !formPlugins.isEmpty() || opPlugins != null && !opPlugins.isEmpty() || otherPlugins != null && !otherPlugins.isEmpty())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_PANEL_RESULT_PAGE, PLUGIN_INFO_PANEL});
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_PANEL_DEFAULT_PAGE});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_PANEL_DEFAULT_PAGE});
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_PANEL_RESULT_PAGE});
        }
        if (formPlugins == null || formPlugins.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"pagequote"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"pagequote"});
            for (Map<String, Object> formPlugin : formPlugins) {
                rowIndex = this.getModel().createNewEntryRow(ENTRY_PAGE);
                this.getModel().setValue("pluginclass", formPlugin.get("pluginClass"), rowIndex);
                this.getModel().setValue("status01", (Object)((Boolean)formPlugin.get("status") != false ? "enable" : "disable"), rowIndex);
                this.getModel().setValue("isori01", (Object)((Boolean)formPlugin.get("inherit") != false ? "2" : "1"), rowIndex);
                this.getModel().setValue("desc", formPlugin.get("desc"), rowIndex);
                this.getModel().setValue("formtype", formPlugin.get("pageType"), rowIndex);
                this.getModel().setValue("objectname", formPlugin.get("formId"), rowIndex);
                this.getModel().setValue("pluginclass3", formPlugin.get("pluginClass"));
                this.getModel().setValue("isori3", (Object)((Boolean)formPlugin.get("inherit") != false ? ResManager.loadKDString((String)"\u5426", (String)"PluginDetailsPagePlugin_0", (String)BOS_MODELASSET_PLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u662f", (String)"PluginDetailsPagePlugin_1", (String)BOS_MODELASSET_PLUGIN, (Object[])new Object[0])));
                this.getModel().setValue("plugintype", (Object)"1");
                this.getModel().setValue("desc3", formPlugin.get("desc"));
            }
            this.getView().updateView(ENTRY_PAGE);
        }
        if (opPlugins == null || opPlugins.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"operationquote"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"operationquote"});
            for (Map<String, Object> opPlugin : opPlugins) {
                rowIndex = this.getModel().createNewEntryRow(ENTRY_OPERATION);
                this.getModel().setValue("pluginclass1", opPlugin.get("pluginClass"), rowIndex);
                this.getModel().setValue("status02", (Object)((Boolean)opPlugin.get("status") != false ? "enable" : "disable"), rowIndex);
                this.getModel().setValue("isori02", (Object)((Boolean)opPlugin.get("inherit") != false ? "2" : "1"), rowIndex);
                this.getModel().setValue("desc1", opPlugin.get("desc"), rowIndex);
                this.getModel().setValue("operation", opPlugin.get("opName"), rowIndex);
                this.getModel().setValue("operationnumber", opPlugin.get("opNumber"), rowIndex);
                this.getModel().setValue("objectname1", opPlugin.get("formId"), rowIndex);
                this.getModel().setValue("pluginclass3", opPlugin.get("pluginClass"));
                this.getModel().setValue("isori3", (Object)((Boolean)opPlugin.get("inherit") != false ? ResManager.loadKDString((String)"\u5426", (String)"PluginDetailsPagePlugin_0", (String)BOS_MODELASSET_PLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u662f", (String)"PluginDetailsPagePlugin_1", (String)BOS_MODELASSET_PLUGIN, (Object[])new Object[0])));
                this.getModel().setValue("plugintype", (Object)"2");
                this.getModel().setValue("desc3", opPlugin.get("desc"));
            }
            this.getView().updateView(ENTRY_OPERATION);
        }
        if (otherPlugins == null || otherPlugins.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"otherquote"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"otherquote"});
            for (Map<String, Object> otherPlugin : otherPlugins) {
                rowIndex = this.getModel().createNewEntryRow(ENTRY_OTHER);
                this.getModel().setValue("pluginclass2", otherPlugin.get("pluginClass"), rowIndex);
                this.getModel().setValue("status03", (Object)((Boolean)otherPlugin.get("status") != false ? "enable" : "disable"), rowIndex);
                this.getModel().setValue("isori03", (Object)((Boolean)otherPlugin.get("inherit") != false ? "2" : "1"), rowIndex);
                this.getModel().setValue("desc2", otherPlugin.get("desc"), rowIndex);
                this.getModel().setValue("citetype2", otherPlugin.get("ref"), rowIndex);
                this.getModel().setValue("objectname2", otherPlugin.get("formId"), rowIndex);
                this.getModel().setValue("pluginclass3", otherPlugin.get("pluginClass"));
                this.getModel().setValue("isori3", (Object)((Boolean)otherPlugin.get("inherit") != false ? ResManager.loadKDString((String)"\u5426", (String)"PluginDetailsPagePlugin_0", (String)BOS_MODELASSET_PLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u662f", (String)"PluginDetailsPagePlugin_1", (String)BOS_MODELASSET_PLUGIN, (Object[])new Object[0])));
                this.getModel().setValue("plugintype", (Object)"3");
                this.getModel().setValue("desc3", otherPlugin.get("desc"));
            }
            this.getView().updateView(ENTRY_OTHER);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (BTN_REFRESH.equals(((Button)evt.getSource()).getKey())) {
            String queryType = (String)this.getModel().getValue(FIELD_QUERY_TYPE);
            String queryKey = (String)this.getModel().getValue(FIELD_QUERY_KEY);
            if (StringUtils.isNotBlank((CharSequence)queryType) && StringUtils.isNotBlank((CharSequence)queryKey)) {
                this.queryPlugins(queryType, queryKey.trim());
            }
        }
    }

    private Map<String, List<Map<String, Object>>> byFormNumberQuery(String formNumber) {
        HashMap<String, List<Map<String, Object>>> pluginMap = new HashMap<String, List<Map<String, Object>>>(3);
        String formId = MetadataDao.getIdByNumber((String)formNumber, (MetaCategory)MetaCategory.Form);
        if (StringUtils.isBlank((CharSequence)formId)) {
            return pluginMap;
        }
        FormMetadata formMetadata = new FormMetadata();
        FormAp rootAp = new FormAp();
        try {
            formMetadata = (FormMetadata)MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Form);
            rootAp = formMetadata.getRootAp();
        }
        catch (Exception e) {
            LOG.info("\u8868\u5355\u3010" + formNumber + "\u3011\u8868\u5355\u5143\u6570\u636e\u5b58\u5728\u9519\u8bef\u3002" + e);
        }
        if ("2HGKTA7HH43C".equals(formMetadata.getBizappId())) {
            return pluginMap;
        }
        List formPlugins = rootAp.getPlugins();
        ArrayList<Plugin> listPlugins = new ArrayList(10);
        ArrayList<Plugin> mobPlugins = new ArrayList(10);
        ArrayList<Plugin> mobListPlugins = new ArrayList(10);
        if (rootAp instanceof BillFormAp) {
            if (((BillFormAp)rootAp).getListMeta() != null) {
                listPlugins = ((BillFormAp)rootAp).getListMeta().getRootAp().getPlugins();
            }
            if (((BillFormAp)rootAp).getMobMeta() != null) {
                mobPlugins = ((BillFormAp)rootAp).getMobMeta().getRootAp().getPlugins();
            }
            if (((BillFormAp)rootAp).getMobListMeta() != null) {
                mobListPlugins = ((BillFormAp)rootAp).getMobListMeta().getRootAp().getPlugins();
            }
        }
        ArrayList<Map<String, Object>> formPluginList = new ArrayList<Map<String, Object>>(10);
        List<Map<String, Object>> formP = this.buildPluginInfo(formPlugins, "formmeta", "", "", "", formId);
        List<Map<String, Object>> listP = this.buildPluginInfo(listPlugins, "listmeta", "", "", "", formId);
        List<Map<String, Object>> mobP = this.buildPluginInfo(mobPlugins, "mobmeta", "", "", "", formId);
        List<Map<String, Object>> mobListP = this.buildPluginInfo(mobListPlugins, "moblistmeta", "", "", "", formId);
        formPluginList.addAll(formP);
        formPluginList.addAll(listP);
        formPluginList.addAll(mobP);
        formPluginList.addAll(mobListP);
        pluginMap.put("formPlugins", formPluginList);
        EntityMetadata entityMetadata = new EntityMetadata();
        MainEntity rootEntity = new MainEntity();
        try {
            entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Entity);
            rootEntity = entityMetadata.getRootEntity();
        }
        catch (Exception e) {
            LOG.info("\u8868\u5355\u3010" + formNumber + "\u3011\u5b9e\u4f53\u5143\u6570\u636e\u5b58\u5728\u9519\u8bef\u3002" + e);
        }
        ArrayList<Map<String, Object>> opPluginList = new ArrayList<Map<String, Object>>(10);
        List operations = rootEntity.getOperations();
        for (Operation op : operations) {
            String opName = op.getName().toString();
            String opNumber = op.getKey();
            List opPlugins = op.getPlugins();
            List<Map<String, Object>> mapList = this.buildPluginInfo(opPlugins, "", opName, opNumber, "", formId);
            opPluginList.addAll(mapList);
        }
        pluginMap.put("opPlugins", opPluginList);
        if (rootEntity instanceof BaseEntity) {
            List conPlugins = ((BaseEntity)rootEntity).getBasedataControllers();
            List<Map<String, Object>> conPluginList = this.buildPluginInfo(conPlugins, "", "", "", "basedatacontrollers", formId);
            pluginMap.put("otherPlugins", conPluginList);
        } else if (rootEntity instanceof BillEntity) {
            List botpPlugins = ((BillEntity)rootEntity).getLinkSet().getPlugIns();
            List<Map<String, Object>> botpPluginList = this.buildPluginInfo(botpPlugins, "", "", "", "linkset", formId);
            pluginMap.put("otherPlugins", botpPluginList);
        }
        return pluginMap;
    }

    private List<Map<String, Object>> buildPluginInfo(List<Plugin> plugins, String pageType, String opName, String opNumber, String ref, String formId) {
        ArrayList<Map<String, Object>> pluginList = new ArrayList<Map<String, Object>>(plugins.size());
        for (Plugin p : plugins) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("pluginClass", p.getClassName());
            map.put("status", p.isEnabled());
            map.put("inherit", p.isInherit());
            map.put("desc", p.getDescription());
            map.put("pageType", pageType);
            map.put("opName", opName);
            map.put("opNumber", opNumber);
            map.put("ref", ref);
            map.put("formId", formId);
            pluginList.add(map);
        }
        return pluginList;
    }

    private Map<String, List<Map<String, Object>>> byPluginClassQuery(String queryKey) {
        HashMap<String, List<Map<String, Object>>> pluginsMap = new HashMap<String, List<Map<String, Object>>>(16);
        if (queryKey.contains("%")) {
            return pluginsMap;
        }
        String filterKey = String.format("%s%s%s", "<ClassName>", queryKey, "</ClassName>");
        String sql = "select fnumber from t_meta_formdesign where fdata like ? and fbizappid != ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":fdata", 12, (Object)("%" + filterKey + "%")), new SqlParameter(":fbizappid", 12, (Object)"2HGKTA7HH43C")};
        HashSet numbers = new HashSet(10);
        Set formNumbers = (Set)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet resultSet) throws Exception {
                HashSet<String> numbers = new HashSet<String>(10);
                while (resultSet.next()) {
                    numbers.add(resultSet.getString("fnumber"));
                }
                return numbers;
            }
        });
        String sql1 = "select fnumber from t_meta_entitydesign where fdata like ? and fbizappid != ?";
        Set entityNumbers = (Set)DB.query((DBRoute)DBRoute.meta, (String)sql1, (Object[])params, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet resultSet) throws Exception {
                HashSet<String> numbers = new HashSet<String>(10);
                while (resultSet.next()) {
                    numbers.add(resultSet.getString("fnumber"));
                }
                return numbers;
            }
        });
        numbers.addAll(formNumbers);
        numbers.addAll(entityNumbers);
        ArrayList<Map<String, Object>> formPluginList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> opPluginsList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> otherPluginsList = new ArrayList<Map<String, Object>>(10);
        for (String number : numbers) {
            Map<String, List<Map<String, Object>>> plugins = this.byFormNumberQuery(number);
            List<Map<String, Object>> formPlugins = plugins.get("formPlugins");
            List<Map<String, Object>> opPlugins = plugins.get("opPlugins");
            List<Map<String, Object>> otherPlugins = plugins.get("otherPlugins");
            if (formPlugins != null && !formPlugins.isEmpty()) {
                for (Map<String, Object> formPlugin : formPlugins) {
                    if (!queryKey.equals(formPlugin.get("pluginClass"))) continue;
                    formPluginList.add(formPlugin);
                }
            }
            if (opPlugins != null && !opPlugins.isEmpty()) {
                for (Map<String, Object> opPlugin : opPlugins) {
                    if (!queryKey.equals(opPlugin.get("pluginClass"))) continue;
                    opPluginsList.add(opPlugin);
                }
            }
            if (otherPlugins == null || otherPlugins.isEmpty()) continue;
            for (Map<String, Object> otherPlugin : otherPlugins) {
                if (!queryKey.equals(otherPlugin.get("pluginClass"))) continue;
                otherPluginsList.add(otherPlugin);
            }
        }
        pluginsMap.put("formPlugins", formPluginList);
        pluginsMap.put("opPlugins", opPluginsList);
        pluginsMap.put("otherPlugins", otherPluginsList);
        return pluginsMap;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        EntryGrid source = (EntryGrid)evt.getSource();
        String entryKey = source.getEntryKey();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryKey);
        DynamicObject dynamicObject = (DynamicObject)entryEntity.get(evt.getRowIndex());
        String id = "";
        IFormView view = this.getView();
        switch (fieldName) {
            case "pluginclass": {
                String pluginClass = dynamicObject.getString("pluginclass");
                this.openPluginDetails(pluginClass);
                break;
            }
            case "pluginclass1": {
                String pluginClass1 = dynamicObject.getString("pluginclass1");
                this.openPluginDetails(pluginClass1);
                break;
            }
            case "pluginclass2": {
                String pluginClass2 = dynamicObject.getString("pluginclass2");
                this.openPluginDetails(pluginClass2);
                break;
            }
            case "objectnumber": {
                id = dynamicObject.getString("objectname.id");
                String tabKey = dynamicObject.getString("formtype");
                this.openOldDesigner(view, id, tabKey);
                break;
            }
            case "objectnumber1": {
                id = dynamicObject.getString("objectname1.id");
                this.openOldDesigner(view, id, "");
                break;
            }
            case "objectnumber2": {
                id = dynamicObject.getString("objectname2.id");
                this.openOldDesigner(view, id, "");
                break;
            }
        }
    }

    protected void openOldDesigner(IFormView view, String id, String key) {
        boolean isHasPermission = AppUtils.checkPagePermission((String)"bos_devportal_bizpagelist", (String)"4715a0df000000ac");
        if (!isHasPermission) {
            view.showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"", (String)BOS_MODELASSET_PLUGIN, (Object[])new Object[0]));
            return;
        }
        QFilter qFormId = new QFilter("form", "=", (Object)id);
        DynamicObject pageRelInfo = QueryServiceHelper.queryOne((String)"bos_devportal_unitrelform", (String)"bizapp,bizunit", (QFilter[])new QFilter[]{qFormId});
        if (StringUtils.isBlank((Object)pageRelInfo)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u9875\u9762\u8df3\u8f6c\u5931\u8d25\u3002", (String)"", (String)BOS_MODELASSET_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String appId = pageRelInfo.getString("bizapp");
        DynamicObject pageInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"bos_formmeta");
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_formdesigner");
        parameter.setCustomParam("id", (Object)id);
        parameter.setCustomParam("number", pageInfo.get("number"));
        parameter.setCustomParam("bizappid", (Object)appId);
        parameter.setClientParam("modeltype", pageInfo.get("modeltype"));
        parameter.setClientParam("modelver", (Object)DomainModelType.getVersion());
        parameter.setCustomParam("tabKey", (Object)key);
        parameter.getOpenStyle().setShowType(ShowType.NewWindow);
        view.showForm(parameter);
    }

    private void openPluginDetails(String pluginClass) {
        Map<String, List<Map<String, Object>>> map = this.byPluginClassQuery(pluginClass);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("modelm_plugininfo");
        parameter.setCustomParam("value", (Object)SerializationUtils.toJsonString(map));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCaption(pluginClass);
        String rootPageId = this.getView().getFormShowParameter().getRootPageId();
        String pageId = pluginClass + rootPageId;
        parameter.setPageId(pluginClass + rootPageId);
        IFormView tabView = this.getView().getView(pageId);
        if (tabView != null) {
            tabView.activate();
            this.getView().sendFormAction(tabView);
        } else {
            this.getView().showForm(parameter);
        }
    }
}

