/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.nocode.tree.impl.ast;

import de.odysseus.nocode.misc.LocalMessages;
import de.odysseus.nocode.tree.Bindings;
import de.odysseus.nocode.tree.impl.ast.AstNode;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodInfo;
import javax.el.ValueReference;

public final class AstText
extends AstNode {
    private final String value;

    public AstText(String value) {
        this.value = value;
    }

    @Override
    public boolean isLiteralText() {
        return true;
    }

    @Override
    public boolean isLeftValue() {
        return false;
    }

    @Override
    public boolean isMethodInvocation() {
        return false;
    }

    @Override
    public Class<?> getType(Bindings bindings, ELContext context) {
        return null;
    }

    @Override
    public boolean isReadOnly(Bindings bindings, ELContext context) {
        return true;
    }

    @Override
    public void setValue(Bindings bindings, ELContext context, Object value) {
        throw new ELException(LocalMessages.get("error.value.set.rvalue", this.getStructuralId(bindings)));
    }

    @Override
    public ValueReference getValueReference(Bindings bindings, ELContext context) {
        return null;
    }

    @Override
    public Object eval(Bindings bindings, ELContext context) {
        return this.value;
    }

    @Override
    public MethodInfo getMethodInfo(Bindings bindings, ELContext context, Class<?> returnType, Class<?>[] paramTypes) {
        return null;
    }

    @Override
    public Object invoke(Bindings bindings, ELContext context, Class<?> returnType, Class<?>[] paramTypes, Object[] paramValues) {
        return returnType == null ? this.value : bindings.convert(this.value, returnType);
    }

    public String toString() {
        return "\"" + this.value + "\"";
    }

    @Override
    public void appendStructure(StringBuilder b, Bindings bindings) {
        int end = this.value.length() - 1;
        for (int i = 0; i < end; ++i) {
            char c = this.value.charAt(i);
            if ((c == '#' || c == '$') && this.value.charAt(i + 1) == '{') {
                b.append('\\');
            }
            b.append(c);
        }
        if (end >= 0) {
            b.append(this.value.charAt(end));
        }
    }

    @Override
    public int getCardinality() {
        return 0;
    }

    @Override
    public AstNode getChild(int i) {
        return null;
    }
}

