/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.nocode.tree.impl.ast;

import de.odysseus.nocode.misc.BooleanOperations;
import de.odysseus.nocode.misc.NumberOperations;
import de.odysseus.nocode.misc.TypeConverter;
import de.odysseus.nocode.tree.Bindings;
import de.odysseus.nocode.tree.impl.ast.AstNode;
import de.odysseus.nocode.tree.impl.ast.AstRightValue;
import javax.el.ELContext;
import javax.el.ELException;

public class AstUnary
extends AstRightValue {
    public static final Operator EMPTY = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o) {
            return BooleanOperations.empty(converter, o);
        }

        public String toString() {
            return "empty";
        }
    };
    public static final Operator NEG = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o) {
            return NumberOperations.neg(converter, o);
        }

        public String toString() {
            return "-";
        }
    };
    public static final Operator NOT = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o) {
            return converter.convert(o, Boolean.class) == false;
        }

        public String toString() {
            return "!";
        }
    };
    private final Operator operator;
    private final AstNode child;

    public AstUnary(AstNode child, Operator operator) {
        this.child = child;
        this.operator = operator;
    }

    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public Object eval(Bindings bindings, ELContext context) throws ELException {
        return this.operator.eval(bindings, context, this.child);
    }

    public String toString() {
        return "'" + this.operator.toString() + "'";
    }

    @Override
    public void appendStructure(StringBuilder b, Bindings bindings) {
        b.append(this.operator);
        b.append(' ');
        this.child.appendStructure(b, bindings);
    }

    @Override
    public int getCardinality() {
        return 1;
    }

    @Override
    public AstNode getChild(int i) {
        return i == 0 ? this.child : null;
    }

    public static abstract class SimpleOperator
    implements Operator {
        @Override
        public Object eval(Bindings bindings, ELContext context, AstNode node) {
            return this.apply(bindings, node.eval(bindings, context));
        }

        protected abstract Object apply(TypeConverter var1, Object var2);
    }

    public static interface Operator {
        public Object eval(Bindings var1, ELContext var2, AstNode var3);
    }
}

