/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode;

import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.action.AllowGuest;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.qing.QingData;
import kd.bos.entity.qing.QingMeta;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.JWTUtils;
import kd.bos.nocode.restapi.common.result.RestApiFile;
import kd.bos.nocode.restapi.servlet.utils.ApiStreamUtil;
import kd.bos.nocode.servicehelper.DispatchApiServiceHelper;
import kd.bos.nocode.utils.NcHttpClientUtils;
import kd.bos.nocode.utils.OpenApiAuthUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.session.SessionManager;
import kd.bos.url.UrlService;
import kd.bos.web.DispatchServiceHelper;
import kd.bos.web.actions.MetadataAction;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class NoCodeAction {
    public static final String APP_ID = "appId";
    public static final String NO_CODE_QING_SERVICE = "NoCodeQingService";
    public static Log logger = LogFactory.getLog(NoCodeAction.class);
    private static final String NOCODE_DEBUG_SERVICE = "NoCodeDebugService";
    private static final String NOCODE_DESIGN_METADATA_SERVICE = "NoCodeDesignMetadataService";
    private static final String FORM_ID = "formId";
    private static final String FORM_ID_1 = "formid";
    private static final String METADATA_SERVICE_PREFIX = "kd.bos.service";
    private static final String METADATA_SERVICE = "MetadataService";
    private static final String ENTITY_ID = "entityId";
    private static final String CACHE = "cache";
    private static final String MESSAGE_FORMID_IS_NULL = "formId is null";
    private static final String MESSAGE_APPID_IS_NULL = "appId is null";
    private static final String UTF_8 = "utf-8";
    private static final String KD_CSRF_TOKEN = "kd-csrf-token";
    private static int default_connectionTimeout = Integer.getInteger("httpclient.connectionTimeout", 30000);
    private static int default_readTimeout = Integer.getInteger("httpclient.readTimeout", 60000);

    public static boolean isActionCall(HttpServletRequest request) {
        return request.getRequestURI().contains(".do");
    }

    public static void doAction(HttpServletRequest request, HttpServletResponse response) {
        NoCodeAction action = new NoCodeAction();
        try {
            if (request.getRequestURI().contains("help.do")) {
                action.help(request, response);
            } else if (request.getRequestURI().contains("getWfDomainModel.do")) {
                action.getWfDomainModel(request, response);
            } else if (request.getRequestURI().contains("getMetadata.do")) {
                action.getMetadata(request, response);
            } else if (request.getRequestURI().contains("getJarInfo.do")) {
                action.getJarInfo(request, response);
            } else if (request.getRequestURI().contains("getFormMetadata.do")) {
                action.getFormMetadata(request, response);
            } else if (request.getRequestURI().contains("getEntityMetadata.do")) {
                action.getEntityMetadata(request, response);
            } else if (request.getRequestURI().contains("getEntityType.do")) {
                action.getEntityType(request, response);
            } else if (request.getRequestURI().contains("getEntityOperate.do")) {
                action.getEntityOperate(request, response);
            } else if (request.getRequestURI().contains("getControl.do")) {
                action.getControl(request, response);
            } else if (request.getRequestURI().contains("getTableInfo.do")) {
                action.getTableInfo(request, response);
            } else if (request.getRequestURI().contains("exportMetaByApp.do")) {
                action.exportMetaByApp(request, response);
            } else if (request.getRequestURI().contains("exportJsonMetaByApp.do")) {
                action.exportJsonMetaByApp(request, response);
            } else if (request.getRequestURI().contains("importMetaByApp.do")) {
                action.importMetaByApp(request, response);
            } else if (request.getRequestURI().contains("getQingMeta.do")) {
                action.getQingMeta(request, response);
            } else if (request.getRequestURI().contains("getQingData.do")) {
                action.getQingData(request, response);
            } else if (request.getRequestURI().contains("getQingQFilter.do")) {
                action.getQingQFilter(request, response);
            } else if (request.getRequestURI().contains("fixupData.do")) {
                action.fixupData(request, response);
            } else if (request.getRequestURI().contains("getDomainModel.do")) {
                action.getDomainModel(request, response);
            } else if (request.getRequestURI().contains("clearInvalidWfInfo.do")) {
                action.clearInvalidWfInfo(request, response);
            } else if (request.getRequestURI().contains("getAccessToken.do")) {
                action.getAccessToken(request, response);
            }
        }
        catch (IOException e) {
            logger.warn((Throwable)e);
        }
    }

    @AllowGuest
    private void getAccessToken(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        HashMap<String, String> errorMap = new HashMap<String, String>();
        errorMap.put("errorCode", "999");
        errorMap.put("message", ResManager.loadKDString((String)"\u83b7\u53d6\u6388\u6743\u5931\u8d25", (String)"NoCodeAction_0", (String)"bos-nocode-core", (Object[])new Object[0]));
        String userPhone = null;
        String accountId = null;
        String tenantId = null;
        try {
            String sign = request.getParameter("sign");
            Map requestInfo = JWTUtils.getJWTClaimsByKey((String)OpenApiAuthUtil.getOrCreateSC(), (String)sign);
            userPhone = (String)requestInfo.get("phone");
            accountId = (String)requestInfo.get("accountId");
            tenantId = (String)requestInfo.get("tenantId");
        }
        catch (Exception e) {
            errorMap.put("message", ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5", (String)"NoCodeAction_1", (String)"bos-nocode-core", (Object[])new Object[0]));
            response.getOutputStream().write(SerializationUtils.toJsonString(errorMap).getBytes(StandardCharsets.UTF_8));
            return;
        }
        HashMap header = new HashMap();
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("user", userPhone);
        body.put(APP_ID, "nocode");
        body.put("appSecret", OpenApiAuthUtil.getOrCreateSC());
        body.put("tenantid", tenantId);
        body.put("accountId", accountId);
        body.put("usertype", "Mobile");
        String res = null;
        String urlCosmic = UrlService.getDomainContextUrl();
        String getAccessTokenUrl = urlCosmic + "/api/login.do";
        boolean success = false;
        try {
            res = NcHttpClientUtils.postjson((String)getAccessTokenUrl, header, body, (int)default_connectionTimeout, (int)default_readTimeout, (boolean)true);
            success = true;
        }
        catch (Exception e) {
            logger.info("et:" + e.getMessage(), (Object)e);
            errorMap.put("message", e.getMessage());
        }
        try {
            if (success && StringUtils.isNotEmpty((CharSequence)res)) {
                Map resp = (Map)SerializationUtils.fromJsonString((String)res, Map.class);
                if (resp.get("status") instanceof Boolean && ((Boolean)resp.get("status")).booleanValue()) {
                    resp.put("errorCode", "0");
                }
                res = SerializationUtils.toJsonString((Object)resp);
                response.getOutputStream().write(res.getBytes(StandardCharsets.UTF_8));
            } else {
                response.getOutputStream().write(SerializationUtils.toJsonString(errorMap).getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (Exception e) {
            logger.info("et:" + e.getMessage(), (Object)e);
        }
    }

    @AllowGuest
    private void clearInvalidWfInfo(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String entityNumber = request.getParameter("entityNumber");
        String pkId = request.getParameter("pkId");
        String appId = this.getAppId(request);
        String result = (String)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.nocode.servicehelper", (String)appId, (String)NOCODE_DEBUG_SERVICE, (String)"clearInvalidWfInfo", (Object[])new Object[]{entityNumber, pkId});
        ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)result);
    }

    @AllowGuest
    public void getQingMeta(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String appId = request.getParameter(APP_ID);
        String formId = request.getParameter(FORM_ID);
        QingMeta result = (QingMeta)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.nocode.servicehelper", (String)appId, (String)NO_CODE_QING_SERVICE, (String)"getQingMeta", (Object[])new Object[]{appId, formId});
        ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)SerializationUtils.toJsonString((Object)result));
    }

    @AllowGuest
    public void getQingData(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String appId = request.getParameter(APP_ID);
        String formId = request.getParameter(FORM_ID);
        String filters = request.getParameter("filters");
        int pageNo = Integer.parseInt(request.getParameter("pageNo"));
        int pageSize = Integer.parseInt(request.getParameter("pageSize"));
        QingData result = (QingData)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.nocode.servicehelper", (String)appId, (String)NO_CODE_QING_SERVICE, (String)"getQingData", (Object[])new Object[]{appId, formId, filters, pageNo, pageSize});
        ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)SerializationUtils.toJsonString((Object)result));
    }

    @AllowGuest
    public void getQingQFilter(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String formId = request.getParameter(FORM_ID);
        String filters = request.getParameter("filterStr");
        QFilter result = (QFilter)kd.bos.servicehelper.DispatchServiceHelper.invokeService((String)"kd.bos.nocode.servicehelper", (String)"bos", (String)NO_CODE_QING_SERVICE, (String)"getQFilter", (Object[])new Object[]{formId, filters});
        ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)SerializationUtils.toJsonString((Object)result));
    }

    private String getRelaRoot(String domainUrl) {
        String[] split = domainUrl.split("/");
        return "/" + split[split.length - 1];
    }

    public void getWfDomainModel(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String result = (String)DispatchApiServiceHelper.invokeApiService((String)"NoCodeWfDesignerService", (String)"getWfDomainModel", (Object[])new Object[0]);
        ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)result);
    }

    public void getMetadata(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String id = request.getParameter("fid");
        String appId = "bos";
        String metadata = (String)DispatchServiceHelper.invokeBOSServiceByAppId((String)appId, (String)METADATA_SERVICE, (String)"loadClientFormMeta", (Object[])new Object[]{id});
        String kdCsrfToken = SessionManager.getCSRFTokenValue((String)RequestContext.get().getGlobalSessionId());
        if (kd.bos.util.StringUtils.isNotEmpty((String)kdCsrfToken)) {
            response.addHeader(KD_CSRF_TOKEN, kdCsrfToken);
        }
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)metadata);
    }

    public void help(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try (InputStream in = MetadataAction.class.getResourceAsStream("/nocodemetahelp.html");){
            ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)NoCodeAction.getContent(in));
        }
    }

    @AllowGuest
    public void getJarInfo(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String jarname = request.getParameter("jarname");
        String appId = this.getAppId(request);
        String jarInfo = (String)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.nocode.servicehelper", (String)appId, (String)NOCODE_DEBUG_SERVICE, (String)"getJarInfo", (Object[])new Object[]{jarname});
        ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)jarInfo);
    }

    @AllowGuest
    public void fixupData(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String tag = request.getParameter("tag");
        String appId = this.getAppId(request);
        String result = (String)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.nocode.servicehelper", (String)appId, (String)NOCODE_DEBUG_SERVICE, (String)"fixupData", (Object[])new Object[]{tag});
        ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)result);
    }

    @AllowGuest
    public void getFormMetadata(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String formId = request.getParameter(FORM_ID);
        if (formId == null) {
            formId = request.getParameter(FORM_ID_1);
        }
        if (formId == null) {
            ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)MESSAGE_FORMID_IS_NULL);
            return;
        }
        String appId = this.getAppId(request);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)((CharSequence)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.nocode.servicehelper", (String)appId, (String)NOCODE_DEBUG_SERVICE, (String)"getFormMetadata", (Object[])new Object[]{formId})));
    }

    @AllowGuest
    public void getEntityMetadata(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String entityId = request.getParameter(ENTITY_ID);
        String appId = this.getAppId(request);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)((CharSequence)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.nocode.servicehelper", (String)appId, (String)NOCODE_DEBUG_SERVICE, (String)"getEntityMetadata", (Object[])new Object[]{entityId})));
    }

    public void getEntityOperate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String entityId = request.getParameter(ENTITY_ID);
        String operKey = request.getParameter("operKey");
        String appId = this.getAppId(request);
        if (StringUtils.isNotBlank((CharSequence)operKey)) {
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)((CharSequence)DispatchServiceHelper.invokeBOSServiceByAppId((String)appId, (String)METADATA_SERVICE, (String)"loadEntityOperationMeta", (Object[])new Object[]{entityId, operKey})));
        } else {
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)JSON.toJSONString((Object)DispatchServiceHelper.invokeBOSServiceByAppId((String)appId, (String)METADATA_SERVICE, (String)"loadEntityAllOperationMeta", (Object[])new Object[]{entityId})));
        }
    }

    public void getEntityType(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String entityId = request.getParameter(ENTITY_ID);
        String cache = request.getParameter(CACHE);
        String appId = this.getAppId(request);
        if (StringUtils.isNotEmpty((CharSequence)cache) && cache.equalsIgnoreCase("true")) {
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)((CharSequence)DispatchApiServiceHelper.invokeApiService((String)METADATA_SERVICE_PREFIX, (String)appId, (String)METADATA_SERVICE, (String)"loadEntityMetaFromCache", (Object[])new Object[]{entityId})));
        } else {
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)((CharSequence)DispatchApiServiceHelper.invokeApiService((String)METADATA_SERVICE_PREFIX, (String)appId, (String)METADATA_SERVICE, (String)"loadEntityMeta", (Object[])new Object[]{entityId})));
        }
    }

    public void getControl(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String formId = request.getParameter(FORM_ID);
        if (formId == null) {
            formId = request.getParameter(FORM_ID_1);
        }
        if (formId == null) {
            ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)MESSAGE_FORMID_IS_NULL);
            return;
        }
        String appId = this.getAppId(request);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)((CharSequence)DispatchServiceHelper.invokeBOSServiceByAppId((String)appId, (String)METADATA_SERVICE, (String)"getControls", (Object[])new Object[]{formId})));
    }

    private static String getContent(InputStream in) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        String line = null;
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append('\n');
        }
        in.close();
        return sb.toString();
    }

    private String getAppId(HttpServletRequest request) {
        String appId = request.getParameter(APP_ID);
        appId = appId == null ? "bos" : appId;
        return appId;
    }

    @AllowGuest
    public void getTableInfo(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String formId = request.getParameter(FORM_ID);
        if (formId == null) {
            formId = request.getParameter(FORM_ID_1);
        }
        if (formId == null) {
            ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)MESSAGE_FORMID_IS_NULL);
            return;
        }
        String appId = this.getAppId(request);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)((CharSequence)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.nocode.servicehelper", (String)appId, (String)NOCODE_DEBUG_SERVICE, (String)"getTableInfo", (Object[])new Object[]{formId})));
    }

    @AllowGuest
    public void exportMetaByApp(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String appId = request.getParameter(APP_ID);
        if (StringUtils.isBlank((CharSequence)appId)) {
            ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)MESSAGE_APPID_IS_NULL);
            return;
        }
        Object attUrl = DispatchApiServiceHelper.invokeApiService((String)"kd.bos.nocode.servicehelper", (String)appId, (String)NOCODE_DEBUG_SERVICE, (String)"exportMetaByApp", (Object[])new Object[]{appId});
        if (!(attUrl instanceof String) || StringUtils.isBlank((Object)attUrl)) {
            ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)ResManager.loadKDString((String)"\u5bfc\u51fa\u751f\u6210\u5931\u8d25", (String)"NoCodeAction_2", (String)"bos-nocode-core", (Object[])new Object[0]));
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<!DOCTYPE html>");
        sb.append("<html lang=\"en\">");
        sb.append("<head>");
        sb.append("    <meta charset=\"UTF-8\">");
        sb.append("    <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">");
        sb.append("    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">");
        sb.append("</head>");
        sb.append("<body>");
        sb.append("  <p >").append((String)attUrl).append("</p>");
        sb.append("  <a href=\"").append((String)attUrl).append("\">").append(ResManager.loadKDString((String)"\u70b9\u51fb\u4e0b\u8f7d", (String)"NoCodeAction_3", (String)"bos-nocode-core", (Object[])new Object[0])).append("</a>");
        sb.append("</body>");
        sb.append("</html>");
        response.setContentType("text/html");
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), UTF_8);){
            writer.write(sb.toString());
            writer.flush();
        }
        catch (IOException e) {
            logger.warn((Throwable)e);
            throw e;
        }
    }

    @AllowGuest
    public void exportJsonMetaByApp(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String appId = request.getParameter(APP_ID);
        if (StringUtils.isBlank((CharSequence)appId)) {
            ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)MESSAGE_APPID_IS_NULL);
            return;
        }
        Object attUrl = DispatchApiServiceHelper.invokeApiService((String)"kd.bos.nocode.servicehelper", (String)appId, (String)NOCODE_DEBUG_SERVICE, (String)"exportJsonMetaByApp", (Object[])new Object[]{appId});
        if (!(attUrl instanceof String) || StringUtils.isBlank((Object)attUrl)) {
            ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)ResManager.loadKDString((String)"\u5bfc\u51fa\u751f\u6210\u5931\u8d25", (String)"NoCodeAction_2", (String)"bos-nocode-core", (Object[])new Object[0]));
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<!DOCTYPE html>");
        sb.append("<html lang=\"en\">");
        sb.append("<head>");
        sb.append("    <meta charset=\"UTF-8\">");
        sb.append("    <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">");
        sb.append("    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">");
        sb.append("</head>");
        sb.append("<body>");
        sb.append("  <p >").append((String)attUrl).append("</p>");
        sb.append("  <a href=\"").append((String)attUrl).append("\">").append(ResManager.loadKDString((String)"\u70b9\u51fb\u4e0b\u8f7d", (String)"NoCodeAction_3", (String)"bos-nocode-core", (Object[])new Object[0])).append("</a>");
        sb.append("</body>");
        sb.append("</html>");
        response.setContentType("text/html");
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), UTF_8);){
            writer.write(sb.toString());
            writer.flush();
        }
        catch (IOException e) {
            logger.warn((Throwable)e);
            throw e;
        }
    }

    @AllowGuest
    public void importMetaByApp(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\uff1amultipart/form-data", (String)"NoCodeAction_4", (String)"bos-nocode-core", (Object[])new Object[0]));
            return;
        }
        RestApiFile multipartContent = null;
        try {
            multipartContent = NoCodeAction.getMultipartContent(request);
        }
        catch (FileUploadException e) {
            ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)e.getMessage());
            return;
        }
        if (multipartContent == null) {
            ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u83b7\u53d6\u5931\u8d25", (String)"NoCodeAction_5", (String)"bos-nocode-core", (Object[])new Object[0]));
            return;
        }
        String appId = this.getAppId(request);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)((CharSequence)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.nocode.servicehelper", (String)appId, (String)NOCODE_DEBUG_SERVICE, (String)"importMetaByApp", (Object[])new Object[]{multipartContent})));
    }

    private static RestApiFile getMultipartContent(HttpServletRequest request) throws FileUploadException, IOException {
        DiskFileItemFactory diskFilefactoy = new DiskFileItemFactory();
        ServletFileUpload sfu = new ServletFileUpload((FileItemFactory)diskFilefactoy);
        List list = sfu.parseRequest(request);
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            FileItem fileItem = (FileItem)iterator.next();
            fileItem.getFieldName();
            byte[] fileData = ApiStreamUtil.getBytesByFileItem(fileItem);
            RestApiFile fileInfo = new RestApiFile(fileItem.getName(), fileItem.getContentType(), false, fileData);
            return fileInfo;
        }
        return null;
    }

    public void getDomainModel(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String modelType = request.getParameter("modelType");
            String targetFormId = request.getParameter("targetFormId");
            String appId = this.getAppId(request);
            String result = (String)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.nocode.servicehelper", (String)appId, (String)NOCODE_DESIGN_METADATA_SERVICE, (String)"getNoCodeDomainModel", (Object[])new Object[]{modelType, targetFormId});
            ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)result);
        }
        catch (Exception ex) {
            logger.warn((Throwable)ex);
            throw new IOException(ex.getMessage());
        }
    }
}

