/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.cache;

import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;

public class NoCodeCacheService {
    private static final NoCodeCacheService INSTANCE = new NoCodeCacheService();
    private final DistributeSessionlessCache CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("nocode", new DistributeCacheHAPolicy(true, true));
    private static final int DEFAULT_TIMEOUT_SECONDS = 432000;

    public static NoCodeCacheService getInstance() {
        return INSTANCE;
    }

    private NoCodeCacheService() {
    }

    public void put(String key, String value, int timeoutSeconds) {
        this.CACHE.put(key, (Object)value, timeoutSeconds);
    }

    public void put(String key, String value) {
        this.put(key, value, 432000);
    }

    public String get(String key) {
        return (String)this.CACHE.get(key);
    }

    public void remove(String key) {
        this.CACHE.remove(key);
    }

    public void put(String key, String field, String value, int timeoutSeconds) {
        this.CACHE.put(key, field, value, timeoutSeconds);
    }

    public void put(String key, String field, String value) {
        this.put(key, field, value, 432000);
    }

    public String get(String key, String field) {
        return (String)this.CACHE.get(key, field);
    }

    public void remove(String key, String field) {
        this.CACHE.remove(key, field);
    }
}

