/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.coderule.impl;

import java.util.Date;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.nocode.coderule.CodeRuleService;
import kd.bos.nocode.coderule.handler.CodeRuleHandlerChain;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeBillNoField;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CodeRuleServiceImpl
implements CodeRuleService {
    public static final String BOS_CODERULE = "bos_coderule";
    public static final String ID = "id";
    public static final String MASTERID = "masterid";
    public static final String BIZOBJECTID = "bizobjectid";
    public static final String NAME = "name";
    public static final String SPLITSIGN = "splitsign";
    public static final String APPMODE = "appmode";
    public static final String CTRLMODE = "ctrlmode";
    public static final String STATUS = "status";
    public static final String CREATOR = "creator";
    public static final String MODIFIER = "modifier";
    public static final String CREATETIME = "createtime";
    public static final String MODIFYTIME = "modifytime";
    public static final String ENABLE = "enable";
    public static final String NUMBER = "number";
    public static final String ISADDVIEW = "isaddview";
    public static final String ISMODIFIABLE = "ismodifiable";
    public static final String ISUNIQUE = "isunique";
    public static final String ISSERIALNUMBER = "isserialnumber";
    public static final String ISNONBREAK = "isnonbreak";
    public static final String ISFAST = "isfast";
    public static final String BOS_OBJECTTYPE = "bos_objecttype";
    public static final String OPERATION_TYPE_SAVE = "save";
    public static final String OPERATION_TYPE_SAVE_AND_NEW = "saveandnew";
    public static final String CODERULE_OP_PLUGIN_CLASSNAME = "kd.bos.business.plugin.CodeRuleOp";
    public static final String CODERULE_PLUGIN_CLASSNAME = "kd.bos.form.plugin.CodeRulePlugin";
    private static final Log log = LogFactory.getLog(CodeRuleServiceImpl.class);

    @Override
    public void saveCodeRule(FormMetadata formMetadata) {
        String formId = formMetadata.getId();
        DynamicObject codeRule = BusinessDataServiceHelper.loadSingle((String)BOS_CODERULE, (QFilter[])new QFilter(BIZOBJECTID, "=", (Object)formId).toArray());
        if (Objects.isNull(codeRule)) {
            this.saveDataForInsert(formMetadata);
        } else {
            String codeRuleId = codeRule.getString(ID);
            this.saveDataForUpdate(codeRuleId, formMetadata);
        }
    }

    @Override
    public void deleteCodeRule(FormMetadata formMetadata) {
        String formId = formMetadata.getId();
        DynamicObject codeRule = BusinessDataServiceHelper.loadSingle((String)BOS_CODERULE, (QFilter[])new QFilter(BIZOBJECTID, "=", (Object)formId).toArray());
        if (Objects.nonNull(codeRule)) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    DeleteServiceHelper.delete((String)BOS_CODERULE, (QFilter[])new QFilter(BIZOBJECTID, "=", (Object)formId).toArray());
                    this.deleteEntryById(codeRule.getString(ID));
                }
                catch (Exception e) {
                    h.markRollback();
                    log.warn((Throwable)e);
                    throw new KDBizException(ResManager.loadKDString((String)"\u5220\u9664\u7f16\u7801\u89c4\u5219\u5931\u8d25", (String)"CodeRuleServiceImpl_0", (String)"bos-nocode-core", (Object[])new Object[0]));
                }
            }
        }
    }

    private void saveDataForInsert(FormMetadata formMetadata) {
        String formId = formMetadata.getId();
        String appMode = "2";
        DynamicObject dynamicObject = ORM.create().newDynamicObject(BOS_CODERULE);
        dynamicObject = (DynamicObject)new CloneUtils(false, true).clone((IDataEntityBase)dynamicObject);
        DynamicObject bizObject = BusinessDataServiceHelper.loadSingle((Object)formId, (String)BOS_OBJECTTYPE);
        dynamicObject.set(BIZOBJECTID, (Object)bizObject);
        dynamicObject.set(NAME, (Object)this.getUniqueName(formMetadata.getName()));
        dynamicObject.set(SPLITSIGN, (Object)"-");
        dynamicObject.set(APPMODE, (Object)appMode);
        dynamicObject.set(CTRLMODE, (Object)"1");
        dynamicObject.set(STATUS, (Object)"C");
        dynamicObject.set(CREATOR, (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set(MODIFIER, (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set(CREATETIME, (Object)new Date());
        dynamicObject.set(MODIFYTIME, (Object)new Date());
        dynamicObject.set(ENABLE, (Object)1);
        dynamicObject.set(NUMBER, (Object)kd.bos.id.ID.genStringId());
        dynamicObject.set(ISADDVIEW, (Object)true);
        dynamicObject.set(ISMODIFIABLE, (Object)true);
        dynamicObject.set(ISUNIQUE, (Object)false);
        dynamicObject.set(ISSERIALNUMBER, (Object)true);
        dynamicObject.set(ISNONBREAK, (Object)false);
        String genStringId = DBServiceHelper.genStringId();
        dynamicObject.set(ID, (Object)genStringId);
        dynamicObject.set(MASTERID, (Object)genStringId);
        try (TXHandle h = TX.requiresNew();){
            try {
                DynamicObjectCollection ruleentry = dynamicObject.getDynamicObjectCollection("ruleentry");
                this.buildEntryEntity(formMetadata, ruleentry);
                log.debug("\u7f16\u7801\u89c4\u5219\uff1a{}", (Object)SerializationUtils.toJsonString((Object)dynamicObject));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            }
            catch (Exception e) {
                h.markRollback();
                log.warn((Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u9519\u7f16\u7801\u89c4\u5219\u5931\u8d25", (String)"CodeRuleServiceImpl_1", (String)"bos-nocode-core", (Object[])new Object[0]));
            }
        }
    }

    private String getUniqueName(LocaleString name) {
        return String.format("%s\u3010%s\u3011", name, Uuid8.generateShortUuid());
    }

    private void saveDataForUpdate(String id, FormMetadata formMetadata) {
        try (TXHandle h = TX.requiresNew();){
            try {
                this.deleteEntryById(id);
                DynamicObject updateCoderule = BusinessDataServiceHelper.loadSingle((Object)id, (String)BOS_CODERULE);
                updateCoderule.set(MODIFIER, (Object)RequestContext.get().getCurrUserId());
                updateCoderule.set(MODIFYTIME, (Object)new Date());
                updateCoderule.set(ISMODIFIABLE, (Object)true);
                DynamicObjectCollection ruleentry = updateCoderule.getDynamicObjectCollection("ruleentry");
                this.buildEntryEntity(formMetadata, ruleentry);
                SaveServiceHelper.save((IDataEntityType)updateCoderule.getDataEntityType(), (Object[])new DynamicObject[]{updateCoderule});
            }
            catch (Exception e) {
                h.markRollback();
                throw new KDBizException(ResManager.loadKDString((String)"\u4fee\u6539\u7f16\u7801\u89c4\u5219\u5931\u8d25", (String)"CodeRuleServiceImpl_2", (String)"bos-nocode-core", (Object[])new Object[0]));
            }
        }
    }

    private void deleteEntryById(String coderuleId) {
        String sql = "delete from t_cr_coderuleentry where fid = '" + coderuleId + "'";
        DB.execute((DBRoute)DBRoute.basedata, (String)sql, null);
    }

    private void buildEntryEntity(FormMetadata formMetadata, DynamicObjectCollection entry) {
        EntityItem entityItem = formMetadata.getEntityMetadata().getItems().stream().filter(NoCodeBillNoField.class::isInstance).findFirst().orElse(null);
        if (Objects.isNull(entityItem)) {
            return;
        }
        NoCodeBillNoField field = (NoCodeBillNoField)entityItem;
        new CodeRuleHandlerChain().handle(field, entry);
    }
}

