/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.coderule.utils;

import java.util.List;
import java.util.Optional;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.entity.BusinessControl;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import org.jetbrains.annotations.NotNull;

public abstract class CodeRuleServiceUtils {
    private CodeRuleServiceUtils() {
    }

    public static void setBusinessControl(FormMetadata formMetadata, boolean value) {
        CodeRuleServiceUtils.getMainEntity(formMetadata).ifPresent(mainEntity -> {
            BusinessControl businessControl = mainEntity.getBusinessControl();
            businessControl.setCodeNumber(value);
        });
    }

    public static void addCodeRulePlugin(FormMetadata formMetadata) {
        FormAp rootAp = formMetadata.getRootAp();
        boolean exists = rootAp.getPlugins().stream().anyMatch(e -> e.getClassName().equalsIgnoreCase("kd.bos.form.plugin.CodeRulePlugin"));
        if (!exists) {
            rootAp.getPlugins().add(CodeRuleServiceUtils.getPlugin("kd.bos.form.plugin.CodeRulePlugin"));
        }
    }

    public static void addCodeRuleOpPlugin(FormMetadata formMetadata) {
        CodeRuleServiceUtils.getMainEntity(formMetadata).ifPresent(mainEntity -> {
            List operations = mainEntity.getOperations();
            for (Operation operation : operations) {
                boolean exists;
                if (!"save".equalsIgnoreCase(operation.getOperationType()) && !"saveandnew".equalsIgnoreCase(operation.getOperationType()) || (exists = operation.getPlugins().stream().anyMatch(e -> e.getClassName().equalsIgnoreCase("kd.bos.business.plugin.CodeRuleOp")))) continue;
                operation.getPlugins().add(CodeRuleServiceUtils.getPlugin("kd.bos.business.plugin.CodeRuleOp"));
            }
        });
    }

    @NotNull
    public static Optional<MainEntity> getMainEntity(FormMetadata formMetadata) {
        List items = formMetadata.getEntityMetadata().getItems();
        return items.stream().filter(MainEntity.class::isInstance).map(MainEntity.class::cast).findFirst();
    }

    public static Plugin getPlugin(String className) {
        Plugin plugin = new Plugin();
        plugin.setClassName(className);
        plugin.setEnabled(true);
        return plugin;
    }
}

