/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.design;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.FormAp;
import kd.bos.nocode.ext.constant.ElementCategoryEnum;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeBillNoField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeCreateDateField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeCreatorField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeModifierField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeModifyDateField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeRefBillField;
import kd.bos.nocode.ext.metadata.form.NoCodeBillFormAp;
import org.apache.commons.lang3.ClassUtils;

public class SysFieldHandler {
    private SysFieldHandler() {
    }

    public static SysFieldHandler create() {
        return new SysFieldHandler();
    }

    public void handleSysFields(EntityMetadata entityMetadata, EntityMetadata oldEntityMetadata, FormAp rootAp) {
        if (!(rootAp instanceof NoCodeBillFormAp)) {
            return;
        }
        String SysSettingStr = ((NoCodeBillFormAp)rootAp).getSysSetting();
        Map sysSetting = (Map)SerializationUtils.fromJsonString((String)SysSettingStr, Map.class);
        List entityItems = entityMetadata.getItems();
        List oldEntityItems = oldEntityMetadata.getItems();
        List entryItems = entityMetadata.getItems().stream().filter(item -> item.getParentId() != null && item.getParentId().length() == 3).collect(Collectors.toList());
        List oldEntryItems = oldEntityMetadata.getItems().stream().filter(item -> item.getParentId() != null && item.getParentId().length() == 3).collect(Collectors.toList());
        entityItems.removeIf(item -> item.getParentId() != null && item.getParentId().length() == 3);
        oldEntityItems.removeIf(item -> item.getParentId() != null && item.getParentId().length() == 3);
        this.checkSysFieldUnique(entityItems, entityMetadata.getId());
        if (this.enableRecordInfo(sysSetting)) {
            if (!this.existCreatorField(entityItems)) {
                this.genCreatorField(entityItems, oldEntityItems);
            } else {
                this.mergeCreatorField(entityItems, oldEntityItems);
            }
            if (!this.existCreateDateField(entityItems)) {
                this.genCreateDateField(entityItems, oldEntityItems);
            } else {
                this.mergeCreateDateField(entityItems, oldEntityItems);
            }
            if (!this.existModifierField(entityItems)) {
                this.genModifierField(entityItems, oldEntityItems);
            } else {
                this.mergeModifierField(entityItems, oldEntityItems);
            }
            if (!this.existModifyDateField(entityItems)) {
                this.genModifyDateField(entityItems, oldEntityItems);
            } else {
                this.mergeModifyDateField(entityItems, oldEntityItems);
            }
        } else {
            entityItems.removeIf(this::isRecordInfoField);
            if (this.existCreatorField(oldEntityItems)) {
                entityItems.addAll(this.getRecordInfoFields(oldEntityItems));
            }
        }
        if (this.enableBillNo(sysSetting)) {
            if (!this.existBillNoField(entityItems)) {
                this.genBillNoField(entityItems, oldEntityItems);
            } else {
                this.mergeBillNoField(entityItems, oldEntityItems);
            }
        } else {
            entityItems.removeIf(NoCodeBillNoField.class::isInstance);
            if (this.existBillNoField(oldEntityItems)) {
                entityItems.add(this.getBillNoField(oldEntityItems));
            }
        }
        entityItems.addAll(entryItems);
        if (entityItems != oldEntityItems) {
            oldEntityItems.addAll(oldEntryItems);
        }
        entityMetadata.createIndex(true);
    }

    private void checkSysFieldUnique(List<EntityItem<?>> entityItems, String id) {
        Map<Class, Long> countMap = entityItems.stream().filter(item -> id.equals(item.getParentId())).collect(Collectors.groupingBy(Object::getClass, Collectors.counting()));
        if (countMap.getOrDefault(NoCodeCreatorField.class, 0L) > 1L || countMap.getOrDefault(NoCodeModifierField.class, 0L) > 1L || countMap.getOrDefault(NoCodeCreateDateField.class, 0L) > 1L || countMap.getOrDefault(NoCodeModifyDateField.class, 0L) > 1L || countMap.getOrDefault(NoCodeBillNoField.class, 0L) > 1L) {
            throw new KDException(new ErrorCode("-1", ResManager.loadKDString((String)"\u91cd\u590d\u6dfb\u52a0\u4e86\u7cfb\u7edf\u529f\u80fd\u5b57\u6bb5", (String)"SysFieldHandler_0", (String)"BOS_NOCODE", (Object[])new Object[0])), new Object[0]);
        }
    }

    public NoCodeBillNoField getBillNoField(List<EntityItem<?>> entityItems) {
        return entityItems.stream().filter(NoCodeBillNoField.class::isInstance).map(NoCodeBillNoField.class::cast).findFirst().orElse(null);
    }

    public List<EntityItem<?>> getRecordInfoFields(List<EntityItem<?>> entityItems) {
        return entityItems.stream().filter(this::isRecordInfoField).collect(Collectors.toList());
    }

    public boolean isRecordInfoField(EntityItem<?> item) {
        return item instanceof NoCodeCreatorField || item instanceof NoCodeModifierField || item instanceof NoCodeCreateDateField || item instanceof NoCodeModifyDateField;
    }

    public boolean existCreatorField(List<EntityItem<?>> entityItems) {
        return this.existField(entityItems, NoCodeCreatorField.class);
    }

    public boolean existModifierField(List<EntityItem<?>> entityItems) {
        return this.existField(entityItems, NoCodeModifierField.class);
    }

    public boolean existCreateDateField(List<EntityItem<?>> entityItems) {
        return this.existField(entityItems, NoCodeCreateDateField.class);
    }

    public boolean existModifyDateField(List<EntityItem<?>> entityItems) {
        return this.existField(entityItems, NoCodeModifyDateField.class);
    }

    public boolean existBillNoField(List<EntityItem<?>> entityItems) {
        return this.existField(entityItems, NoCodeBillNoField.class);
    }

    public boolean existField(List<EntityItem<?>> entityItems, Class<?> clazz) {
        return entityItems.stream().anyMatch(clazz::isInstance);
    }

    public void genField(List<EntityItem<?>> entityItems, List<EntityItem<?>> oldEntityItems, Class<? extends Field<?>> clazz, String name) {
        Optional<EntityItem> fieldOp = oldEntityItems.stream().filter(clazz::isInstance).findFirst();
        if (fieldOp.isPresent()) {
            entityItems.add(fieldOp.get());
            return;
        }
        try {
            Field<?> field = clazz.newInstance();
            field.getFeatures().setVer(1);
            field.setId(ID.genStringId());
            field.setKey(this.getLowerCaseName(clazz));
            field.setName(new LocaleString(name));
            if (field instanceof NoCodeRefBillField) {
                ((NoCodeRefBillField)field).setLableHyperlink(false);
            }
            field.getFeatures().setCopyable(false);
            entityItems.add((EntityItem<?>)field);
        }
        catch (Exception e) {
            throw new KDException(new ErrorCode("error", "gen field error"), new Object[0]);
        }
    }

    public String getLowerCaseName(Class<?> clazz) {
        return ClassUtils.getSimpleName(clazz).toLowerCase();
    }

    public void genCreatorField(List<EntityItem<?>> entityItems, List<EntityItem<?>> oldEntityItems) {
        this.genField(entityItems, oldEntityItems, NoCodeCreatorField.class, ResManager.loadKDString((String)"\u521b\u5efa\u4eba", (String)"SysFieldHandler_1", (String)"bos-nocode-core", (Object[])new Object[0]));
    }

    public void genModifierField(List<EntityItem<?>> entityItems, List<EntityItem<?>> oldEntityItems) {
        this.genField(entityItems, oldEntityItems, NoCodeModifierField.class, ResManager.loadKDString((String)"\u4fee\u6539\u4eba", (String)"SysFieldHandler_2", (String)"bos-nocode-core", (Object[])new Object[0]));
    }

    public void genCreateDateField(List<EntityItem<?>> entityItems, List<EntityItem<?>> oldEntityItems) {
        this.genField(entityItems, oldEntityItems, NoCodeCreateDateField.class, ResManager.loadKDString((String)"\u521b\u5efa\u65e5\u671f", (String)"SysFieldHandler_3", (String)"bos-nocode-core", (Object[])new Object[0]));
    }

    public void genModifyDateField(List<EntityItem<?>> entityItems, List<EntityItem<?>> oldEntityItems) {
        this.genField(entityItems, oldEntityItems, NoCodeModifyDateField.class, ResManager.loadKDString((String)"\u4fee\u6539\u65e5\u671f", (String)"SysFieldHandler_4", (String)"bos-nocode-core", (Object[])new Object[0]));
    }

    public void genBillNoField(List<EntityItem<?>> entityItems, List<EntityItem<?>> oldEntityItems) {
        this.genField(entityItems, oldEntityItems, NoCodeBillNoField.class, ResManager.loadKDString((String)"\u7f16\u53f7", (String)"SysFieldHandler_5", (String)"bos-nocode-core", (Object[])new Object[0]));
    }

    public void mergeField(List<EntityItem<?>> entityItems, List<EntityItem<?>> oldEntityItems, Class<? extends Field<?>> clazz) {
        Optional<EntityItem> fieldOp = entityItems.stream().filter(clazz::isInstance).findFirst();
        Optional<EntityItem> oldFieldOp = oldEntityItems.stream().filter(clazz::isInstance).findFirst();
        fieldOp.ifPresent(field -> oldFieldOp.ifPresent(oldField -> {
            String fieldName = ((Field)oldField).getFieldName();
            ((Field)field).setFieldName(fieldName);
            ((Field)field).getFeatures().setCopyable(false);
        }));
    }

    public void mergeCreatorField(List<EntityItem<?>> entityItems, List<EntityItem<?>> oldEntityItems) {
        this.mergeField(entityItems, oldEntityItems, NoCodeCreatorField.class);
    }

    public void mergeModifierField(List<EntityItem<?>> entityItems, List<EntityItem<?>> oldEntityItems) {
        this.mergeField(entityItems, oldEntityItems, NoCodeModifierField.class);
    }

    public void mergeCreateDateField(List<EntityItem<?>> entityItems, List<EntityItem<?>> oldEntityItems) {
        this.mergeField(entityItems, oldEntityItems, NoCodeCreateDateField.class);
    }

    public void mergeModifyDateField(List<EntityItem<?>> entityItems, List<EntityItem<?>> oldEntityItems) {
        this.mergeField(entityItems, oldEntityItems, NoCodeModifyDateField.class);
    }

    public void mergeBillNoField(List<EntityItem<?>> entityItems, List<EntityItem<?>> oldEntityItems) {
        this.mergeField(entityItems, oldEntityItems, NoCodeBillNoField.class);
    }

    public boolean enableRecordInfo(Map<String, Object> sysSettingMap) {
        return Objects.nonNull(sysSettingMap) && Objects.nonNull(sysSettingMap.get(ElementCategoryEnum.System_CategoryRecordInfo.toString())) && (Boolean)sysSettingMap.get(ElementCategoryEnum.System_CategoryRecordInfo.toString()) != false;
    }

    public boolean enableBillNo(Map<String, Object> sysSettingMap) {
        return Objects.nonNull(sysSettingMap) && Objects.nonNull(sysSettingMap.get(ElementCategoryEnum.System_CategoryBillNo.toString())) && (Boolean)sysSettingMap.get(ElementCategoryEnum.System_CategoryBillNo.toString()) != false;
    }
}

