/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.expression;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.BOSExpressionContext;
import kd.bos.entity.formula.OutValue;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.RefBillProp;
import kd.bos.entity.property.TextAreaProp;
import kd.bos.nocode.ext.property.NoCodeAttachmentProp;
import kd.bos.nocode.ext.property.NoCodeMulRefBillProp;
import kd.bos.nocode.ext.property.NoCodeRefBillProp;
import kd.bos.nocode.ext.property.NoCodeRefBillTableProp;
import kd.bos.nocode.metadata.IDateFormatSupport;
import kd.bos.nocode.property.INoCodeRefBillProp;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import org.apache.commons.lang3.ArrayUtils;

public class NoCodeBOSExpressionContext
extends BOSExpressionContext {
    Map<String, String> varValMap = new HashMap<String, String>();

    public Map<String, String> getVarValMap() {
        return this.varValMap;
    }

    public NoCodeBOSExpressionContext(RowDataModel rowDataModel) {
        super(rowDataModel);
    }

    public Boolean tryGetValue(String key, OutValue<Object> value) {
        MulBasedataDynamicObjectCollection cols;
        MainEntityType mainEntityType = this.getRowDataModel().getMainEntityType();
        boolean flag = true;
        DynamicProperty property = mainEntityType.getProperty(key);
        if (property == null && key.contains(".")) {
            String[] fields = key.split("\\.");
            IDataEntityProperty prop = NcEntityTypeUtil.findProperty((DynamicObjectType)mainEntityType, (String)fields[0]);
            if (prop instanceof INoCodeRefBillProp) {
                INoCodeRefBillProp refBillProp = (INoCodeRefBillProp)mainEntityType.getProperty(fields[0]);
                Object sPks = "";
                if (refBillProp instanceof NoCodeMulRefBillProp) {
                    sPks = this.getRowDataModel().getValue(fields[0]);
                } else if (refBillProp instanceof RefBillProp) {
                    Object object = sPks = this.getRowDataModel().getValue(fields[0]) == null ? null : ((DynamicObject)this.getRowDataModel().getValue(fields[0])).getPkValue();
                }
                if (StringUtils.isBlank((Object)sPks)) {
                    value.set((Object)"");
                    this.varValMap.put("mulRefBillValue", "");
                    this.varValMap.put("propKey", fields[1]);
                    this.varValMap.put("billEntityId", refBillProp.getBillEntityId());
                    return true;
                }
                assert (fields.length > 1);
                if (refBillProp == null || fields == null || sPks == null || fields.length <= 1) {
                    throw new RestApiException("illegal args");
                }
                DynamicObject[] refDynObjs = refBillProp.loadRefBillObjects(sPks.toString(), fields[1]);
                StringBuilder res = new StringBuilder();
                for (DynamicObject refDynObj : refDynObjs) {
                    res.append(NcEntityTypeUtil.getOriginalValue((Object)refDynObj.get(fields[1]))).append(",");
                }
                if (res.length() > 1) {
                    res = new StringBuilder(res.substring(0, res.length() - 1));
                }
                this.varValMap.put("mulRefBillValue", sPks.toString());
                this.varValMap.put("propKey", fields[1]);
                this.varValMap.put("billEntityId", refBillProp.getBillEntityId());
                value.set((Object)res.toString());
                return true;
            }
            if (prop instanceof NoCodeRefBillTableProp) {
                NoCodeRefBillTableProp table = (NoCodeRefBillTableProp)prop;
                DynamicObjectCollection rows = (DynamicObjectCollection)this.getRowDataModel().getModel().getValue(table.getName());
                List pks = rows.stream().map(DataEntityBase::getPkValue).map(String::valueOf).collect(Collectors.toList());
                value.set((Object)String.join((CharSequence)",", pks));
                this.varValMap.put("mulRefBillValue", String.join((CharSequence)",", pks));
                INoCodeRefBillProp bill = (INoCodeRefBillProp)this.getRowDataModel().getModel().getProperty(table.getRefBillKey());
                this.varValMap.put("propKey", fields[1].substring(0, fields[1].lastIndexOf("_")));
                this.varValMap.put("billEntityId", bill.getBillEntityId());
            }
        } else {
            if (property instanceof NoCodeRefBillProp) {
                String sPks = this.getRowDataModel().getValue(key) == null ? "" : ((DynamicObject)this.getRowDataModel().getValue(key)).getPkValue();
                value.set((Object)(Objects.isNull(sPks) ? "" : sPks.toString()));
                return true;
            }
            if (property instanceof NoCodeMulRefBillProp) {
                String sPks = this.getRowDataModel().getValue(key) == null ? "" : this.getRowDataModel().getValue(key);
                value.set((Object)sPks);
                return true;
            }
            if (property instanceof TextAreaProp) {
                String text = (String)this.getRowDataModel().getValue(key);
                value.set((Object)(org.apache.commons.lang3.StringUtils.isBlank((CharSequence)text) ? "" : text.replace("\r\n", "").replace("\n", "")));
                return true;
            }
            if (property instanceof IDateFormatSupport) {
                Date date = (Date)this.getRowDataModel().getValue(key);
                value.set((Object)((IDateFormatSupport)property).getFormattedValue((Object)date));
                return true;
            }
        }
        flag = this.getRowDataModel().tryGetValue(key, value);
        if (property instanceof NoCodeAttachmentProp && (cols = (MulBasedataDynamicObjectCollection)value.get()).size() == 0) {
            value.set(null);
        }
        if (value.get() instanceof Object[]) {
            Object[] arrayValue = (Object[])value.get();
            if (ArrayUtils.isEmpty((Object[])arrayValue)) {
                value.set(null);
            } else {
                String valueStr = Arrays.stream(arrayValue).filter(Objects::nonNull).map(String::valueOf).collect(Collectors.joining(","));
                value.set((Object)valueStr);
            }
        }
        return flag;
    }
}

