/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.expression;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.formula.VarValueParser;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.entity.function.ExprFuncCreator;
import kd.bos.entity.function.FunctionManage;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.UDFunction;
import kd.bos.nocode.expression.NoCodeBOSExpressionContext;
import kd.bos.nocode.func.AttachmentFieldEnumEqFunc;
import kd.bos.nocode.func.AttachmentFieldSizeFunc;
import kd.bos.nocode.func.AttachmentFieldTypeFunc;
import kd.bos.nocode.func.ContainsAllFunc;
import kd.bos.nocode.func.NotAllContainsFunc;
import kd.bos.nocode.func.PictureFieldNameLikeFunc;
import kd.bos.nocode.utils.FuncUtil;

public class NoCodeCalcExprParser {
    private static final String SPAN_TYPE_FORMULA = "formula";
    private static final String SPAN_NAME_GETEXPRESSIONVALUE = "CalcExprParser.getExpressionValue";
    private static final String SPAN_PARAM_EXPRESSION = "expression";
    private static final String SPAN_PARAM_CTX = "ctx";
    private static final String SPAN_PARAM_RESULT = "result";

    public static Object getExpressionValue(ExpressionParameter calcParameter) {
        return NoCodeCalcExprParser.getExpressionValue(calcParameter, null);
    }

    public static Object getExpressionValue(ExpressionParameter calcParameter, Map<String, Object> ctx) {
        if (StringUtils.isBlank((CharSequence)calcParameter.getExpression())) {
            return Boolean.TRUE;
        }
        RowDataModel rowModel = calcParameter.getRowModel();
        rowModel.setRowContext(calcParameter.getActiveRow(), calcParameter.getRowIndex());
        NoCodeBOSExpressionContext expContext = new NoCodeBOSExpressionContext(rowModel);
        FunctionManage funcLib = calcParameter.getFcunLib() == null ? FuncUtil.getNoCodeFuncLib() : calcParameter.getFcunLib();
        ContainsAllFunc containsAllFunc = new ContainsAllFunc((ExpressionContext)expContext);
        NotAllContainsFunc notAllContainsFunc = new NotAllContainsFunc((ExpressionContext)expContext);
        AttachmentFieldSizeFunc attachmentFieldSizeFunc = new AttachmentFieldSizeFunc((ExpressionContext)expContext);
        AttachmentFieldEnumEqFunc attachmentFieldEnumEqFunc = new AttachmentFieldEnumEqFunc((ExpressionContext)expContext);
        AttachmentFieldTypeFunc attachmentFieldTypeFunc = new AttachmentFieldTypeFunc((ExpressionContext)expContext);
        PictureFieldNameLikeFunc pictureFieldNameLikeFunc = new PictureFieldNameLikeFunc((ExpressionContext)expContext);
        funcLib.addFunc(containsAllFunc.getName(), (BOSUDFunction)containsAllFunc);
        funcLib.addFunc(notAllContainsFunc.getName(), (BOSUDFunction)notAllContainsFunc);
        funcLib.addFunc(attachmentFieldSizeFunc.getName(), (BOSUDFunction)attachmentFieldSizeFunc);
        funcLib.addFunc(attachmentFieldTypeFunc.getName(), (BOSUDFunction)attachmentFieldTypeFunc);
        funcLib.addFunc(attachmentFieldEnumEqFunc.getName(), (BOSUDFunction)attachmentFieldEnumEqFunc);
        funcLib.addFunc(pictureFieldNameLikeFunc.getName(), (BOSUDFunction)pictureFieldNameLikeFunc);
        return NoCodeCalcExprParser.getExpressionValue(calcParameter.getBOSExpression(), (ExpressionContext)expContext, funcLib, ctx);
    }

    private static Object getExpressionValue(BOSExpression expression, ExpressionContext expContext, FunctionManage funcLib, Map<String, Object> contex) {
        if (expression == null || expression.getExpr() == null) {
            return null;
        }
        Map<String, Object> ctx = new HashMap<String, Object>();
        if (contex != null) {
            ctx.putAll(contex);
        } else {
            ctx = VarValueParser.getVarValues((BOSExpression)expression, (ExpressionContext)expContext);
        }
        BOSUDFunction[] functions = ExprFuncCreator.createUDFunctions((Set)expression.getFuncs(), (FunctionManage)funcLib, (ExpressionContext)expContext);
        try {
            Object result = FormulaEngine.execExcelFormula((Expr)expression.getExpr(), ctx, (UDFunction[])functions);
            if (EntityTracer.isRealtime()) {
                try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_FORMULA, (String)SPAN_NAME_GETEXPRESSIONVALUE);){
                    span.addTag(SPAN_PARAM_EXPRESSION, expression.getExpression());
                    span.addLocaleTag(SPAN_PARAM_CTX, ctx);
                    span.addLocaleTag(SPAN_PARAM_RESULT, result);
                }
            }
            return result;
        }
        catch (RuntimeException e) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_FORMULA, (String)SPAN_NAME_GETEXPRESSIONVALUE);){
                span.addLocaleTag(SPAN_PARAM_EXPRESSION, (Object)expression);
                span.addLocaleTag(SPAN_PARAM_CTX, ctx);
                span.throwException((Throwable)e);
            }
            throw e;
        }
    }
}

