/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.func;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.entity.plugin.support.util.ObjectUtils;
import kd.bos.entity.property.DecimalProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.expression.NoCodeBOSExpressionContext;
import kd.bos.nocode.func.CountFunc;
import kd.bos.nocode.func.DispFunc;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public abstract class AggregateFuncBase
implements BOSUDFunction {
    private static final Log LOG = LogFactory.getLog(AggregateFuncBase.class);
    private static final String algoKey = "AggregateFunc";
    public static final String OPTION_PARAMS_USE_STR_FORMAT = "#useStrFormat";
    protected ExpressionContext expContext;
    private Boolean useStrFormat = null;

    public Object call(Object ... objects) {
        String mulRefBillValue;
        String propKey;
        String billEntityId;
        if (this.expContext instanceof NoCodeBOSExpressionContext) {
            NoCodeBOSExpressionContext ctx = (NoCodeBOSExpressionContext)this.expContext;
            if (!ctx.getVarValMap().containsKey("billEntityId") && !ObjectUtils.isEmpty((Object[])objects) && objects.length == 1) {
                if (objects[0] == null) {
                    return this.calc(null);
                }
                if (" ".equals(objects[0])) {
                    if (this instanceof CountFunc || this instanceof DispFunc) {
                        return 1;
                    }
                    return this.calc(null);
                }
                Object[] values = objects[0].toString().split(",");
                if (this instanceof CountFunc || this instanceof DispFunc) {
                    return this.calc(values);
                }
                ArrayList<BigDecimal> list = new ArrayList<BigDecimal>(10);
                for (int i = 0; i < values.length; ++i) {
                    if (!StringUtils.isNotBlank((CharSequence)values[i])) continue;
                    list.add(new BigDecimal((String)values[i]));
                }
                if (list.isEmpty()) {
                    return this.calc(null);
                }
                return this.calc(list.toArray(new BigDecimal[0]));
            }
            billEntityId = ctx.getVarValMap().get("billEntityId");
            propKey = ctx.getVarValMap().get("propKey");
            mulRefBillValue = ctx.getVarValMap().get("mulRefBillValue");
        } else {
            if (ObjectUtils.isEmpty((Object[])objects) || objects.length < 3 || ObjectUtils.isEmpty((Object)objects[0]) || ObjectUtils.isEmpty((Object)objects[1]) || !(objects[0] instanceof String) || !(objects[1] instanceof String)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u9519\u8bef", (String)"AggregateFuncBase_0", (String)"bos-nocode-core", (Object[])new Object[0]));
            }
            billEntityId = (String)objects[0];
            propKey = (String)objects[1];
            StringBuilder sb = new StringBuilder();
            for (int i = 2; i < objects.length; ++i) {
                if (objects[i] == null) continue;
                if (OPTION_PARAMS_USE_STR_FORMAT.equalsIgnoreCase(objects[i].toString())) {
                    this.useStrFormat = true;
                    continue;
                }
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(objects[i].toString());
            }
            mulRefBillValue = sb.toString();
        }
        if (StringUtils.isEmpty((CharSequence)billEntityId) || StringUtils.isEmpty((CharSequence)propKey)) {
            LOG.debug("\u51fd\u6570\u4f20\u53c2\u6709\u8bef\uff1a\u53c2\u6570\u503c\u4e0d\u5bf9");
            throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u9519\u8bef", (String)"AggregateFuncBase_0", (String)"bos-nocode-core", (Object[])new Object[0]));
        }
        if (Objects.equals(billEntityId, "\"test\"")) {
            return 0;
        }
        String propKeyArgError = this.checkPropKey(billEntityId, propKey);
        if (StringUtils.isNotBlank((CharSequence)propKeyArgError)) {
            throw new KDBizException(propKeyArgError);
        }
        if (StringUtils.isEmpty((CharSequence)mulRefBillValue) || "0".equalsIgnoreCase(mulRefBillValue) || "\"1657103146553574400\"".equalsIgnoreCase(mulRefBillValue)) {
            return this.getValueWhenMulRefBillValueIsEmpty();
        }
        return this.calc(billEntityId, propKey, mulRefBillValue);
    }

    protected Object getValueWhenMulRefBillValueIsEmpty() {
        return 0;
    }

    protected String checkPropKey(String billEntityId, String propKey) {
        MainEntityType dt = NcEntityTypeUtil.getDataEntityType((String)billEntityId);
        if (dt == null) {
            return ResManager.loadKDString((String)"\u51fd\u6570\u5f15\u7528\u7684\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u786e\u8ba4\u662f\u5426\u5df2\u5220\u9664", (String)"AggregateFuncBase_1", (String)"bos-nocode-core", (Object[])new Object[0]);
        }
        IDataEntityProperty property = dt.findProperty(propKey);
        if (property == null) {
            return ResManager.loadKDString((String)"\u51fd\u6570\u5f15\u7528\u7684\u5c5e\u6027\u4e0d\u5b58\u5728\uff0c\u786e\u8ba4\u662f\u5426\u5df2\u5220\u9664", (String)"AggregateFuncBase_2", (String)"bos-nocode-core", (Object[])new Object[0]);
        }
        if (!(property instanceof DecimalProp)) {
            return ResManager.loadKDString((String)"\u51fd\u6570\u5f15\u7528\u7684\u5b57\u6bb5\u4e3a\u975e\u6570\u503c\u5b57\u6bb5\uff0c\u4e0d\u80fd\u8fd0\u7b97", (String)"AggregateFuncBase_3", (String)"bos-nocode-core", (Object[])new Object[0]);
        }
        return null;
    }

    protected DataSet getData(String billEntityId, String propKey, String mulRefBillValue) {
        String entityNumber = NcEntityTypeUtil.getRealBillEntityNumber((String)billEntityId);
        MainEntityType dt = NcEntityTypeUtil.getDataEntityType((String)billEntityId);
        List<Object> pkIds = this.getPkIds(mulRefBillValue, dt);
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", pkIds)};
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)entityNumber, (String)propKey, (QFilter[])filters, null);
    }

    protected List<Object> getPkIds(String mulRefBillValue, MainEntityType dt) {
        String[] split = mulRefBillValue.split(",");
        if (split.length < 1) {
            return null;
        }
        ArrayList<Object> pkids = new ArrayList<Object>(split.length);
        for (String s : split) {
            pkids.add(NcEntityTypeUtil.convertPKValueType((DynamicObjectType)dt, (Object)s));
        }
        return pkids;
    }

    protected abstract Object calc(String var1, String var2, String var3);

    protected abstract Object calc(Object[] var1);

    public Boolean getUseStrFormat() {
        return this.useStrFormat;
    }
}

