/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.func;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.nocode.constant.Gender;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.express.NoCodeExpCtx;
import kd.bos.nocode.expression.NoCodeExpressionContextAdapterEx;
import kd.bos.nocode.func.AggregateFuncBase;
import kd.bos.nocode.func.AggregateFuncEnum;
import kd.bos.nocode.metadata.IDateFormatSupport;
import kd.bos.nocode.property.INoCodeComboProp;
import kd.bos.nocode.property.INoCodeRefBillProp;
import kd.bos.nocode.restapi.handle.PropertyHandleUtil;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.URLCodecUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.jetbrains.annotations.NotNull;

public class DispFunc
extends AggregateFuncBase {
    public DispFunc() {
    }

    public DispFunc(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    public BOSUDFunction getInstance(ExpressionContext expContext) {
        return new DispFunc(expContext);
    }

    public ExpressionContext getExpContext() {
        return this.expContext;
    }

    public void setExpContext(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    public String getName() {
        return AggregateFuncEnum.disp.getCode();
    }

    @Override
    protected Object calc(String billEntityId, String propKey, String mulRefBillValue) {
        IDataEntityProperty assignmentProperty;
        if (StringUtils.isBlank((CharSequence)mulRefBillValue)) {
            return null;
        }
        String entityNumber = NcEntityTypeUtil.getRealBillEntityNumber((String)billEntityId);
        MainEntityType dt = NcEntityTypeUtil.getDataEntityTypeNotThrowException((String)billEntityId);
        if (dt == null) {
            return null;
        }
        List<Object> pkIds = this.getPkIds(mulRefBillValue, dt);
        if (pkIds == null) {
            return null;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", pkIds)};
        WfConsts.ExpressionCtxType expressionCtxType = this.getExpressionCtxType();
        if (this.getUseStrFormat() != null && this.getUseStrFormat().booleanValue()) {
            expressionCtxType = WfConsts.ExpressionCtxType.NOTIFY;
        }
        HashSet selectSet = Sets.newHashSet((Object[])new String[]{propKey});
        if (expressionCtxType == WfConsts.ExpressionCtxType.NOTIFY) {
            DynamicObject[] data = BusinessDataServiceHelper.load((String)entityNumber, (String)propKey, (QFilter[])filters, null);
            if (data == null || data.length == 0) {
                return null;
            }
            if (this.isCustomJson()) {
                List formatList = PropertyHandleUtil.formatCustomJsonMap((String)entityNumber, (String)"$", (DynamicObject[])data, (Set)selectSet);
                return this.getCustomJsonMultiValue(propKey, entityNumber, formatList);
            }
            List formatList = PropertyHandleUtil.toMapListRoot2RefBill((String)entityNumber, (String)"$", (DynamicObject[])data, (Set)selectSet);
            return this.getNotifyMultiValue(propKey, entityNumber, formatList);
        }
        DynamicObjectCollection data = QueryServiceHelper.query((String)entityNumber, (String)propKey, (QFilter[])filters, null);
        if (data == null || data.isEmpty()) {
            return null;
        }
        IDataEntityProperty property = NcEntityTypeUtil.findProperty((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityNumber), (String)propKey);
        List formatList = PropertyHandleUtil.toMapListRoot((String)entityNumber, (String)"$", (DynamicObject[])((DynamicObject[])data.toArray(data.toArray((Object[])new DynamicObject[0]))), (Set)selectSet);
        if (entityNumber.equalsIgnoreCase("bos_user") && selectSet.contains("gender")) {
            formatList.forEach(e -> e.put("gender", Gender.find((String)((String)e.get("gender"))).getEncodeName()));
        } else if (property instanceof IDateFormatSupport && this.isDateFormat()) {
            formatList.forEach(e -> e.put(propKey, ((IDateFormatSupport)property).getFormattedValue(e.get(propKey))));
        } else if (property instanceof INoCodeComboProp && (assignmentProperty = this.getAssignmentProperty()) != null && !(assignmentProperty instanceof INoCodeComboProp)) {
            formatList.forEach(e -> {
                if (e.get(propKey) != null) {
                    e.put(propKey, URLCodecUtils.decode((String)((String)e.get(propKey))));
                }
            });
        }
        StringBuilder sb = new StringBuilder();
        if (formatList.size() == 0) {
            return null;
        }
        if (formatList.size() == 1) {
            return ((Map)formatList.get(0)).get(propKey);
        }
        return formatList.stream().map(f -> f.get(propKey)).collect(Collectors.toList());
    }

    @NotNull
    private String getCustomJsonMultiValue(String propKey, String entityNumber, List<Map<String, Object>> formatList) {
        ArrayList<String> values = new ArrayList<String>(formatList.size());
        for (Map<String, Object> stringObjectMap : formatList) {
            String value = Optional.ofNullable(this.getNotifyValue(propKey, stringObjectMap, entityNumber)).map(Object::toString).orElse("");
            values.add(value);
        }
        return SerializationUtils.toJsonString(values);
    }

    @NotNull
    private String getNotifyMultiValue(String propKey, String entityNumber, List<Map<String, Object>> formatList) {
        StringBuilder sb = new StringBuilder();
        for (Map<String, Object> stringObjectMap : formatList) {
            Object val = this.getNotifyValue(propKey, stringObjectMap, entityNumber);
            if (val == null) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(val);
        }
        return sb.toString();
    }

    private Object getNotifyValue(String propKey, Map<String, Object> stringObjectMap, String entityNumber) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Object o = stringObjectMap.get(propKey);
        if (this.isCondition() && NcEntityTypeUtil.findProperty((DynamicObjectType)dt, (String)propKey) instanceof INoCodeRefBillProp) {
            o = stringObjectMap.get(this.appendId(propKey));
        }
        return o;
    }

    private String appendId(String propKey) {
        if (propKey.endsWith(".id") || propKey.endsWith("_id")) {
            return propKey;
        }
        return propKey + ".id";
    }

    @Override
    protected Object getValueWhenMulRefBillValueIsEmpty() {
        return "";
    }

    @Override
    protected String checkPropKey(String billEntityId, String propKey) {
        return null;
    }

    private WfConsts.ExpressionCtxType getExpressionCtxType() {
        if (this.getExpContext() instanceof NoCodeExpressionContextAdapterEx) {
            return ((NoCodeExpressionContextAdapterEx)this.getExpContext()).getCtxType();
        }
        return WfConsts.ExpressionCtxType.DEFAULT;
    }

    private IDataEntityProperty getAssignmentProperty() {
        if (this.getExpContext() instanceof NoCodeExpressionContextAdapterEx) {
            return (IDataEntityProperty)((NoCodeExpressionContextAdapterEx)this.getExpContext()).getNcCtx().getCustomParam().get("_assignmentProperty");
        }
        return null;
    }

    private boolean isDateFormat() {
        if (this.getExpContext() instanceof NoCodeExpressionContextAdapterEx) {
            NoCodeExpCtx ncCtx = ((NoCodeExpressionContextAdapterEx)this.getExpContext()).getNcCtx();
            return Optional.ofNullable(ncCtx).map(NoCodeExpCtx::getCustomParam).map(e -> (Boolean)e.get("isFormatDate")).orElse(false);
        }
        return false;
    }

    private boolean isCondition() {
        if (this.getExpContext() instanceof NoCodeExpressionContextAdapterEx) {
            NoCodeExpCtx ncCtx = ((NoCodeExpressionContextAdapterEx)this.getExpContext()).getNcCtx();
            return Optional.ofNullable(ncCtx).map(NoCodeExpCtx::getCustomParam).map(e -> (Boolean)e.get("condition")).orElse(false);
        }
        return false;
    }

    private boolean isCustomJson() {
        if (this.getExpContext() instanceof NoCodeExpressionContextAdapterEx) {
            NoCodeExpCtx ncCtx = ((NoCodeExpressionContextAdapterEx)this.getExpContext()).getNcCtx();
            return Optional.ofNullable(ncCtx).map(NoCodeExpCtx::getCustomParam).map(e -> (Boolean)e.get("parseCustomJsonVariable")).orElse(false);
        }
        return false;
    }

    @Override
    public Object calc(Object[] params) {
        if (params == null) {
            return 0;
        }
        return params.length;
    }
}

