/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.mvc;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDefValueProvider;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.rule.RuleContainer;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.converter.FormMetadataConverter;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.form.FormDataModel;
import kd.bos.nocode.NoCodeBillShowParameter;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.ext.defvalue.NoCodeFormDefValueProvider;
import kd.bos.nocode.ext.metadata.form.NoCodeBillFormAp;
import kd.bos.nocode.ext.metadata.form.control.NoCodeFieldAp;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeUserInput;
import kd.bos.nocode.ext.property.NoCodeRefBillTableProp;
import kd.bos.nocode.mvc.NoCodeBillModel;
import kd.bos.nocode.rule.NoCodeFormRuleContainer;
import kd.bos.nocode.util.FieldRequiredValidateUtil;
import kd.bos.nocode.utils.FuncPermItemEnum;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.workflow.NoCodeWorkflowServiceHelper;
import kd.bos.threads.ThreadPools;

public class NoCodeBillView
extends BillView {
    private static final Log logger = LogFactory.getLog(NoCodeBillView.class);
    private static final String BOS_FORM_METADATA = "bos-form-metadata";
    private static final String OPERATOR_KEY_DELETE = "delete";

    protected void initiService() {
        super.initiService();
        this.addService(IDefValueProvider.class, new NoCodeFormDefValueProvider((IFormView)this));
        this.addService(RuleContainer.class, (Object)new NoCodeFormRuleContainer((IFormView)this));
    }

    protected FormDataModel createDataModel() {
        NoCodeBillModel model = new NoCodeBillModel(this.getEntityId(), this.getPageId(), this.services);
        return model;
    }

    public void updateView() {
        String statusStr = this.getPageCache().get("currentStatus");
        if (StringUtils.isNotBlank((CharSequence)statusStr)) {
            super.updateView();
            return;
        }
        HashMap<String, Integer> currentStatus = new HashMap<String, Integer>(16);
        String id = NcEntityTypeUtil.getRealBillEntityId((String)this.getEntityId());
        Map designerMetadata = MetadataDao.loadDesignerMetadata((String)id, (String)RequestContext.get().getLang().toString());
        FormMetadataConverter converter = new FormMetadataConverter();
        FormMetadata metadata = (FormMetadata)converter.convertTo(designerMetadata);
        List controlAps = metadata.getItems();
        for (ControlAp ap : controlAps) {
            if (ap instanceof NoCodeBillFormAp) continue;
            String status = ap instanceof NoCodeFieldAp ? ((NoCodeFieldAp)ap).getStatus() : (ap.getCustomProperties().get("Status") == null ? "1" : (String)ap.getCustomProperties().get("Status"));
            currentStatus.put(ap.getKey(), Integer.parseInt(status));
        }
        if (!currentStatus.isEmpty()) {
            this.getPageCache().put("currentStatus", SerializationUtils.toJsonString(currentStatus));
        }
        super.updateView();
    }

    public void showOperationResult(OperationResult operationResult, String operateName) {
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        int size = errorInfos.size() + operationResult.getSuccessPkIds().size();
        if (size > 1) {
            this.showOperationResult_Multi(operationResult, operateName);
        } else {
            super.showOperationResult(operationResult, operateName);
        }
    }

    private void showOperationResult_Multi(OperationResult operationResult, String operateName) {
        List errorOrValidateInfos = operationResult.getAllErrorOrValidateInfo();
        if (!errorOrValidateInfos.isEmpty()) {
            StringBuilder sbErrors = new StringBuilder();
            boolean bHasError = false;
            for (IOperateInfo errorOrValidateInfo : errorOrValidateInfos) {
                if (errorOrValidateInfo instanceof OperateErrorInfo) {
                    OperateErrorInfo errorInfo = (OperateErrorInfo)errorOrValidateInfo;
                    if (errorInfo.getLevel() == ErrorLevel.Error) {
                        bHasError = true;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)errorInfo.getMessage())) continue;
                    if (sbErrors.length() > 0) {
                        sbErrors.append("\n");
                    }
                    sbErrors.append(errorInfo.getMessage());
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)errorOrValidateInfo.getMessage())) continue;
                if (sbErrors.length() > 0) {
                    sbErrors.append("\n");
                }
                sbErrors.append(errorOrValidateInfo.getMessage());
            }
            if (sbErrors.length() > 40 && this.getFormShowParameter().getOpenStyle().getShowType() == ShowType.Modal) {
                this.showMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"NoCodeBillView_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]), sbErrors.toString(), MessageTypes.Default);
            } else if (bHasError) {
                this.showErrorNotification(sbErrors.toString());
            } else {
                String errorString = sbErrors.toString().replace("\n", ";");
                this.showTipNotification(errorString, 5000);
            }
        } else if (!operationResult.isSuccess()) {
            String msg;
            String string = msg = operationResult.getMessage() == null ? "" : operationResult.getMessage();
            if (msg.length() > 40 && this.getFormShowParameter().getOpenStyle().getShowType() == ShowType.Modal) {
                this.showMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"NoCodeBillView_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]), operationResult.getMessage(), MessageTypes.Default);
            } else {
                this.showErrorNotification(operationResult.getMessage());
            }
        } else {
            this.showSuccessNotification(operationResult.getMessage(), 5000);
        }
    }

    protected FormOperate getOperation(String operationKey) {
        FormOperate operation = super.getOperation(operationKey);
        if (OPERATOR_KEY_DELETE.equalsIgnoreCase(operation.getOperateKey())) {
            operation.setConfirmTypes(ConfirmTypes.Default);
            operation.getParameter().put("sourceName", "MessageCallBackType");
        }
        if ("save".equalsIgnoreCase(operationKey)) {
            this.setSaveSuccessMsg(operation);
        }
        return operation;
    }

    private void setSaveSuccessMsg(FormOperate operation) {
        Field successMsgField = ReflectionUtils.findField(operation.getClass(), (String)"successMsg");
        if (successMsgField != null) {
            successMsgField.setAccessible(true);
            try {
                if (OperationStatus.EDIT == this.getStatus()) {
                    successMsgField.set(operation, new LocaleString(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"NoCodeBillView_1", (String)"bos-nocode-core", (Object[])new Object[0])));
                } else {
                    successMsgField.set(operation, new LocaleString(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"NoCodeBillView_2", (String)"bos-nocode-core", (Object[])new Object[0])));
                }
            }
            catch (IllegalAccessException e) {
                logger.warn((Throwable)e);
            }
        }
    }

    public OperationResult invokeOperation(String operationKey, OperateOption option) {
        String sError;
        boolean isSaving;
        if ("next".equalsIgnoreCase(operationKey)) {
            OperationResult result = new OperationResult();
            result.setSuccess(true);
            return result;
        }
        boolean isFormExist = this.checkRefTableFormExist(operationKey);
        if (!isFormExist) {
            this.showErrorNotification(ResManager.loadKDString((String)"\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664", (String)"NoCodeRefBillEdit_5", (String)"bos-nocode-ext", (Object[])new Object[0]));
            OperationResult result = new OperationResult();
            result.setSuccess(false);
            return result;
        }
        FieldRequiredValidateUtil fieldRequiredValidateUtil = new FieldRequiredValidateUtil((IFormView)this, operationKey.toLowerCase());
        Tuple<Boolean, OperationResult> tuple = fieldRequiredValidateUtil.doValidate(option);
        if (!((Boolean)tuple.item1).booleanValue()) {
            this.showOperationResult((OperationResult)tuple.item2, fieldRequiredValidateUtil.getOpName());
            return (OperationResult)tuple.item2;
        }
        boolean bl = isSaving = "save".equalsIgnoreCase(operationKey) || "saveandnew".equalsIgnoreCase(operationKey);
        if (isSaving && StringUtils.isNotBlank((CharSequence)(sError = NcEntityTypeUtil.checkRecordCount((String)this.getFormId(), (int)1)))) {
            OperationResult result = new OperationResult();
            result.setSuccess(false);
            result.addErrorInfo((OperateErrorInfo)new ValidationErrorInfo("", null, 0, 0, "001", this.getOperation(operationKey).getOperateName().toString(), sError, ErrorLevel.FatalError));
            this.showOperationResult(result, operationKey);
            return result;
        }
        boolean check = this.checkRefTableInputFunc(operationKey);
        if (!check) {
            this.showErrorNotification(ResManager.loadKDString((String)"\u6743\u9650\u4e0d\u8db3", (String)"NoCodeBillView_3", (String)"bos-nocode-core", (Object[])new Object[0]));
            OperationResult result = new OperationResult();
            result.setSuccess(false);
            return result;
        }
        boolean checkRefTable = this.checkRefTableData(operationKey);
        if (!checkRefTable) {
            OperationResult result = new OperationResult();
            result.addErrorInfo((OperateErrorInfo)new ValidationErrorInfo("", null, 0, 0, "001", this.getOperation(operationKey).getOperateName().toString(), ResManager.loadKDString((String)"\u5355\u6761\u6a21\u5f0f\u4e0b\u6700\u591a\u53ea\u80fd\u6dfb\u52a0\u4e00\u6761\u8bb0\u5f55\uff01", (String)"NoCodeBillView_4", (String)"bos-nocode-core", (Object[])new Object[0]), ErrorLevel.FatalError));
            this.showOperationResult(result, operationKey);
            return result;
        }
        if ("save".equals(operationKey)) {
            this.getFormShowParameter().setCustomParam("ignoreRules", (Object)"true");
        }
        try {
            OperationResult result = super.invokeOperation(operationKey, option);
            if (isSaving) {
                this.invokeOperation_save(result, option);
            }
            return result;
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            OperationResult result = new OperationResult();
            result.setSuccess(false);
            if (ex.getMessage().contains("value too long for type character varying(140)")) {
                result.addErrorInfo((OperateErrorInfo)new ValidationErrorInfo("", null, 0, 0, "001", this.getOperation(operationKey).getOperateName().toString(), ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u5c1d\u8bd5\u5728\u8868\u5355\u8bbe\u8ba1\u5668\u4e2d\uff0c\u628a\u6240\u6709\u591a\u884c\u6587\u672c\u7684\u6700\u5927\u957f\u5ea6\u6539\u5927\u540e\u518d\u53d1\u5e03", (String)"NoCodeBillView_5", (String)"bos-nocode-core", (Object[])new Object[0]), ErrorLevel.FatalError));
                this.showOperationResult(result, operationKey);
                return result;
            }
            return result;
        }
    }

    private boolean checkRefTableFormExist(String operationKey) {
        FormOperate operate = this.getOperation(operationKey);
        if (operate instanceof NewEntry) {
            NoCodeRefBillTableProp prop;
            String entryId = (String)operate.getParameter().get("entryId");
            IDataEntityProperty property = this.getModel().getProperty(entryId);
            if (property instanceof NoCodeRefBillTableProp && !NcEntityTypeUtil.isFormExist((String)(prop = (NoCodeRefBillTableProp)property).getBillEntityIdEx())) {
                return false;
            }
        }
        return true;
    }

    private boolean checkRefTableInputFunc(String operationKey) {
        FormOperate operate = this.getOperation(operationKey);
        if (operate instanceof NewEntry) {
            this.getFormShowParameter().setCustomParam("ignoreRules", (Object)"true");
            String entryId = (String)operate.getParameter().get("entryId");
            IDataEntityProperty property = this.getModel().getProperty(entryId);
            if (property instanceof NoCodeRefBillTableProp) {
                NoCodeRefBillTableProp prop = (NoCodeRefBillTableProp)property;
                if ("1".equals(prop.getSourceForm())) {
                    return true;
                }
                return NoCodePermHelper.checkFuncPermInNoCode((FuncPermItemEnum)FuncPermItemEnum.input, (String)prop.getBillEntityIdEx());
            }
        }
        return true;
    }

    private boolean checkRefTableData(String operationKey) {
        FormOperate operate = this.getOperation(operationKey);
        if (operate instanceof NewEntry) {
            String entryId = (String)operate.getParameter().get("entryId");
            IDataEntityProperty property = this.getModel().getProperty(entryId);
            if (property instanceof NoCodeRefBillTableProp) {
                NoCodeRefBillTableProp prop = (NoCodeRefBillTableProp)property;
                if (prop.getMulti() == 1) {
                    return true;
                }
                int size = this.getModel().getEntryRowCount(entryId);
                if (size >= 1) {
                    return false;
                }
            }
        }
        return true;
    }

    protected OperationResult invokeOperation_save(OperationResult result, OperateOption option) {
        if (result.getSuccessPkIds() == null || result.getSuccessPkIds().isEmpty()) {
            return result;
        }
        String formNumber = NcEntityTypeUtil.getRealBillEntityNumber((String)this.getFormId());
        Object billPk = result.getSuccessPkIds().get(0);
        this.triggerProcess(formNumber, billPk);
        return result;
    }

    private void triggerProcess(String entityNumber, Object billPk) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || billPk == null) {
            return;
        }
        NoCodeWfNodeUserInput userInputNode = this.getUserInputNode();
        if (userInputNode == null) {
            String triggerMode = this.getTriggerMode();
            ThreadPools.executeOnce((String)"nocode_triggerProcess", () -> {
                try {
                    NoCodeWorkflowServiceHelper.tryTriggerProcessByTriggerMode((String)entityNumber, (String)billPk.toString(), (String)triggerMode);
                }
                catch (Exception e) {
                    logger.warn((Throwable)e);
                }
            });
        } else {
            this.triggerProcessFromUserInputNode(userInputNode, billPk);
        }
    }

    private NoCodeWfNodeUserInput getUserInputNode() {
        IFormView billContainerView = this.getBillContainer((IFormView)this);
        if (billContainerView == null) {
            return null;
        }
        String noCodeWfNodeUserInputStr = billContainerView.getPageCache().get("NoCodeWfNodeUserInput");
        if (StringUtils.isNotBlank((CharSequence)noCodeWfNodeUserInputStr)) {
            return (NoCodeWfNodeUserInput)SerializationUtils.fromJsonString((String)noCodeWfNodeUserInputStr, NoCodeWfNodeUserInput.class);
        }
        return null;
    }

    private void triggerProcessFromUserInputNode(NoCodeWfNodeUserInput userInputNode, Object billPk) {
        String[] procs;
        if (userInputNode == null || StringUtils.isBlank((CharSequence)userInputNode.getTriggerProcess()) || billPk == null) {
            return;
        }
        for (String proc : procs = userInputNode.getTriggerProcess().split(",")) {
            Long modelId = Long.parseLong(proc);
            ThreadPools.executeOnce((String)"nocode_triggerProcessFromUserInputNode", () -> {
                try {
                    NoCodeWorkflowServiceHelper.tryTriggerProcess((Long)modelId, (String)billPk.toString(), (String)"bizOperate");
                }
                catch (Exception e) {
                    logger.warn((Throwable)e);
                }
            });
        }
    }

    protected String getTriggerMode() {
        NoCodeBillShowParameter formShowParameter = (NoCodeBillShowParameter)this.getFormShowParameter();
        switch (formShowParameter.getNocodeBillStatus()) {
            case EDIT: {
                return WfConsts.FireTypeEnum.EDITSUBMIT.getCode();
            }
            case ADDNEW: {
                return WfConsts.FireTypeEnum.NEWSUBMIT.getCode();
            }
        }
        return WfConsts.FireTypeEnum.NEWANDEDITSUBMIT.getCode();
    }

    public void setStatus(OperationStatus value) {
        super.setStatus(value);
        switch (value) {
            case ADDNEW: {
                this.setBillStatus(BillOperationStatus.ADDNEW);
                break;
            }
            case EDIT: {
                this.setBillStatus(BillOperationStatus.EDIT);
                break;
            }
            default: {
                this.setBillStatus(BillOperationStatus.VIEW);
            }
        }
    }

    private IFormView getBillContainer(IFormView view) {
        if (view == null) {
            return null;
        }
        if ("bos_nocode_bill".equalsIgnoreCase(view.getEntityId())) {
            return view;
        }
        return this.getBillContainer(view.getParentView());
    }

    public void showErrMessage(String msg, String title) {
        super.showErrorNotification(msg);
    }
}

