/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.mservice.NoCodeFilterService;
import kd.bos.nocode.restapi.RestApiWrap;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiRequest;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiQuerySingleResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.api.sys.SysServiceFormId;
import kd.bos.nocode.restapi.common.constant.ApiVersion;
import kd.bos.nocode.restapi.common.constant.HttpMethod;
import kd.bos.nocode.restapi.common.constant.OperationType;
import kd.bos.nocode.restapi.common.util.JsonUtil;
import kd.bos.nocode.servicehelper.DispatchApiServiceHelper;
import kd.bos.nocode.servicehelper.ServiceFactory;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.url.UrlService;
import org.apache.commons.collections4.CollectionUtils;

public class RestApiWrapImpl
implements RestApiWrap {
    private static final Log logger = LogFactory.getLog(RestApiWrapImpl.class);
    private static final String PARAM_KEY_FILTER = "filter";
    private static final String PARAM_KEY_RAW_FILTER = "rawFilter";
    private static final String PARAM_KEY_SEARCH = "search";
    private static final String PARAM_KEY_ORDER_BY = "order_by";
    private static final String PARAM_KEY_SELECT = "select";
    private static final String PARAM_KEY_PAGE_SIZE = "page_size";
    private static final String PARAM_KEY_PAGE_NO = "page_no";
    private static final String PARAM_KEY_SELECTEDIDS = "ids";
    private static final int DEFAULT_PAGE_SIZE = 20;
    private static final int INITIAL_CAPACITY = 10;
    public static final String FROM_DESIGNER = "fromdesigner";
    public static final String APPID = "appid";
    public static final String FORMID = "formid";
    public static final String DEFAULT_FILTER_ROWS = "defaultFilterRows";

    public Map<String, Object> query(String formId, Map<String, Object> param) {
        Object obj;
        List rawFilter;
        String realFormId = NcEntityTypeUtil.getRealBillEntityId((String)formId);
        String appId = FormMetaUtil.getAppIdByFormId((String)realFormId);
        String realFormNumber = NcEntityTypeUtil.getRealBillEntityNumber((String)realFormId);
        int pageSize = 20;
        if (param.containsKey(PARAM_KEY_PAGE_SIZE)) {
            Object pageSizeObj = param.get(PARAM_KEY_PAGE_SIZE);
            pageSize = pageSizeObj instanceof Integer ? (Integer)pageSizeObj : Integer.parseInt(pageSizeObj.toString());
        }
        int pageNo = 1;
        if (param.containsKey(PARAM_KEY_PAGE_NO)) {
            Object pageNoObj = param.get(PARAM_KEY_PAGE_NO);
            pageNo = pageNoObj instanceof Integer ? (Integer)pageNoObj : Integer.parseInt(pageNoObj.toString());
        }
        String search = "";
        if (param.containsKey(PARAM_KEY_SEARCH)) {
            search = (String)param.get(PARAM_KEY_SEARCH);
        }
        String filter = "";
        if (param.containsKey(PARAM_KEY_FILTER)) {
            filter = (String)param.get(PARAM_KEY_FILTER);
        }
        if (StringUtils.isEmpty((CharSequence)filter) && param.containsKey(PARAM_KEY_RAW_FILTER) && CollectionUtils.isNotEmpty((Collection)(rawFilter = (List)param.getOrDefault(PARAM_KEY_RAW_FILTER, Lists.newArrayList())))) {
            NoCodeFilterService noCodeFilterService = (NoCodeFilterService)ServiceFactory.getService((String)"NoCodeFilterService");
            filter = noCodeFilterService.getFilterStr(formId, rawFilter);
        }
        String orderBy = "";
        if (param.containsKey(PARAM_KEY_ORDER_BY)) {
            orderBy = (String)param.get(PARAM_KEY_ORDER_BY);
        }
        String select = "";
        if (param.containsKey(PARAM_KEY_SELECT)) {
            select = (String)param.get(PARAM_KEY_SELECT);
        }
        String queryStr = String.format("?page_size=%s&page_no=%s&order_by=%s", pageSize, pageNo, orderBy);
        if (StringUtils.isNotBlank((CharSequence)search)) {
            queryStr = queryStr + "&search=" + search;
        }
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            queryStr = queryStr + "&filter=" + filter;
        }
        if (StringUtils.isNotBlank((CharSequence)select)) {
            queryStr = queryStr + "&select=" + select;
        }
        HashMap reqData = new HashMap(10);
        reqData.put("data", new HashMap(10));
        String rootUrl = UrlService.getDomainContextUrl();
        String apiUrl = String.format("nocode/v2/%s/%s/%s", appId, realFormNumber, queryStr);
        String fullRequestUrl = String.format("%s%s", rootUrl, apiUrl);
        HashMap<String, String> queryStringMap = new HashMap<String, String>(0);
        queryStringMap.put(PARAM_KEY_SEARCH, search);
        queryStringMap.put(FROM_DESIGNER, "true");
        HashMap reqHeaders = new HashMap(16);
        RestApiRequest request = new RestApiRequest(fullRequestUrl, apiUrl, queryStringMap, OperationType.QUERY, HttpMethod.GET, ApiVersion.TWO, appId, realFormNumber, reqData, reqHeaders, filter);
        RestApiQueryParam queryParam = new RestApiQueryParam(request);
        queryParam.setFormId(realFormNumber);
        queryParam.setAppNumber(appId);
        queryParam.setPage_size(pageSize);
        queryParam.setPage_no(pageNo);
        queryParam.setOrder_by(orderBy);
        if (StringUtils.isNotBlank((CharSequence)select)) {
            String[] splitFields = select.split(",");
            HashSet selectSet = new HashSet(splitFields.length);
            Collections.addAll(selectSet, splitFields);
            queryParam.setSelect(selectSet);
        }
        if (param.containsKey(PARAM_KEY_SELECTEDIDS) && (obj = param.get(PARAM_KEY_SELECTEDIDS)) instanceof List) {
            List ids = (List)obj;
            queryParam.setSelectedIds(ids);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        RestApiQueryResult data = (RestApiQueryResult)this.invokeRestApiQuery(queryParam).getResponse().getData();
        if (data != null) {
            data.setPageNo(pageNo);
            data.setPageSize(pageSize);
            result.put("data", JsonUtil.parseJson2Map((String)JsonUtil.format((Object)data)));
        }
        return result;
    }

    public Map<String, Object> listConfig(String formId, Map<String, Object> param) {
        String realFormId = NcEntityTypeUtil.getRealBillEntityId((String)formId);
        String realFormNumber = NcEntityTypeUtil.getRealBillEntityNumber((String)formId);
        String appId = FormMetaUtil.getAppIdByFormId((String)realFormId);
        String queryStr = String.format("?appid=%s&formid=%s&env=1", appId, realFormNumber);
        HashMap reqData = new HashMap(10);
        reqData.put("data", new HashMap(10));
        String rootUrl = UrlService.getDomainContextUrl();
        String apiUrl = String.format("/nocode/v2/nocode_sys/common/list_config/common/query%s", queryStr);
        String fullRequestUrl = String.format("%s%s", rootUrl, apiUrl);
        HashMap<String, String> queryStringMap = new HashMap<String, String>(0);
        queryStringMap.put("appId", appId);
        queryStringMap.put("formId", realFormNumber);
        queryStringMap.put("env", "1");
        queryStringMap.put(FROM_DESIGNER, "true");
        HashMap reqHeaders = new HashMap(16);
        RestApiRequest request = new RestApiRequest(fullRequestUrl, apiUrl, queryStringMap, OperationType.QUERY, HttpMethod.GET, ApiVersion.TWO, appId, SysServiceFormId.COMMON.getName(), reqData, reqHeaders, "");
        RestApiQueryParam queryParam = new RestApiQueryParam(request);
        queryParam.setFormId(SysServiceFormId.COMMON.getName());
        queryParam.setAppNumber(appId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        RestApiQueryResult data = (RestApiQueryResult)this.invokeRestApiQuery(queryParam).getResponse().getData();
        if (data != null) {
            result.put("data", data);
        }
        return result;
    }

    public Map<String, Object> getFilterItemLook(String formId, Map<String, Object> param) {
        formId = NcEntityTypeUtil.getRealBillEntityId((String)formId);
        String enumField = (String)param.get("enumField");
        String queryStr = String.format("?getEnumData=true&enumField=%s", enumField);
        String appId = FormMetaUtil.getAppIdByFormId((String)formId);
        HashMap reqData = new HashMap(10);
        HashMap<String, Object> data = new HashMap<String, Object>(10);
        data.put(APPID, appId);
        data.put(FORMID, formId);
        data.put("filterrows", param.get("filterrows"));
        data.put(DEFAULT_FILTER_ROWS, param.get(DEFAULT_FILTER_ROWS));
        reqData.put("data", data);
        String rootUrl = UrlService.getDomainContextUrl();
        String apiUrl = String.format("/nocode/v2/nocode_sys/bos_nocode_filterconfig%s", queryStr);
        String fullRequestUrl = String.format("%s%s", rootUrl, apiUrl);
        HashMap<String, String> queryStringMap = new HashMap<String, String>(0);
        queryStringMap.put("getEnumData", "true");
        queryStringMap.put("enumField", enumField);
        HashMap reqHeaders = new HashMap(16);
        RestApiRequest request = new RestApiRequest(fullRequestUrl, apiUrl, queryStringMap, OperationType.QUERY, HttpMethod.POST, ApiVersion.TWO, appId, "bos_nocode_filterconfig", reqData, reqHeaders, "");
        RestApiSaveParam saveParam = new RestApiSaveParam(request);
        saveParam.setFormId("bos_nocode_filterconfig");
        saveParam.setAppNumber("nocode_sys");
        ArrayList dataList = Lists.newArrayList((Object[])new Map[]{data});
        saveParam.setDataList((List)dataList);
        HashMap<String, Object> result = new HashMap<String, Object>();
        RestApiQueryResult resultData = (RestApiQueryResult)this.invokeRestApiSave(saveParam).getResponse().getData();
        if (resultData != null) {
            result.put("data", resultData);
        }
        return result;
    }

    public Map<String, Object> getHeadFieldFilterItem(String formId, Map<String, Object> param) {
        formId = NcEntityTypeUtil.getRealBillEntityId((String)formId);
        String headField = (String)param.get("headField");
        String appId = FormMetaUtil.getAppIdByFormId((String)formId);
        String queryStr = String.format("?appid=%s&formid=%s&env=1&head_field=%s", appId, formId, headField);
        String rootUrl = UrlService.getDomainContextUrl();
        String apiUrl = String.format("/nocode/v2/nocode_sys/bos_nocode_filterconfig%s", queryStr);
        String fullRequestUrl = String.format("%s%s", rootUrl, apiUrl);
        HashMap<String, String> queryStringMap = new HashMap<String, String>(0);
        queryStringMap.put(APPID, appId);
        queryStringMap.put(FORMID, formId);
        queryStringMap.put("env", "1");
        queryStringMap.put(FROM_DESIGNER, "true");
        queryStringMap.put("head_field", headField);
        HashMap<String, Object> reqData = new HashMap<String, Object>(10);
        reqData.put(PARAM_KEY_FILTER, "");
        reqData.put("filterRows", param.get("filterRows"));
        reqData.put(DEFAULT_FILTER_ROWS, param.get(DEFAULT_FILTER_ROWS));
        HashMap reqHeaders = new HashMap(16);
        RestApiRequest request = new RestApiRequest(fullRequestUrl, apiUrl, queryStringMap, OperationType.QUERY, HttpMethod.GET, ApiVersion.TWO, appId, SysServiceFormId.COMMON.getName(), reqData, reqHeaders, "");
        RestApiQueryParam queryParam = new RestApiQueryParam(request);
        queryParam.setFormId(SysServiceFormId.FILTER_CONFIG.getName());
        queryParam.setAppNumber(appId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        RestApiQueryResult data = (RestApiQueryResult)this.invokeRestApiQuery(queryParam).getResponse().getData();
        if (data != null) {
            result.put("data", data);
        }
        return result;
    }

    public Map<String, Object> getSvgLine() {
        String appId = "nocode_sys";
        String rootUrl = UrlService.getDomainContextUrl();
        String apiUrl = "/nocode/v2/nocode_sys/common/svgs/line";
        String fullRequestUrl = String.format("%s%s", rootUrl, apiUrl);
        RestApiRequest request = new RestApiRequest(fullRequestUrl, apiUrl, new HashMap(), OperationType.QUERY, HttpMethod.GET, ApiVersion.TWO, appId, SysServiceFormId.COMMON.getName(), new HashMap(), new HashMap(16), "");
        RestApiQueryParam queryParam = new RestApiQueryParam(request);
        queryParam.setFormId("common");
        queryParam.setAppNumber(appId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        RestApiQuerySingleResult data = (RestApiQuerySingleResult)this.invokeRestApiSingleQuery(queryParam).getResponse().getData();
        if (data != null) {
            result.put("data", data);
        }
        return result;
    }

    public Map<String, Object> getEntryData(Map<String, Object> param) {
        String appId = (String)param.get("appId");
        String formId = (String)param.get("formId");
        String pkId = (String)param.get("pkId");
        int pageSize = (Integer)param.get("pageSize");
        int pageNo = (Integer)param.get("pageNo");
        String entry = (String)param.get("entry");
        String apiUrl = String.format("/nocode/v2/%s/%s/%s?page_size=%d&page_no=%d&entry=%s", appId, formId, pkId, pageSize, pageNo, entry);
        String rootUrl = UrlService.getDomainContextUrl();
        String fullRequestUrl = String.format("%s%s", rootUrl, apiUrl);
        HashMap httpQueryString = new HashMap(16);
        param.forEach((k, v) -> {
            if (v instanceof String) {
                httpQueryString.put(k, (String)v);
            } else {
                httpQueryString.put(k, v.toString());
            }
        });
        RestApiRequest request = new RestApiRequest(fullRequestUrl, apiUrl, httpQueryString, OperationType.QUERY, HttpMethod.GET, ApiVersion.TWO, appId, formId, new HashMap(), new HashMap(16), "");
        RestApiQueryParam queryParam = new RestApiQueryParam(request);
        queryParam.setFormId(formId);
        queryParam.setAppNumber(appId);
        queryParam.getRequest().setFilter("id EQ " + pkId);
        queryParam.setPage_no(pageNo);
        queryParam.setPage_size(pageSize);
        HashMap<String, Object> result = new HashMap<String, Object>();
        RestApiQueryResult data = (RestApiQueryResult)this.invokeRestApiQuery(queryParam).getResponse().getData();
        if (data != null) {
            result.put("data", data);
        }
        return result;
    }

    private RestApiServiceData<RestApiQuerySingleResult> invokeRestApiSingleQuery(RestApiQueryParam param) {
        return (RestApiServiceData)DispatchApiServiceHelper.invokeApiService((String)QueryRestApiService.class.getSimpleName(), (Object[])new Object[]{param});
    }

    private RestApiServiceData<RestApiQueryResult> invokeRestApiQuery(RestApiQueryParam param) {
        RestApiServiceData queryResult = (RestApiServiceData)DispatchApiServiceHelper.invokeApiService((String)QueryRestApiService.class.getSimpleName(), (Object[])new Object[]{param});
        if (param.isDyObjResult()) {
            return queryResult;
        }
        try {
            ((RestApiQueryResult)queryResult.getResponse().getData()).setRows(((RestApiQueryResult)queryResult.getResponse().getData()).getRows());
        }
        catch (Exception e) {
            logger.debug("set rows failed", (Object)e);
        }
        return queryResult;
    }

    private RestApiServiceData<RestApiQueryResult> invokeRestApiSave(RestApiSaveParam param) {
        RestApiServiceData queryResult = (RestApiServiceData)DispatchApiServiceHelper.invokeApiService((String)SaveRestApiService.class.getSimpleName(), (Object[])new Object[]{param});
        try {
            ((RestApiQueryResult)queryResult.getResponse().getData()).setRows(((RestApiQueryResult)queryResult.getResponse().getData()).getRows());
        }
        catch (Exception e) {
            logger.debug("set rows failed", (Object)e);
        }
        return queryResult;
    }
}

