/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.action.operation;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.action.operation.upper.AbstractEntryRestApiOperation;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiRequest;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.DataUtil;
import kd.bos.nocode.servicehelper.DispatchApiServiceHelper;

public class RestApiQuery
extends AbstractEntryRestApiOperation<RestApiQueryResult> {
    public static final int MAX_PAGE_SIZE = 1000;
    public static final int DEFAULT_PAGE_SIZE = 20;
    private static final Log logger = LogFactory.getLog(RestApiQuery.class);
    private int pageSize;
    private int pageNo;

    public RestApiQuery(RestApiRequest<Map<String, Object>> request) {
        super(request);
        Map httpQueryString = request.getHttpQueryString();
        Object page_no = httpQueryString.get("page_no");
        if (page_no != null) {
            try {
                this.pageNo = DataUtil.i(page_no);
            }
            catch (Exception e) {
                throw new RestApiException(ResManager.loadKDString((String)"\u9875\u7801pageNo\u5fc5\u987b\u662f\u5927\u4e8e0\u7684\u6b63\u6574\u6570", (String)"RestApiQuery_0", (String)"bos-nocode-core", (Object[])new Object[0]));
            }
            if (this.pageNo <= 0) {
                throw new RestApiException(ResManager.loadKDString((String)"\u9875\u7801pageNo\u5fc5\u987b\u662f\u5927\u4e8e0\u7684\u6b63\u6574\u6570", (String)"RestApiQuery_0", (String)"bos-nocode-core", (Object[])new Object[0]));
            }
        } else {
            this.pageNo = 1;
        }
        this.pageSize = 20;
        Object pageSizeObj = httpQueryString.get("page_size");
        if (pageSizeObj != null) {
            try {
                this.pageSize = DataUtil.i(pageSizeObj);
            }
            catch (Exception e) {
                throw new RestApiException(ResManager.loadKDString((String)"\u9875\u5927\u5c0fpage_size\u7684\u53d6\u503c\u8303\u56f4\u662f[%1$s, %2$s]\u7684\u6b63\u6574\u6570", (String)"RestApiQuery_1", (String)"bos-nocode-core", (Object[])new Object[0]), new Object[]{1, 1000});
            }
            if (this.pageSize < 1 || this.pageSize > 1000) {
                throw new RestApiException(ResManager.loadKDString((String)"\u9875\u5927\u5c0fpage_size\u7684\u53d6\u503c\u8303\u56f4\u662f[%1$s, %2$s]\u7684\u6b63\u6574\u6570", (String)"RestApiQuery_1", (String)"bos-nocode-core", (Object[])new Object[0]), new Object[]{1, 1000});
            }
        }
    }

    @Override
    public RestApiServiceData<RestApiQueryResult> invoke() {
        String dynObj;
        Map httpQueryString;
        String orderBy;
        RestApiQueryParam param = new RestApiQueryParam(this.request);
        param.setApiVersion(this.request.getApiVersion());
        param.setAppNumber(this.request.getAppNumber());
        param.setFormId(this.request.getFormId());
        param.setFormNumber("");
        param.setSelectedIds(this.request.getIds());
        Map requestHeaders = this.request.getRequestHeaders();
        if (requestHeaders != null) {
            for (Map.Entry entry : requestHeaders.entrySet()) {
                if (!((String)entry.getKey()).equalsIgnoreCase("noCodeShareId")) continue;
                param.setShareId((String)entry.getValue());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(orderBy = (String)(httpQueryString = this.request.getHttpQueryString()).get("order_by")))) {
            param.setOrder_by(orderBy);
        }
        param.setPage_size(this.pageSize);
        param.setPage_no(this.pageNo);
        String select = (String)httpQueryString.get("select");
        if (StringUtils.isNotBlank((CharSequence)select)) {
            String[] splitFields = select.split(",");
            HashSet selectSet = new HashSet(splitFields.length);
            Collections.addAll(selectSet, splitFields);
            param.setSelect(selectSet);
        }
        if (StringUtils.isNotBlank((CharSequence)(dynObj = (String)httpQueryString.get("dynobj"))) && Boolean.parseBoolean(dynObj)) {
            param.setDyObjResult(true);
        } else {
            param.setDyObjResult(false);
        }
        param.getRequest().getHttpQueryString().put("fromListSchema", Boolean.TRUE.toString());
        return (RestApiServiceData)DispatchApiServiceHelper.invokeApiService((String)QueryRestApiService.class.getSimpleName(), (Object[])new Object[]{param});
    }
}

