/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;

public class DynamicObjectUtil {
    private DynamicObjectUtil() {
    }

    public static List<Map<String, Object>> serializeToMap(DynamicObject[] objects, DynamicObjectType dt) {
        if (objects == null || objects.length == 0) {
            return Collections.emptyList();
        }
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(dt);
        binder.setOnlyDbProperty(false);
        DcJsonSerializer jsr = new DcJsonSerializer((DcBinder)binder);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(objects.length);
        for (DynamicObject object : objects) {
            Map map = jsr.serializeToMap((Object)object, null);
            list.add(map);
        }
        return list;
    }

    public static Map<String, Object> serializeToMap(DynamicObject object, DynamicObjectType dt) {
        if (object == null) {
            return Collections.emptyMap();
        }
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(dt);
        binder.setOnlyDbProperty(false);
        DcJsonSerializer jsr = new DcJsonSerializer((DcBinder)binder);
        return jsr.serializeToMap((Object)object, null);
    }

    public static List<DynamicObject> deserializeFromMap(List<Map<String, Object>> objects, DynamicObjectType dt) {
        if (objects == null || objects.isEmpty()) {
            return Collections.emptyList();
        }
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(dt);
        binder.setOnlyDbProperty(false);
        DcJsonSerializer jsr = new DcJsonSerializer((DcBinder)binder);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(objects.size());
        for (Map<String, Object> object : objects) {
            DynamicObject dynamicObject = (DynamicObject)jsr.deserializeFromMap(object, null);
            list.add(dynamicObject);
        }
        return list;
    }
}

