/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.id.ID;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.NoCodeAction;
import kd.bos.nocode.restapi.action.operation.RestApiExecute;
import kd.bos.nocode.restapi.api.DirectRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiRequest;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.api.result.RestApiServiceResult;
import kd.bos.nocode.restapi.common.constant.ApiVersion;
import kd.bos.nocode.restapi.common.constant.HttpMethod;
import kd.bos.nocode.restapi.common.util.Pair;
import kd.bos.nocode.restapi.common.util.StringUtil;
import kd.bos.nocode.restapi.servlet.context.ParameterHelper;
import kd.bos.nocode.restapi.servlet.context.RestApiContext;
import kd.bos.nocode.restapi.servlet.result.ResultProcessUtil;
import kd.bos.nocode.utils.NcRetryUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.reporter.apicall.APICallTagInject;
import kd.bos.trace.reporter.topology.TopologyTagInject;
import kd.bos.url.UrlService;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.NetAddressUtils;

public class NoCodeServlet
extends HttpServlet {
    private static final long serialVersionUID = 183748932942092L;
    private static final Log LOG = LogFactory.getLog(NoCodeServlet.class);
    private final String localIp = NetAddressUtils.getLocalIpAddress();
    private static final Long licenseGroupId = 640L;

    public void doGet(HttpServletRequest req, HttpServletResponse resp) {
        this.doAction(req, resp, HttpMethod.GET);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
        this.doAction(req, resp, HttpMethod.POST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAction(HttpServletRequest req, HttpServletResponse resp, HttpMethod method) {
        block25: {
            try (TraceSpan traceSpan = Tracer.create((String)"nocode", (String)req.getRequestURI());){
                RequestContext current = RequestContext.get();
                if (current != null) {
                    String destAppId = req.getHeader("cqappid");
                    TopologyTagInject.setWebTag((InnerSpan)traceSpan.getInnerSpan(), (String)TopologyTagInject.getClient((String)current.getClient()), (String)destAppId);
                    APICallTagInject.setHttpTag((InnerSpan)traceSpan.getInnerSpan(), (String)req.getRemoteAddr(), (String)this.localIp, (String)"http", (String)req.getRequestURI(), (String)destAppId);
                }
                if (this.isApi(req)) {
                    String apiUrl = ParameterHelper.getApiUrl(req);
                    RestApiContext apiContext = new RestApiContext(req, resp, apiUrl);
                    apiContext.setMethod(method);
                    RestApiContext.set(apiContext);
                    try {
                        ParameterHelper.processParameter();
                        Pair<Boolean, DirectRestApiService> isDirect = ParameterHelper.isDirectRequest(apiUrl);
                        RestApiRequest<Map<String, Object>> restApiRequest = ParameterHelper.getRestApiRequest();
                        if (((Boolean)isDirect.getKey()).booleanValue()) {
                            DirectRestApiService ins = (DirectRestApiService)isDirect.getValue();
                            Method m = ins.getClass().getMethod("execute", RestApiParam.class);
                            m.setAccessible(true);
                            m.invoke((Object)ins, new RestApiParam(restApiRequest));
                        } else if (restApiRequest.getUrl().endsWith("/perm/manage")) {
                            RestApiServiceData result = (RestApiServiceData)NcRetryUtil.withRetry(() -> RestApiExecute.execute(restApiRequest), (int)5, r -> {
                                RestApiQueryResult data = (RestApiQueryResult)r.getResponse().getData();
                                if (data == null || data.getRows().size() == 0) {
                                    return false;
                                }
                                Map set = (Map)data.getRows().get(0);
                                return (Boolean)set.get("use") != false || (Boolean)set.get("manage") != false;
                            });
                            ResultProcessUtil.processResult((RestApiServiceData<RestApiServiceResult>)result, req);
                        } else {
                            RestApiServiceData<RestApiServiceResult> result = RestApiExecute.execute(restApiRequest);
                            ResultProcessUtil.processResult(result, req);
                        }
                        break block25;
                    }
                    catch (Exception ex) {
                        LOG.warn((Throwable)ex);
                        RestApiContext.getContext().setException(ex);
                        ResultProcessUtil.processException(req);
                        break block25;
                    }
                    finally {
                        RestApiContext.close();
                    }
                }
                if (NoCodeAction.isActionCall(req)) {
                    NoCodeAction.doAction(req, resp);
                } else {
                    NoCodeServlet.doHistory(req, resp);
                }
            }
        }
    }

    private boolean isApi(HttpServletRequest req) {
        String apiUrl = ParameterHelper.getApiUrl(req);
        if (apiUrl.startsWith("/")) {
            apiUrl = apiUrl.substring(1);
        }
        if (!apiUrl.endsWith("/")) {
            apiUrl = apiUrl + "/";
        }
        return apiUrl.startsWith(ApiVersion.TWO.getName()) || apiUrl.startsWith(ApiVersion.ONE.getName());
    }

    public static void doHistory(HttpServletRequest req, HttpServletResponse servletResponse) {
        servletResponse.setContentType("text/html");
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)servletResponse.getOutputStream(), StandardCharsets.UTF_8);){
            boolean hasLis = NoCodeServlet.hasLicense(req);
            if (!hasLis) {
                LOG.debug("nocode license userid:" + RequestContext.get().getCurrUserId());
            }
            writer.write(hasLis ? NoCodeServlet.getNocodeIndexHtml(req) : NoCodeServlet.getNoLicenseHtml(req));
            writer.flush();
        }
        catch (IOException e) {
            LOG.debug(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    private static boolean hasLicense(HttpServletRequest req) {
        String[] split;
        String shareId;
        if (req.getRequestURI().indexOf("/share/") != -1 && NoCodePermHelper.isValidShareId((String)(shareId = (split = req.getRequestURI().split("/share/"))[split.length - 1]))) {
            return true;
        }
        boolean dev = "tenant_devcore_dev".equals(RequestContext.get().getTenantId());
        if (dev) {
            return true;
        }
        LicenseCheckResult licenseCheckResult = LicenseServiceHelper.checkUserInGroup((Long)RequestContext.get().getCurrUserId(), (Long)licenseGroupId);
        return licenseCheckResult.getHasLicense();
    }

    public static String getNocodeIndexHtml(HttpServletRequest request) {
        boolean debug = "true".equalsIgnoreCase(request.getParameter("kdweb_debug"));
        String cdn = StringUtil.cleanXSSContent((String)request.getParameter("kdweb_cdn"));
        String domainUrl = UrlService.getDomainContextUrl();
        StringBuilder sb = new StringBuilder();
        sb.append("<!DOCTYPE html>");
        sb.append("<html lang=\"en\">");
        sb.append("<head>");
        sb.append("    <meta charset=\"UTF-8\">");
        sb.append("    <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">");
        sb.append("    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no\">");
        sb.append("    <link rel=\"icon\" href=\"").append(NoCodeServlet.getRelaRoot(domainUrl)).append("/public/thirdjs/image/favicon.ico\" type=\"image/x-icon\">");
        sb.append(ResManager.loadKDString((String)"    <title>\u65e0\u4ee3\u7801\u5e73\u53f0</title>", (String)"NoCodeServlet_0", (String)"bos-nocode-core", (Object[])new Object[0]));
        sb.append("    <script>");
        if (StringUtils.isNotBlank((CharSequence)cdn)) {
            sb.append("     window.__kd_cdnPath__ = '").append(cdn).append("';");
        }
        if (debug) {
            sb.append("     window.__kd_debug__ = true;");
        }
        sb.append("     window.__kd_nocode_userid__ = '").append(NoCodeServlet.getCurrentUserId()).append("';");
        sb.append("     window.__kd_nocode_tenantid__ = '").append(NoCodeServlet.getTenantId()).append("';");
        sb.append("    </script>");
        sb.append("    <script src=\"").append(NoCodeServlet.getRelaRoot(domainUrl)).append("/ncp").append("/nocode/js/startup.js?v=").append(Long.toString(ID.genLongId())).append("\"></script>");
        sb.append("</head>");
        sb.append("<body>");
        sb.append("  <div id=\"app\"></div>");
        sb.append("</body>");
        sb.append("</html>");
        return sb.toString();
    }

    public static String getNoLicenseHtml(HttpServletRequest request) {
        String domainUrl = UrlService.getDomainContextUrl();
        String relaRoot = NoCodeServlet.getRelaRoot(domainUrl);
        StringBuilder sb = new StringBuilder();
        sb.append("<!DOCTYPE html>");
        sb.append("<html lang=\"en\">");
        sb.append("<head>");
        sb.append("    <meta charset=\"UTF-8\">");
        sb.append("    <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">");
        sb.append("    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no\">");
        sb.append("    <link rel=\"icon\" href=\"").append(relaRoot).append("/public/thirdjs/image/favicon.ico\" type=\"image/x-icon\">");
        sb.append(ResManager.loadKDString((String)"    <title>\u65e0\u4ee3\u7801\u5e73\u53f0</title>", (String)"NoCodeServlet_0", (String)"bos-nocode-core", (Object[])new Object[0]));
        sb.append("  <style>");
        sb.append("    html, body, div{ padding: 0; margin: 0; font-size: 14px; height: 100%; }");
        sb.append("    div{ background-color:#F8FAFC; display: flex; justify-content: center; align-items: center; flex-direction: column; }");
        sb.append("  </style>");
        sb.append("</head>");
        sb.append("<body>");
        sb.append("  <div>");
        sb.append("    <img src=\"").append(relaRoot).append("/ncp/images/noPermission.png\" width=\"224\" height=\"128\" alt=\"\">");
        sb.append(ResManager.loadKDString((String)"    <p> \u6ca1\u6709\u8bb8\u53ef </p>", (String)"NoCodeServlet_1", (String)"bos-nocode-core", (Object[])new Object[0]));
        sb.append("  </div>");
        sb.append("</body>");
        sb.append("</html>");
        return sb.toString();
    }

    private static String getCurrentUserId() {
        if (RequestContext.get() == null) {
            return "";
        }
        return String.valueOf(RequestContext.get().getCurrUserId());
    }

    private static String getTenantId() {
        if (RequestContext.get() == null) {
            return "";
        }
        return String.valueOf(RequestContext.get().getTenantId());
    }

    private static String getRelaRoot(String domainUrl) {
        if (domainUrl == null) {
            return null;
        }
        String url = domainUrl.replace("http://", "").replace("https://", "");
        String[] split = url.split("/");
        if (split.length == 1) {
            return "";
        }
        return "/" + split[split.length - 1];
    }
}

