/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.servlet.context;

import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.api.DirectRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiRequest;
import kd.bos.nocode.restapi.api.sys.SysServiceFormId;
import kd.bos.nocode.restapi.common.constant.ApiVersion;
import kd.bos.nocode.restapi.common.constant.HttpMethod;
import kd.bos.nocode.restapi.common.constant.OperationType;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.result.RestApiFile;
import kd.bos.nocode.restapi.common.util.CollectionUtil;
import kd.bos.nocode.restapi.common.util.DataUtil;
import kd.bos.nocode.restapi.common.util.Pair;
import kd.bos.nocode.restapi.common.util.StringUtil;
import kd.bos.nocode.restapi.servlet.context.RestApiContext;
import kd.bos.nocode.restapi.servlet.utils.ApiStreamUtil;
import kd.bos.nocode.restapi.servlet.utils.ApiUtil;
import kd.bos.nocode.util.OpenApiAliasHelper;
import kd.bos.nocode.utils.URLCodecUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class ParameterHelper {
    private static final Log log = LogFactory.getLog(ParameterHelper.class);
    private static final Set<String> directSet = new HashSet<String>();
    private static final List<DirectRestApiService> insFactory;

    private ParameterHelper() {
    }

    public static Map<String, Object> getRequestParameter() {
        try {
            Map<String, Object> requestData = (Map<String, Object>)RestApiContext.contextMap().get("Request.Arg0");
            if (requestData == null) {
                requestData = ParameterHelper.getQueryParameter(RestApiContext.contextMap());
            }
            return requestData;
        }
        catch (Exception ex) {
            throw new RestApiException(RestApiErrorCode.HTTP_BAD_REQUEST.getStatusCode(), "An error occurred while getting the request parameters: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public static void processParameter() {
        try {
            HttpServletRequest request = RestApiContext.getRequest();
            request.setCharacterEncoding("UTF-8");
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                ParameterHelper.getMultipartContent(request);
            } else if (ParameterHelper.isCommmonParameter(request)) {
                ParameterHelper.getFormContent(request);
            } else {
                ParameterHelper.getInputStreamContent(request);
            }
        }
        catch (Exception ex) {
            throw new RestApiException(RestApiErrorCode.HTTP_BAD_REQUEST.getStatusCode(), "An error occurred while getting the request parameters: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public static void getFormContent(HttpServletRequest request) {
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String fieldName = (String)paramNames.nextElement();
            Object[] fieldValues = request.getParameterValues(fieldName);
            if (CollectionUtil.isEmpty((Object[])fieldValues)) continue;
            if (fieldValues.length == 1) {
                Object fieldValue = fieldValues[0];
                RestApiContext.addParameter(fieldName, fieldValue);
                continue;
            }
            RestApiContext.addParameter(fieldName, fieldValues);
        }
        return;
    }

    public static void getInputStreamContent(HttpServletRequest request) throws IOException {
        String str;
        StringBuilder sb = new StringBuilder();
        ServletInputStream is = request.getInputStream();
        InputStreamReader isr = new InputStreamReader((InputStream)is);
        BufferedReader br = new BufferedReader(isr);
        while ((str = br.readLine()) != null) {
            sb.append(str);
            sb.append("\r\n");
        }
        String data = sb.toString();
        RestApiContext.setInputParameter(data);
        Object paraValue = ParameterHelper.getXMLJsonData(data);
        RestApiContext.addParameter("Request.Arg0", paraValue);
    }

    public static void getMultipartContent(HttpServletRequest request) throws FileUploadException, IOException {
        DiskFileItemFactory diskFilefactoy = new DiskFileItemFactory();
        ServletFileUpload sfu = new ServletFileUpload((FileItemFactory)diskFilefactoy);
        List list = sfu.parseRequest(request);
        for (FileItem fileItem : list) {
            String sFieldName = StringUtil.cleanXSSParam((String)fileItem.getFieldName());
            String name = StringUtil.cleanXSSParam((String)fileItem.getName());
            if (fileItem.isFormField()) {
                String charset = request.getCharacterEncoding();
                String value = charset != null ? fileItem.getString(charset) : fileItem.getString();
                value = StringUtil.cleanXSSParam((String)value);
                RestApiContext.addParameter(sFieldName, value);
                continue;
            }
            if (!StringUtil.isNotEmpty((String)name)) continue;
            byte[] fileData = ApiStreamUtil.getBytesByFileItem(fileItem);
            RestApiFile fileInfo = new RestApiFile(name, fileItem.getContentType(), false, fileData);
            RestApiContext.setData(sFieldName, fileInfo);
        }
    }

    public static boolean isCommmonParameter(HttpServletRequest request) {
        if ("GET".equalsIgnoreCase(request.getMethod())) {
            return true;
        }
        return ParameterHelper.getHeader(request, "Content-Type").startsWith("application/x-www-form-urlencoded");
    }

    private static String getHeader(HttpServletRequest request, String key) {
        if (request == null) {
            return "";
        }
        String value = request.getHeader(key);
        return value == null ? "" : value;
    }

    public static Map<String, Object> getQueryParaWithoutDataNode(Map<String, Object> requestData) {
        HashMap<String, Object> para = new HashMap<String, Object>(requestData.size());
        for (Map.Entry<String, Object> entry : requestData.entrySet()) {
            para.put(entry.getKey(), entry.getValue());
        }
        return para;
    }

    public static Map<String, Object> getQueryParameter(Map<String, Object> requestData) {
        HashMap<String, Object> para = new HashMap<String, Object>(10);
        HashMap<String, Object> data = new HashMap<String, Object>(10);
        para.put("data", data);
        for (Map.Entry<String, Object> entry : requestData.entrySet()) {
            if (entry.getKey().equals("page_no")) {
                para.put("page_no", DataUtil.i((Object)entry.getValue()));
                continue;
            }
            if (entry.getKey().equals("page_size")) {
                para.put("page_size", DataUtil.i((Object)entry.getValue()));
                continue;
            }
            if (entry.getKey().equals("select")) {
                para.put("select", DataUtil.s((Object)entry.getValue()));
                continue;
            }
            if (entry.getKey().equals("order_by")) {
                para.put("order_by", DataUtil.s((Object)entry.getValue()));
                continue;
            }
            if (entry.getKey().equals("dynobj")) {
                para.put("dynobj", DataUtil.x((Object)entry.getValue()));
                continue;
            }
            data.put(entry.getKey(), entry.getValue());
        }
        ParameterHelper.parseUrl2data(data);
        return para;
    }

    private static void parseUrl2data(Map<String, Object> data) {
        Pair<String, String> queryParam;
        if (ParameterHelper.isDeleteWithId()) {
            Pair<String, String> deleteParam = ParameterHelper.pareUrlToParamterDelete();
            if (deleteParam.getKey() != null && deleteParam.getValue() != null) {
                data.put((String)deleteParam.getKey(), deleteParam.getValue());
            }
        } else if (ParameterHelper.isQueryWithId() && (queryParam = ParameterHelper.pareUrlToParamterQuery()).getKey() != null && queryParam.getValue() != null) {
            data.put((String)queryParam.getKey(), queryParam.getValue());
        }
    }

    private static void parseUrl2QueryStringMap(Map<String, String> data) {
        Pair<String, String> queryParam;
        if (ParameterHelper.isDeleteWithId()) {
            Pair<String, String> deleteParam = ParameterHelper.pareUrlToParamterDelete();
            if (deleteParam.getKey() != null && deleteParam.getValue() != null) {
                data.put((String)deleteParam.getKey(), (String)deleteParam.getValue());
            }
        } else if (ParameterHelper.isQueryWithId() && (queryParam = ParameterHelper.pareUrlToParamterQuery()).getKey() != null && queryParam.getValue() != null) {
            data.put((String)queryParam.getKey(), (String)queryParam.getValue());
        }
    }

    public static Map<String, String> getHttpHeaders(HttpServletRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>(16);
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                headers.put(headerName, request.getHeader(headerName));
            }
        }
        return headers;
    }

    public static void setResponseHeaders(HttpServletResponse response, Map<String, String> headers) {
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                response.setHeader(header.getKey(), header.getValue());
            }
        }
    }

    public static RestApiRequest<Map<String, Object>> getRestApiRequest() {
        Map<String, Object> reqData = ParameterHelper.getRequestParameter();
        HttpServletRequest request = RestApiContext.getRequest();
        RestApiContext context = RestApiContext.getContext();
        String fullRequestUrl = RestApiContext.getRequest().getRequestURL().toString();
        String apiUrl = ParameterHelper.getApiUrl(request);
        String formId = ParameterHelper.getFormIdFromApiUrl(apiUrl);
        SysServiceFormId parsedFormId = SysServiceFormId.parse((String)(formId = OpenApiAliasHelper.getFormIdByFormAlias(formId)));
        if (parsedFormId != SysServiceFormId.NONE) {
            formId = parsedFormId.getName();
        }
        String appId = ParameterHelper.getAppIdFromApiUrl(apiUrl);
        ApiVersion apiVersion = ParameterHelper.getAppVersionFromApiUrl(apiUrl);
        Map<String, String> queryStringMap = ParameterHelper.getQueryStringMap();
        Map<String, String> reqHeaders = ParameterHelper.getHttpHeaders(RestApiContext.getRequest());
        OperationType operationType = null;
        String filter = ParameterHelper.getFilter(context, queryStringMap, reqData);
        List<String> selectedIds = ParameterHelper.getSelectedIds(context, queryStringMap, reqData);
        if (context.getMethod().compareTo((Enum)HttpMethod.GET) == 0) {
            operationType = OperationType.QUERY;
            if (ParameterHelper.isTreeQuery()) {
                operationType = OperationType.TREE_QUERY;
            }
        } else if (context.getMethod().compareTo((Enum)HttpMethod.POST) == 0) {
            if (ParameterHelper.isDelete()) {
                operationType = OperationType.DELETE;
            } else if (ParameterHelper.isBatch()) {
                operationType = OperationType.BATCH;
            } else if ("image".equalsIgnoreCase(formId)) {
                operationType = OperationType.IMAGE;
            } else if ("attachment".equalsIgnoreCase(formId)) {
                operationType = OperationType.ATTACHMENT;
            } else if (ParameterHelper.isPostQuery(reqData)) {
                operationType = OperationType.QUERY;
                if (ParameterHelper.isTreeQuery()) {
                    operationType = OperationType.TREE_QUERY;
                }
            } else {
                operationType = ParameterHelper.isPrint() ? OperationType.PRINT : OperationType.SAVE;
            }
        }
        RestApiRequest restApiRequest = new RestApiRequest(fullRequestUrl, apiUrl, queryStringMap, operationType, context.getMethod(), apiVersion, appId, formId, reqData, reqHeaders, filter);
        restApiRequest.setIds(selectedIds);
        return restApiRequest;
    }

    private static List<String> getSelectedIds(RestApiContext context, Map<String, String> queryStringMap, Map<String, Object> reqData) {
        List selectedIds;
        if (reqData != null && context.getMethod().compareTo((Enum)HttpMethod.POST) == 0 && CollectionUtils.isNotEmpty((Collection)(selectedIds = (List)reqData.get("ids")))) {
            return selectedIds;
        }
        return new ArrayList<String>(0);
    }

    private static boolean isBatch() {
        RestApiContext context = RestApiContext.getContext();
        if (context.getMethod().compareTo((Enum)HttpMethod.POST) != 0) {
            return false;
        }
        String restApiDataUrl = context.getUrl();
        String[] paths = StringUtils.split((String)restApiDataUrl, (String)"/");
        if (paths.length < 4) {
            return false;
        }
        return "batch".equalsIgnoreCase(paths[3]);
    }

    private static boolean isPrint() {
        RestApiContext context = RestApiContext.getContext();
        String restApiDataUrl = context.getUrl();
        String[] paths = StringUtils.split((String)restApiDataUrl, (String)"/");
        if (paths.length < 4) {
            return false;
        }
        return "print".equalsIgnoreCase(paths[3]);
    }

    public static boolean isPostQuery(Map<String, Object> reqData) {
        return reqData.containsKey("filter");
    }

    public static Map<String, String> getQueryStringMap() {
        Map<String, String> queryStringMap = ParameterHelper.getQueryStringMap(RestApiContext.getRequest().getQueryString());
        ParameterHelper.parseUrl2QueryStringMap(queryStringMap);
        return queryStringMap;
    }

    public static Map<String, String> getQueryStringMap(String queryString) {
        if (StringUtil.isEmpty((String)queryString)) {
            return new HashMap<String, String>(0);
        }
        String[] split = queryString.split("&");
        HashMap<String, String> result = new HashMap<String, String>(split.length);
        for (String s : split) {
            String[] strings = s.split("=", 2);
            if (strings.length == 1 && StringUtil.isEmpty((String)strings[0]) || strings.length > 1 && StringUtil.isEmpty((String)strings[0]) && StringUtil.isEmpty((String)strings[1])) continue;
            if (strings.length == 1) {
                result.put(strings[0], null);
                continue;
            }
            String string1 = strings[1];
            string1 = URLCodecUtils.decode((String)string1);
            result.put(strings[0], string1);
        }
        return result;
    }

    public static String getFilter(RestApiContext context, Map<String, String> queryStringMap, Map<String, Object> reqData) {
        Pair<String, String> queryParam;
        String filter = "";
        if (context.getMethod().compareTo((Enum)HttpMethod.GET) == 0 && queryStringMap.containsKey("filter")) {
            filter = queryStringMap.get("filter");
        }
        if (reqData != null && context.getMethod().compareTo((Enum)HttpMethod.POST) == 0 && StringUtils.isEmpty((CharSequence)(filter = queryStringMap.containsKey("filter") ? queryStringMap.get("filter") : (String)reqData.get("filter")))) {
            filter = (String)reqData.get("filters");
        }
        if (Objects.isNull(filter)) {
            filter = "";
        }
        if (ParameterHelper.isDeleteWithId()) {
            Pair<String, String> deleteParam = ParameterHelper.pareUrlToParamterDelete();
            if (deleteParam.getKey() != null && deleteParam.getValue() != null) {
                filter = filter + " " + (String)deleteParam.getKey() + " EQ " + (String)deleteParam.getValue();
            }
        } else if (ParameterHelper.isQueryWithId() && (queryParam = ParameterHelper.pareUrlToParamterQuery()).getKey() != null && queryParam.getValue() != null) {
            filter = filter + " " + (String)queryParam.getKey() + " EQ " + (String)queryParam.getValue();
        }
        return filter;
    }

    public static boolean isDelete() {
        RestApiContext context = RestApiContext.getContext();
        if (context.getMethod().compareTo((Enum)HttpMethod.POST) != 0) {
            return false;
        }
        String restApiDataUrl = context.getUrl();
        String[] paths = StringUtils.split((String)restApiDataUrl, (String)"/");
        if (paths.length < 4) {
            return false;
        }
        return "delete".equalsIgnoreCase(paths[3]);
    }

    public static boolean isTreeQuery() {
        RestApiContext context = RestApiContext.getContext();
        if (context.getMethod().compareTo((Enum)HttpMethod.GET) != 0) {
            return false;
        }
        String restApiDataUrl = context.getUrl();
        String[] paths = StringUtils.split((String)restApiDataUrl, (String)"/");
        if (paths.length < 4) {
            return false;
        }
        return "tree".equalsIgnoreCase(paths[3]);
    }

    public static boolean isDeleteWithId() {
        RestApiContext context = RestApiContext.getContext();
        if (context.getMethod().compareTo((Enum)HttpMethod.POST) != 0) {
            return false;
        }
        String restApiDataUrl = context.getUrl();
        String[] paths = StringUtils.split((String)restApiDataUrl, (String)"/");
        if (paths.length < 5) {
            return false;
        }
        return "delete".equalsIgnoreCase(paths[3]);
    }

    public static boolean isQueryWithId() {
        RestApiContext context = RestApiContext.getContext();
        if (context.getMethod().compareTo((Enum)HttpMethod.GET) != 0) {
            return false;
        }
        String restApiDataUrl = context.getUrl();
        if (restApiDataUrl.contains("common") || restApiDataUrl.contains("form_auth")) {
            return false;
        }
        String[] paths = StringUtils.split((String)restApiDataUrl, (String)"/");
        return paths.length == 4;
    }

    private static Pair<String, String> pareUrlToParamterDelete() {
        RestApiContext context = RestApiContext.getContext();
        String restApiDataUrl = context.getUrl();
        String[] paths = StringUtils.split((String)restApiDataUrl, (String)"/");
        if (paths.length < 5 || context.getMethod().compareTo((Enum)HttpMethod.POST) != 0) {
            return new Pair(null, null);
        }
        return new Pair((Object)"id", (Object)paths[4]);
    }

    private static Pair<String, String> pareUrlToParamterQuery() {
        RestApiContext context = RestApiContext.getContext();
        String restApiDataUrl = context.getUrl();
        String[] paths = StringUtils.split((String)restApiDataUrl, (String)"/");
        if (paths.length != 4 || context.getMethod().compareTo((Enum)HttpMethod.GET) != 0) {
            return new Pair(null, null);
        }
        return new Pair((Object)"id", (Object)paths[3]);
    }

    private static Object getXMLJsonData(String objValue) {
        String result = null;
        try {
            result = ApiUtil.isContentType("application/json") ? JSON.parseObject((String)objValue) : objValue;
        }
        catch (Exception ex) {
            throw new RestApiException(RestApiErrorCode.HTTP_BAD_REQUEST.getStatusCode(), "JSON/XML data is invalid - " + ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    public static String getApiUrl(HttpServletRequest req) {
        return ParameterHelper.getApiRequestUri(req);
    }

    public static ApiVersion getAppVersionFromApiUrl(String apiUrl) {
        if (StringUtil.isEmpty((String)apiUrl)) {
            return ApiVersion.TWO;
        }
        String[] paths = StringUtils.split((String)apiUrl, (String)"/");
        if (paths.length < 3) {
            return ApiVersion.TWO;
        }
        return ApiVersion.getApiVersion((String)paths[0]);
    }

    public static String getAppIdFromApiUrl(String apiUrl) {
        if (StringUtil.isEmpty((String)apiUrl)) {
            return "";
        }
        String[] paths = StringUtils.split((String)apiUrl, (String)"/");
        if (paths.length < 3) {
            return "";
        }
        return paths[1];
    }

    public static String getFormIdFromApiUrl(String apiUrl) {
        if (StringUtil.isEmpty((String)apiUrl)) {
            return "";
        }
        String[] paths = StringUtils.split((String)apiUrl, (String)"/");
        if (paths.length < 3) {
            return "";
        }
        String path = paths[2];
        if (StringUtils.isNotBlank((CharSequence)path) && path.indexOf(",") > 0) {
            String[] split = path.split(",");
            return split[split.length - 1];
        }
        return path;
    }

    private static String getApiRequestUri(HttpServletRequest req) {
        String contextPath = req.getContextPath() + "/nocode";
        String requestURI = req.getRequestURI();
        return requestURI.substring(contextPath.length());
    }

    public static Pair<Boolean, DirectRestApiService> isDirectRequest(String url) {
        for (DirectRestApiService i : insFactory) {
            if (!i.match(url)) continue;
            return new Pair((Object)true, (Object)i);
        }
        return new Pair((Object)false, null);
    }

    static {
        directSet.add("kd.bos.nocode.restapi.service.sys.common.IconServiceQueryImpl");
        directSet.add("kd.bos.nocode.restapi.service.sys.AppExportServiceImpl");
        insFactory = directSet.stream().map(c -> {
            try {
                return (DirectRestApiService)Class.forName(c).newInstance();
            }
            catch (Exception e) {
                log.warn((Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

