/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.servlet.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.common.constant.HttpMethod;
import kd.bos.nocode.restapi.common.result.RestApiResult;
import kd.bos.nocode.restapi.servlet.result.StreamData;

public class RestApiContext {
    private static Log log = LogFactory.getLog(RestApiContext.class);
    private static final ThreadLocal<RestApiContext> threadLocal = new ThreadLocal();
    private HttpServletRequest request;
    private HttpServletResponse response;
    private Map<String, Object> contextMap = new HashMap<String, Object>(10);
    private ArrayList<String> parametersList = new ArrayList(10);
    private RestApiResult restApiResult;
    private String url;
    private Throwable exception;
    private int modelTimeCost;
    private String inputParameter;
    private String outputParameter;
    private HttpMethod method;

    public RestApiContext(HttpServletRequest request, HttpServletResponse response, String url) {
        this.request = request;
        this.response = response;
        this.url = url;
        this.restApiResult = new RestApiResult();
    }

    public static void addParameter(String key, Object value) {
        RestApiContext context = RestApiContext.getContext();
        if (context != null) {
            context.parametersList.add(key);
            context.put(key, value);
        }
    }

    public static List<String> getParameters() {
        RestApiContext restApiContext = RestApiContext.getContext();
        return restApiContext != null ? restApiContext.parametersList : null;
    }

    public static void set(RestApiContext restApiContext) {
        threadLocal.set(restApiContext);
    }

    public static RestApiContext getContext() {
        return threadLocal.get();
    }

    public static HttpServletRequest getRequest() {
        RestApiContext restApiContext = RestApiContext.getContext();
        return restApiContext != null ? restApiContext.request : null;
    }

    public static RestApiResult getResult() {
        RestApiContext restApiContext = RestApiContext.getContext();
        return restApiContext != null ? restApiContext.restApiResult : new RestApiResult();
    }

    public static HttpServletResponse getResponse() {
        RestApiContext restApiContext = RestApiContext.getContext();
        return restApiContext != null ? restApiContext.response : null;
    }

    public static void setStreamData(StreamData streamData) {
        RestApiContext restApiContext = RestApiContext.getContext();
        if (restApiContext != null) {
            restApiContext.put("RestApi.StreamData", streamData);
        }
    }

    public static StreamData getStreamData() {
        RestApiContext restApiContext = RestApiContext.getContext();
        return (StreamData)(restApiContext != null ? restApiContext.get("RestApi.StreamData") : null);
    }

    public static Map<String, Object> contextMap() {
        RestApiContext restApiContext = RestApiContext.getContext();
        return restApiContext != null ? restApiContext.contextMap : null;
    }

    public static RestApiContext setData(String key, Object value) {
        RestApiContext restApiContext = RestApiContext.getContext();
        if (restApiContext != null) {
            restApiContext.put(key, value);
        }
        return restApiContext;
    }

    public static Object getData(String key) {
        RestApiContext restApiContext = RestApiContext.getContext();
        return restApiContext != null ? RestApiContext.getContext().get(key) : null;
    }

    public static void close() {
        try {
            RestApiContext restApiContext = RestApiContext.getContext();
            if (restApiContext != null) {
                restApiContext.contextMap.clear();
                restApiContext.parametersList.clear();
                RestApiContext.remove();
            }
        }
        catch (Exception ex) {
            log.debug("An error occurred while releasing the RestApiContext:" + ex.getMessage(), (Object)ex);
        }
    }

    public static String getInputParameter() {
        RestApiContext restApiContext = RestApiContext.getContext();
        return restApiContext != null ? restApiContext.inputParameter : "";
    }

    public static String getOutputParameter() {
        RestApiContext restApiContext = RestApiContext.getContext();
        return restApiContext != null ? restApiContext.outputParameter : "";
    }

    public static void setInputParameter(String inputParameter) {
        RestApiContext restApiContext = RestApiContext.getContext();
        if (restApiContext != null) {
            if (inputParameter != null && inputParameter.length() > 2000) {
                inputParameter = inputParameter.substring(0, 2000);
            }
            restApiContext.inputParameter = inputParameter;
        }
    }

    public static void setOutputParameter(String outputParameter) {
        RestApiContext restApiContext = RestApiContext.getContext();
        if (restApiContext != null) {
            if (outputParameter != null && outputParameter.length() > 2000) {
                outputParameter = outputParameter.substring(0, 2000);
            }
            restApiContext.outputParameter = outputParameter;
        }
    }

    private void put(String key, Object value) {
        this.contextMap.put(key, value);
    }

    private Object get(String key) {
        return this.contextMap.get(key);
    }

    public static void remove() {
        threadLocal.remove();
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public String getUrl() {
        return this.url;
    }

    public int getModelTimeCost() {
        return this.modelTimeCost;
    }

    public void setModelTimeCost(int modelTimeCost) {
        this.modelTimeCost = modelTimeCost;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }
}

