/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.servlet.result;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.api.result.RestApiServiceResult;
import kd.bos.nocode.restapi.api.result.RestBaseFilterResult;
import kd.bos.nocode.restapi.common.constant.HttpStatus;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.result.RestApiResult;
import kd.bos.nocode.restapi.common.util.StringUtil;
import kd.bos.nocode.restapi.servlet.context.ParameterHelper;
import kd.bos.nocode.restapi.servlet.context.RestApiContext;
import kd.bos.nocode.restapi.servlet.result.JsonResultHandler;
import kd.bos.nocode.restapi.servlet.result.ResultHandler;
import kd.bos.nocode.restapi.servlet.result.StreamResultHandler;
import kd.bos.nocode.restapi.servlet.utils.ApiStreamUtil;
import kd.bos.nocode.restapi.servlet.utils.ApiUtil;
import kd.bos.nocode.restapi.servlet.utils.RestApiExceptionUtil;
import org.apache.commons.lang3.StringUtils;

public class ResultProcessUtil {
    private ResultProcessUtil() {
    }

    public static void processResultHandler(String contextType, Object resultData, HttpServletResponse resp) {
        ResultHandler resultHandler = new JsonResultHandler();
        if (ApiUtil.isAcceptType("application/octet-stream")) {
            resultHandler = new StreamResultHandler();
        } else if (ApiUtil.isContentType("application/json", contextType)) {
            resultHandler = new JsonResultHandler();
        }
        resultHandler.handleResult(resultData, resp);
    }

    public static void processResult(RestApiServiceData<RestApiServiceResult> apiServiceData, HttpServletRequest req) {
        Map respHeaders = null;
        if (apiServiceData != null && apiServiceData.getResponse() != null) {
            respHeaders = apiServiceData.getResponse().getResponseHeaders();
            ParameterHelper.setResponseHeaders(RestApiContext.getResponse(), respHeaders);
            Object data = apiServiceData.getResponse().getData();
            RestApiResult contextResult = RestApiContext.getResult();
            RestApiContext.getContext().setModelTimeCost(apiServiceData.getModelTimeCost());
            contextResult.setData(data);
            contextResult.setStatus(apiServiceData.isStatus());
            String errorCode = apiServiceData.getErrorCode();
            String message = apiServiceData.getMessage();
            if (apiServiceData.isStatus()) {
                errorCode = RestApiErrorCode.OK.getStatusCode();
                message = ResultProcessUtil.getMessage(data);
                if (StringUtils.isNotBlank((CharSequence)message)) {
                    errorCode = RestApiErrorCode.ERROR.getStatusCode();
                }
            }
            if (!apiServiceData.isStatus() && StringUtil.isEmpty((String)errorCode)) {
                errorCode = RestApiErrorCode.ERROR.getStatusCode();
                message = ResultProcessUtil.getMessage(data);
            }
            contextResult.setErrorCode(errorCode);
            if (!apiServiceData.isStatus() && apiServiceData.getStack() != null) {
                String stackMsg = RestApiExceptionUtil.getExceptionMessage(apiServiceData.getStack());
                if (message == null) {
                    message = "Error occurred,Reason:" + stackMsg;
                }
            }
            contextResult.setMessage(message);
            if (ApiStreamUtil.getStatus() < HttpStatus.BAD_REQUEST.getStatusCode()) {
                int httpStatus = apiServiceData.getResponse().getHttpStatus();
                ApiStreamUtil.sendStatus(httpStatus);
            }
            contextResult.setTraceId(RequestContext.get().getTraceId());
        }
        String contextType = RestApiContext.getRequest() == null ? "" : RestApiContext.getRequest().getHeader("Content-Type");
        ResultProcessUtil.processResultHandler(contextType, RestApiContext.getResult(), RestApiContext.getResponse());
    }

    private static String getMessage(Object data) {
        List result;
        if (data instanceof RestBaseFilterResult && (result = ((RestBaseFilterResult)data).getResult()) != null && !result.isEmpty()) {
            return result.stream().filter(r -> !r.isBillStatus()).map(r -> {
                if (r.getBillIndex() != 0) {
                    List errors = r.getErrors();
                    String errorMessage = errors.stream().map(e -> e.replaceAll("\u3002*$", "")).collect(Collectors.joining("\uff0c"));
                    return ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u8868\u5355\u8bb0\u5f55\uff1a%2$s", (String)"ResultProcessUtil_1", (String)"bos-nocode-core", (Object[])new Object[]{r.getBillIndex(), errorMessage});
                }
                return String.join((CharSequence)"\uff0c", r.getErrors());
            }).collect(Collectors.joining("\uff1b"));
        }
        return "";
    }

    public static void processException(HttpServletRequest req) {
        Throwable exception = RestApiContext.getContext().getException();
        RestApiExceptionUtil.handleException(exception, req);
        ResultProcessUtil.processResult(null, req);
    }
}

